/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.effect.neutral;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModFluids;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.util.TCUtils;

public class ShimmerEffect
extends MobEffect {
    public ShimmerEffect() {
        super(MobEffectCategory.NEUTRAL, 0xFF96FF);
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        Level level = living.level();
        if (level.isClientSide) {
            return true;
        }
        if (living.position().y < (double)(level.getMinBuildHeight() + 5)) {
            return false;
        }
        BlockPos onPos = living.getOnPos();
        if (level.getBlockState(onPos).is(Blocks.BEDROCK)) {
            return false;
        }
        if (level.getFluidState(onPos).getType().getFluidType() != ModFluids.SHIMMER.type().get()) {
            living.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 2, 1, false, false, false));
        }
        boolean shouldExpire = level.getBlockStates(living.getBoundingBox().inflate(-0.1)).allMatch(blockState -> {
            if (blockState.isAir()) {
                return true;
            }
            return blockState.liquid() && !blockState.is((Block)ModBlocks.SHIMMER.get());
        });
        if (amplifier > 0) {
            MobEffectInstance effect;
            if (shouldExpire && (effect = living.getEffect(ModEffects.SHIMMER)) != null) {
                effect.amplifier = 0;
            }
            return true;
        }
        return !shouldExpire;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public static void applyShimmerEffect(LivingEntity living) {
        if (!(living.level().isClientSide || living.getEyeInFluidType() != ModFluids.SHIMMER.type().get() || living.hasEffect(ModEffects.SHIMMER) || !living.isCrouching() && ((Set)TCUtils.getAccessoriesValue((LivingEntity)living, (ValueType)TCItems.EFFECT$IMMUNITIES)).contains(ModEffects.SHIMMER))) {
            living.addEffect(new MobEffectInstance(ModEffects.SHIMMER, -1));
        }
    }
}

