/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record SummonItemEffect(Holder<Item> item, LevelBasedValue count) implements EnchantmentEntityEffect
{
    public static final MapCodec<SummonItemEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(SummonItemEffect::item), (App)LevelBasedValue.CODEC.fieldOf("count").orElseGet(() -> LevelBasedValue.constant((float)1.0f)).forGetter(SummonItemEffect::count)).apply((Applicative)instance, SummonItemEffect::new));

    public SummonItemEffect(Holder<Item> item) {
        this(item, (LevelBasedValue)LevelBasedValue.constant((float)1.0f));
    }

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        float calculated = this.count.calculate(enchantmentLevel);
        int count = (int)calculated;
        if (entity.getRandom().nextFloat() < calculated - (float)count) {
            ++count;
        }
        if (count < 1) {
            return;
        }
        ItemEntity itemEntity = new ItemEntity((Level)level, origin.x, entity.getEyeY(), origin.z, new ItemStack(this.item, count));
        itemEntity.setNoPickUpDelay();
        level.addFreshEntity((Entity)itemEntity);
    }

    public MapCodec<SummonItemEffect> codec() {
        return CODEC;
    }
}

