/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity;

import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.confluence.terraentity.api.entity.Boss;
import org.confluence.terraentity.entity.boss.AbstractTerraBossBase;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.GeoCube;

public class DeadBodyPartEntity
extends Entity {
    @Nullable
    public final Entity dyingEntity;
    @Nullable
    public final Object cube;
    public List<Vector3f> boneRots;
    public List<Vector3f> bonePivots;
    public Vector3f boneOffset;
    public Vector3f modelPartRot;
    public int lifetime;
    public float rotX;
    public float rotY;
    public float rotZ;
    public float xOffset;
    public float yOffset;
    public float zOffset;
    public float minSide;
    public int animTick;
    public boolean stop = false;
    public boolean still = false;
    public ModelPart modelPart;
    public ResourceLocation texture;

    public DeadBodyPartEntity(EntityType<?> entityType, Level level) {
        this(entityType, level, null, null, 0.0f);
    }

    public DeadBodyPartEntity(EntityType<?> entityType, Level level, @Nullable Entity dyingEntity, @Nullable Object cube, float deathSpeed) {
        super(entityType, level);
        this.dyingEntity = dyingEntity;
        this.cube = cube;
        this.lifetime = dyingEntity instanceof AbstractTerraBossBase || dyingEntity instanceof Boss ? level.random.nextInt(60, 75) : level.random.nextInt(20, 30);
        float speed = deathSpeed * 1.36f + 1.5f;
        int stay = this.lifetime % 3;
        if (stay != 0) {
            this.rotX = level.random.nextFloat() * speed * 2.0f - speed;
        }
        if (stay != 1) {
            this.rotY = level.random.nextFloat() * speed * 2.0f - speed;
        }
        if (stay != 2) {
            this.rotZ = level.random.nextFloat() * speed * 2.0f - speed;
        }
    }

    public void still() {
        this.still = true;
        this.lifetime = 100;
    }

    public void tick() {
        if (this.tickCount >= this.lifetime) {
            this.discard();
            return;
        }
        this.refreshDimensions();
        if (this.still) {
            return;
        }
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround()) {
            BlockPos groundPos = this.getBlockPosBelowThatAffectsMyMovement();
            float friction = this.level().getBlockState(groundPos).getFriction((LevelReader)this.level(), groundPos, (Entity)this) * 0.98f;
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)friction, 0.98, (double)friction));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 1.0, 0.9));
        }
        if (this.tickCount > 3 && !this.stop && (this.onGround() || this.verticalCollision || this.verticalCollisionBelow || this.horizontalCollision)) {
            this.stop = true;
        }
        if (!this.stop) {
            this.animTick = this.tickCount;
        }
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    public EntityDimensions getDimensions(Pose pose) {
        Object object = this.cube;
        if (object instanceof GeoCube) {
            GeoCube geoCube = (GeoCube)object;
            Vec3 size = geoCube.size();
            float min = (float)Math.max(0.1, Math.min(Math.min(size.x, size.y), size.z) / 16.0);
            return EntityDimensions.fixed((float)min, (float)min);
        }
        if (this.cube instanceof ModelPart.Cube) {
            return EntityDimensions.fixed((float)this.minSide, (float)this.minSide);
        }
        return EntityDimensions.fixed((float)0.4f, (float)0.4f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }
}

