/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.ModEntities;

public class FlameCloudEntity
extends Entity {
    public FlameCloudEntity(EntityType<FlameCloudEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FlameCloudEntity(Level level, double x, double y, double z) {
        super((EntityType)ModEntities.FLAME_CLOUD.get(), level);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            for (int i = 0; i < 20; ++i) {
                Vec3 offset = this.position().offsetRandom(this.random, 5.0f);
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, offset.x, offset.y + 2.5, offset.z, 0.0, 0.1, 0.0);
            }
        } else {
            for (Entity entity : this.level().getEntities((Entity)this, AABB.encapsulatingFullBlocks((BlockPos)this.blockPosition().offset(-2, -2, -2), (BlockPos)this.blockPosition().offset(2, 2, 2)))) {
                if (entity.fireImmune() && entity.isInWaterRainOrBubble()) continue;
                entity.setRemainingFireTicks(200);
                entity.hurt(this.damageSources().inFire(), ((Float)LibUtils.switchByDifficulty((Level)this.level(), (BlockPos)this.blockPosition(), (Object)Float.valueOf(8.0f), (Object)Float.valueOf(16.0f), (Object)Float.valueOf(24.0f))).floatValue());
            }
        }
        if (this.tickCount > 40) {
            this.discard();
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.tickCount = compound.getInt("Age");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Age", this.tickCount);
    }
}

