/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.functional.SpearTrapBlock;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class SpearEntity
extends Entity {
    private static final EntityDataAccessor<Direction> DATA_DIRECTION = SynchedEntityData.defineId(SpearEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private boolean opened = false;
    private float progress = 0.0f;
    public transient BlockPos trapPos;

    public SpearEntity(EntityType<SpearEntity> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public SpearEntity(Level level, Direction direction) {
        this((EntityType<SpearEntity>)((EntityType)ModEntities.SPEAR.get()), level);
        this.setDirection(direction);
    }

    public void tick() {
        if (!this.level().isClientSide && this.trapPos == null) {
            this.discard();
            return;
        }
        if (this.opened) {
            this.progress -= 0.05f;
            if (this.progress <= 0.0f) {
                this.opened = false;
                this.progress = 0.0f;
                if (!this.level().isClientSide) {
                    this.level().setBlockAndUpdate(this.trapPos, (BlockState)this.level().getBlockState(this.trapPos).setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(true)));
                    SpearTrapBlock block = (SpearTrapBlock)FunctionalBlocks.SPEAR_TRAP.get();
                    this.level().scheduleTick(this.trapPos, (Block)block, block.delay());
                }
                this.discard();
                return;
            }
        } else {
            this.progress += 0.05f;
            if (this.progress >= 1.0f) {
                this.opened = true;
                this.progress = 1.0f;
            } else {
                BlockState blockState = this.level().getBlockState(this.blockPosition().relative(this.getDirection(), Mth.ceil((float)(13.0f * this.progress))));
                if (!blockState.isAir() && !blockState.liquid()) {
                    this.opened = true;
                }
            }
        }
        this.setBoundingBox(Shulker.getProgressAabb((float)1.0f, (Direction)this.getDirection(), (float)(13.0f * this.progress)).move(this.getX() - 0.5, this.getY(), this.getZ() - 0.5));
        Vec3 startVec = this.position().relative(this.getDirection().getOpposite(), 1.0);
        Vec3 endVec = this.position().relative(this.getDirection(), (double)Mth.ceil((float)(13.0f * this.progress)));
        AABB boundingBox = this.getBoundingBox().inflate((double)0.3f);
        for (Entity entity1 : this.level().getEntities((Entity)this, boundingBox, entity -> entity instanceof LivingEntity)) {
            AABB aabb = entity1.getBoundingBox().inflate(0.3);
            if (!aabb.clip(startVec, endVec).isPresent()) continue;
            entity1.hurt(ModDamageTypes.of(this.level(), (ResourceKey<DamageType>)DamageTypes.STING), (float)((Integer)LibUtils.switchByDifficulty((Level)this.level(), (BlockPos)this.blockPosition(), (Object)24, (Object)48, (Object)72)).intValue());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_DIRECTION, (Object)Direction.NORTH);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setDirection((Direction)Direction.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("Direction")).getOrThrow());
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.put("Direction", (Tag)Direction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getDirection()).getOrThrow());
    }

    public void setDirection(Direction direction) {
        this.entityData.set(DATA_DIRECTION, (Object)direction);
    }

    public Direction getDirection() {
        return (Direction)this.entityData.get(DATA_DIRECTION);
    }
}

