/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity;

import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.item.common.TargetDummyItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetDummyEntity
extends LivingEntity {
    public float damage;

    public TargetDummyEntity(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isDeadOrDying() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        Player player;
        Entity entity = source.getEntity();
        if (entity instanceof Player && (player = (Player)entity).isCrouching() && player.onGround()) {
            if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof PickaxeItem) {
                this.discard();
                LibUtils.createItemEntity((ItemStack)((TargetDummyItem)((Object)ToolItems.TARGET_DUMMY.get())).getDefaultInstance(), (Vec3)this.position(), (Level)player.level(), (int)0);
                return true;
            }
            if (player.isCreative()) {
                this.discard();
            }
        }
        if (source.is(DamageTypes.GENERIC_KILL)) {
            this.discard();
        }
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
        entity = this.level();
        if (entity instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)entity;
            sl.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.HAY_BLOCK.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), Math.min(100, (int)amount), (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
        return super.hurt(source, amount);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return NonNullList.create();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public void tick() {
        if (this.getHealth() != this.getMaxHealth()) {
            this.damage = this.getMaxHealth() - this.getHealth();
            this.setHealth(this.getMaxHealth());
        }
        super.tick();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.MAX_HEALTH, 1024.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Nullable
    public ItemStack getPickResult() {
        return ((TargetDummyItem)((Object)ToolItems.TARGET_DUMMY.get())).getDefaultInstance();
    }

    public boolean isPushable() {
        return false;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }
}

