/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.fishing;

import java.util.function.IntFunction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.entity.fishing.AbstractFishingHook;
import org.confluence.mod.common.init.ModEntities;

public class BaseFishingHook
extends AbstractFishingHook
implements VariantHolder<Variant> {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(BaseFishingHook.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BaseFishingHook(EntityType<BaseFishingHook> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BaseFishingHook(Player player, Level pLevel, int pLuck, int pLureSpeed, Variant variant) {
        super((EntityType<? extends FishingHook>)((EntityType)ModEntities.BASE_FISHING_HOOK.get()), pLevel, pLuck, pLureSpeed);
        this.setVariant(variant);
        this.setup(player);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)0);
    }

    public void setVariant(Variant pVariant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)pVariant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public static enum Variant implements StringRepresentable
    {
        WOOD(0, "wood"),
        REINFORCED(1, "reinforced"),
        FISHER_OF_SOULS(2, "fisher_of_souls"),
        FLESHCATCHER(3, "fleshcatcher"),
        SCARAB(4, "scarab"),
        FIBERGLASS(5, "fiberglass"),
        MECHANICS(6, "mechanics"),
        SITTING_DUCKS(7, "sitting_ducks"),
        GOLDEN(8, "golden");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

