/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.fishing;

import java.util.function.IntFunction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.entity.fishing.AbstractFishingHook;
import org.confluence.mod.common.init.ModEntities;

public class CurioFishingHook
extends AbstractFishingHook
implements VariantHolder<Variant> {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(CurioFishingHook.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CurioFishingHook(EntityType<CurioFishingHook> entityType, Level level) {
        super(entityType, level);
    }

    public CurioFishingHook(Player player, Level level, int luck, int lureSpeed, Variant variant) {
        super((EntityType<? extends FishingHook>)((EntityType)ModEntities.CURIO_FISHING_HOOK.get()), level, luck, lureSpeed);
        this.setVariant(variant);
        this.setup(player);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)0);
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)variant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public static enum Variant implements StringRepresentable
    {
        COMMON(0, "common"),
        GLOWING(1, "glowing"),
        LAVA(2, "lava"),
        HELIUM(3, "helium"),
        NEON(4, "neon"),
        ARGON(5, "argon"),
        KRYPTON(6, "krypton"),
        XENON(7, "xenon");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

