/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.hook;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.item.hook.BaseHookItem;

public abstract class AbstractHookEntity
extends Projectile {
    protected static final EntityDataAccessor<Integer> DATA_HOOK_STATE = SynchedEntityData.defineId(AbstractHookEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> DATA_POP_VELOCITY = SynchedEntityData.defineId(AbstractHookEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public final float hookRangeSqr;
    protected final BaseHookItem.HookType hookType;
    protected BlockPos hookPos;
    protected BlockState hookedState;
    public float lastDelta = 0.0f;

    public AbstractHookEntity(EntityType<? extends AbstractHookEntity> entityType, Level pLevel) {
        super(entityType, pLevel);
        this.hookRangeSqr = 0.0f;
        this.hookType = null;
    }

    public AbstractHookEntity(EntityType<? extends AbstractHookEntity> entityType, BaseHookItem item, Player player, Level level) {
        super(entityType, level);
        this.hookRangeSqr = item.getHookRange() * item.getHookRange();
        this.hookType = item.getHookType();
        this.setPopVelocity(item.getHookVelocity() * 0.2f);
        this.setOwner((Entity)player);
        this.setNoGravity(true);
        this.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_HOOK_STATE, (Object)0).define(DATA_POP_VELOCITY, (Object)Float.valueOf(0.2f));
    }

    public HookState getHookState() {
        return HookState.byId((Integer)this.entityData.get(DATA_HOOK_STATE));
    }

    public void setHookState(HookState state) {
        this.entityData.set(DATA_HOOK_STATE, (Object)state.id);
    }

    public float getPopVelocity() {
        return ((Float)this.entityData.get(DATA_POP_VELOCITY)).floatValue();
    }

    public void setPopVelocity(float velocity) {
        this.entityData.set(DATA_POP_VELOCITY, (Object)Float.valueOf(velocity));
    }

    public double getPullVelocity() {
        return 0.15;
    }

    public void tick() {
        Player player;
        Entity owner;
        block14: {
            block13: {
                super.tick();
                owner = this.getOwner();
                if (!(owner instanceof Player)) break block13;
                player = (Player)owner;
                if (!owner.isRemoved()) break block14;
            }
            this.discard();
            return;
        }
        Vec3 motion = this.getDeltaMovement();
        double x = this.getX() + motion.x;
        double y = this.getY() + motion.y;
        double z = this.getZ() + motion.z;
        this.setPos(x, y, z);
        HookState hookState = this.getHookState();
        if (hookState == HookState.POP) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(owner.position().subtract(this.position()).normalize().scale((double)this.getPopVelocity())));
            if (this.distanceToSqr(owner) < 4.0) {
                this.discard();
                return;
            }
        }
        if (!this.level().isClientSide) {
            ItemStack hook = ExtraInventory.of((LivingEntity)player).getHook(false);
            if (hookState != HookState.POP && this.distanceToSqr(owner) > (double)this.hookRangeSqr) {
                this.setHookState(HookState.POP);
            } else if (hookState == HookState.PUSH) {
                Vec3 pos = this.position();
                Vec3 nextPos = pos.add(this.getDeltaMovement());
                BlockHitResult hitResult = this.level().clip(new ClipContext(pos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (hitResult.getType() == HitResult.Type.BLOCK) {
                    this.onHitBlock(hitResult);
                    this.onHooked(hitResult, hook);
                }
            } else if (hookState == HookState.HOOKED && (this.hookPos == null || this.level().getBlockState(this.hookPos) != this.hookedState)) {
                this.setHookState(HookState.POP);
            }
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Vec3 vec3 = result.getLocation().subtract(this.position());
        this.setDeltaMovement(vec3);
        Vec3 vec31 = vec3.normalize().scale((double)0.05f);
        this.setPosRaw(this.getX() - vec31.x, this.getY() - vec31.y, this.getZ() - vec31.z);
        this.setPos(this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
    }

    protected void onHooked(BlockHitResult hitResult, ItemStack itemStack) {
        BlockPos blockPos = hitResult.getBlockPos();
        BlockState blockState = this.level().getBlockState(blockPos);
        this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockPos, GameEvent.Context.of((Entity)this, (BlockState)blockState));
        this.setDeltaMovement(Vec3.ZERO);
        this.setHookState(HookState.HOOKED);
        this.hookPos = blockPos;
        this.hookedState = blockState;
        this.hasImpulse = true;
        float ratio = this.getOwner() == null ? 1.0f : Mth.sqrt((float)((float)blockPos.distSqr((Vec3i)this.getOwner().blockPosition()))) / Mth.sqrt((float)this.hookRangeSqr);
        this.playSound((SoundEvent)ModSoundEvents.HOOK_ATTACH.get(), 0.5f * ratio, 1.0f);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState).setPos(blockPos), this.getX(), this.getY() + 0.5, this.getZ(), (int)(175.0f * ratio), 0.0, 0.0, 0.0, 0.15);
        }
    }

    public void shootFromRotation(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        float cos = Mth.cos((float)(pX * ((float)Math.PI / 180)));
        float ry = pY * ((float)Math.PI / 180);
        float x = -Mth.sin((float)ry) * cos;
        float y = -Mth.sin((float)((pX + pZ) * ((float)Math.PI / 180)));
        float z = Mth.cos((float)ry) * cos;
        this.shoot(x, y, z, pVelocity, pInaccuracy);
        Vec3 motion = pShooter.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(motion.x, 0.0, motion.z));
    }

    public BaseHookItem.HookType getHookType() {
        return this.hookType;
    }

    public static enum HookState implements StringRepresentable
    {
        PUSH(0, "push"),
        POP(1, "pop"),
        HOOKED(2, "hooked");

        public static final Codec<HookState> CODEC;
        private static final IntFunction<HookState> BY_ID;
        final int id;
        private final String name;

        private HookState(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static HookState byId(int pId) {
            return BY_ID.apply(pId);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(HookState::values);
            BY_ID = ByIdMap.continuous(HookState::getId, (Object[])HookState.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public static class Impl
    extends AbstractHookEntity {
        public Impl(EntityType<? extends AbstractHookEntity> entityType, Level pLevel) {
            super(entityType, pLevel);
        }

        public Impl(EntityType<? extends AbstractHookEntity> entityType, BaseHookItem item, Player player, Level level) {
            super(entityType, item, player, level);
        }
    }
}

