/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.hook;

import java.util.function.IntFunction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.entity.hook.AbstractHookEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.item.hook.BaseHookItem;

public class DualHookEntity
extends AbstractHookEntity
implements VariantHolder<Variant> {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(DualHookEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public DualHookEntity(EntityType<DualHookEntity> entityType, Level pLevel) {
        super(entityType, pLevel);
    }

    public DualHookEntity(BaseHookItem item, Player player, Level level, Variant variant) {
        super((EntityType<? extends AbstractHookEntity>)((EntityType)ModEntities.DUAL_HOOK.get()), item, player, level);
        this.setVariant(variant);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)0);
    }

    public void setVariant(Variant pVariant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)pVariant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    @Override
    protected void onHooked(BlockHitResult hitResult, ItemStack itemStack) {
        super.onHooked(hitResult, itemStack);
        Tag tag2 = LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack).get("hooks");
        if (tag2 instanceof ListTag) {
            ListTag list = (ListTag)tag2;
            list.forEach(tag -> {
                AbstractHookEntity hookEntity = BaseHookItem.getHookEntity(tag, this.level());
                if (hookEntity != null && hookEntity != this) {
                    hookEntity.setHookState(AbstractHookEntity.HookState.POP);
                }
            });
        }
    }

    public static enum Variant implements StringRepresentable
    {
        RED(0, "red"),
        BLUE(1, "blue");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

