/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.hook;

import java.util.function.IntFunction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.entity.hook.AbstractHookEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.item.hook.BaseHookItem;

public class LunarHookEntity
extends AbstractHookEntity
implements VariantHolder<Variant> {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(LunarHookEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public LunarHookEntity(EntityType<LunarHookEntity> entityType, Level pLevel) {
        super(entityType, pLevel);
    }

    public LunarHookEntity(BaseHookItem item, Player player, Level level, Variant variant) {
        super((EntityType<? extends AbstractHookEntity>)((EntityType)ModEntities.LUNAR_HOOK.get()), item, player, level);
        this.setVariant(variant);
    }

    @Override
    public double getPullVelocity() {
        return 0.2196;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)0);
    }

    public void setVariant(Variant pVariant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)pVariant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public static enum Variant implements StringRepresentable
    {
        NEBULA(0, "nebula"),
        SOLAR(1, "solar"),
        STARDUST(2, "stardust"),
        VORTEX(3, "vortex");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

