/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.component.prefix.PrefixComponent;
import org.confluence.mod.common.init.ModDataComponentTypes;

public abstract class DamageSettableProjectile
extends Projectile {
    protected static final EntityDataAccessor<Float> DATA_DEFAULT_VELOCITY = SynchedEntityData.defineId(DamageSettableProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected float damage;

    public DamageSettableProjectile(EntityType<? extends DamageSettableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_DEFAULT_VELOCITY, (Object)Float.valueOf(0.0f));
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getCalculatedDamage() {
        PrefixComponent component;
        LivingEntity living;
        ItemStack itemStack;
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity && !(itemStack = (living = (LivingEntity)entity).getMainHandItem()).isEmpty() && (component = (PrefixComponent)itemStack.get(ModDataComponentTypes.PREFIX)) != null) {
            double d0 = this.damage;
            for (AttributeModifier modifier : component.modifiers().get().get((Object)Attributes.ATTACK_DAMAGE)) {
                if (modifier.operation() == AttributeModifier.Operation.ADD_VALUE) {
                    d0 += modifier.amount();
                }
                double d1 = d0;
                if (modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE) {
                    d1 += d0 * modifier.amount();
                }
                if (modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) {
                    d1 *= 1.0 + modifier.amount();
                }
                d0 = d1;
            }
            return (float)((Attribute)Attributes.ATTACK_DAMAGE.value()).sanitizeValue(d0);
        }
        return this.damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDefaultVelocity(float defaultVelocity) {
        this.entityData.set(DATA_DEFAULT_VELOCITY, (Object)Float.valueOf(defaultVelocity));
    }

    public float getDefaultVelocity() {
        return ((Float)this.entityData.get(DATA_DEFAULT_VELOCITY)).floatValue();
    }

    public Vec3 getMovementToShoot(double x, double y, double z, float velocity, float inaccuracy) {
        this.setDefaultVelocity(velocity);
        return super.getMovementToShoot(x, y, z, velocity, inaccuracy);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damage = compound.getFloat("Damage");
        this.setDefaultVelocity(compound.getFloat("DefaultVelocity"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Damage", this.damage);
        compound.putFloat("DefaultVelocity", this.getDefaultVelocity());
    }
}

