/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.confluence.lib.mixed.LibLivingEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.item.ModItems;

public class IceTofuBrickProjectile
extends ThrowableItemProjectile {
    public IceTofuBrickProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public IceTofuBrickProjectile(double x, double y, double z, Level level) {
        super((EntityType)ModEntities.ICE_TOFU_BRICK_PROJECTILE.get(), x, y, z, level);
    }

    public IceTofuBrickProjectile(LivingEntity shooter, Level level) {
        super((EntityType)ModEntities.ICE_TOFU_BRICK_PROJECTILE.get(), shooter, level);
    }

    protected void onHitEntity(EntityHitResult result) {
        this.freezeTarget();
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        this.freezeTarget();
        super.onHitBlock(result);
    }

    private void freezeTarget() {
        LivingEntity living2;
        Entity entity;
        DamageSource source = this.damageSources().mobProjectile((Entity)this, (entity = this.getOwner()) instanceof LivingEntity ? (living2 = (LivingEntity)entity) : null);
        for (LivingEntity living3 : this.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.position().add(-1.0, -1.0, -1.0), this.position().add(1.0, 1.0, 1.0)), living -> !(living instanceof Player))) {
            living3.hurt(source, 9.0f);
            ((LibLivingEntity)living3).confluence$setTickFreezeTime(100);
        }
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.ICE_TOFU_BRICK.get();
    }
}

