/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.common.BaseRopeBlock;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.ToolItems;

public class RopeCoilsProjectile
extends ThrowableItemProjectile {
    public static final int SIZE = 4;
    private final Item ropeCoil;
    private final Block rope;
    BlockPos pos;

    public RopeCoilsProjectile(EntityType<? extends RopeCoilsProjectile> type, Level level) {
        super(type, level);
        this.ropeCoil = (Item)ToolItems.ROPE_COIL.get();
        this.rope = (Block)ModBlocks.ROPE.get();
    }

    public RopeCoilsProjectile(double x, double y, double z, Level level) {
        super((EntityType)ModEntities.ROPE_COILS.get(), x, y, z, level);
        this.ropeCoil = (Item)ToolItems.ROPE_COIL.get();
        this.rope = (Block)ModBlocks.ROPE.get();
    }

    public RopeCoilsProjectile(LivingEntity shooter, Level level, Item ropeCoil, Block rope) {
        super((EntityType)ModEntities.ROPE_COILS.get(), shooter, level);
        this.ropeCoil = ropeCoil;
        this.rope = rope;
    }

    public Item getRopeCoil() {
        return this.ropeCoil;
    }

    public Block getRope() {
        return this.rope;
    }

    protected Item getDefaultItem() {
        return Items.AIR;
    }

    protected void onHitBlock(BlockHitResult result) {
        Level level = this.level();
        if (level.isClientSide) {
            return;
        }
        Direction offset = result.getDirection();
        BlockPos pos = result.getBlockPos().relative(offset);
        boolean isPlaced = false;
        if (level.isEmptyBlock(pos) || level.getBlockState(pos).canBeReplaced()) {
            int i;
            int up = 0;
            int down = 0;
            for (i = 0; i < 4 && level.isEmptyBlock(pos.above(i)); ++i) {
                ++up;
            }
            for (i = 0; i < 4 && level.isEmptyBlock(pos.below(i)); ++i) {
                ++down;
            }
            boolean willUp = up > down;
            BlockState state = this.rope.defaultBlockState();
            isPlaced = RopeCoilsProjectile.place(this.rope, willUp, state, level, pos);
        }
        if (!isPlaced) {
            LibUtils.createItemEntity((ItemStack)this.ropeCoil.getDefaultInstance(), (Vec3)pos.getCenter(), (Level)level, (int)0);
        }
        this.discard();
        super.onHitBlock(result);
    }

    public static boolean place(Block rope, boolean willUp, BlockState state, Level level, BlockPos pos) {
        return RopeCoilsProjectile.place(rope, willUp, state, level, pos, 0);
    }

    public static void createRope(Block rope, int offset, int i, BlockPos pos, Level level) {
        LibUtils.createItemEntity((Item)rope.asItem(), (int)(4 + offset - i), (Vec3)Vec3.atLowerCornerOf((Vec3i)pos), (Level)level, (int)0);
    }

    public static boolean place(Block rope, boolean willUp, BlockState state, Level level, BlockPos pos, int offset) {
        boolean isPlaced = false;
        if (willUp) {
            for (int i = offset; i < 4 + offset; ++i) {
                if (state.canSurvive((LevelReader)level, pos.above(i)) && level.isEmptyBlock(pos.above(i))) {
                    if (!level.setBlockAndUpdate(pos.above(i), state)) {
                        if (i == offset) break;
                        RopeCoilsProjectile.createRope(rope, offset, i, pos, level);
                        break;
                    }
                } else {
                    isPlaced = true;
                    RopeCoilsProjectile.createRope(rope, offset, i, pos, level);
                    break;
                }
                isPlaced = true;
            }
        } else {
            for (int i = offset; i < 4 + offset; ++i) {
                if (state.canSurvive((LevelReader)level, pos.below(i)) && level.isEmptyBlock(pos.below(i))) {
                    if (!level.setBlockAndUpdate(pos.below(i), state)) {
                        if (i == offset) break;
                        RopeCoilsProjectile.createRope(rope, offset, i, pos, level);
                        break;
                    }
                } else {
                    isPlaced = true;
                    RopeCoilsProjectile.createRope(rope, offset, i, pos, level);
                    break;
                }
                isPlaced = true;
            }
        }
        return isPlaced;
    }

    public void tick() {
        super.tick();
        BlockPos tempPos = BlockPos.containing((Position)this.position());
        if (!tempPos.equals((Object)this.pos)) {
            this.pos = tempPos;
            Level level = this.level();
            Block block = level.getBlockState(this.pos).getBlock();
            if (block instanceof BaseRopeBlock) {
                BlockState state;
                int i;
                int up = 0;
                int down = 0;
                for (i = 1; i < 5 && level.getBlockState(this.pos.above(i)).isAir(); ++i) {
                    ++up;
                }
                for (i = 1; i < 5 && level.getBlockState(this.pos.below(i)).isAir(); ++i) {
                    ++down;
                }
                boolean willUp = up > down;
                boolean isPlaced = RopeCoilsProjectile.place(this.rope, willUp, state = this.rope.defaultBlockState(), level, this.pos, 1);
                if (!isPlaced) {
                    LibUtils.createItemEntity((Item)this.ropeCoil, (int)1, (Vec3)Vec3.atLowerCornerOf((Vec3i)this.pos), (Level)level, (int)0);
                }
                this.discard();
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level = this.level();
        if (level.isClientSide) {
            return;
        }
        BlockPos pos = result.getEntity().getOnPos();
        LibUtils.createItemEntity((Item)this.ropeCoil, (int)1, (Vec3)Vec3.atLowerCornerOf((Vec3i)pos), (Level)level, (int)0);
        this.remove(Entity.RemovalReason.DISCARDED);
        super.onHitEntity(result);
    }
}

