/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.item.ConsumableItems;

public class ThrownWaterProjectile
extends ThrowableItemProjectile {
    private final ISpreadable.Type type;

    public ThrownWaterProjectile(EntityType<ThrownWaterProjectile> entityType, Level level) {
        super(entityType, level);
        this.type = ISpreadable.Type.PURE;
    }

    public ThrownWaterProjectile(LivingEntity shooter, ISpreadable.Type type) {
        super((EntityType)ModEntities.THROWN_WATER_PROJECTILE.get(), shooter, shooter.level());
        this.type = type;
    }

    protected Item getDefaultItem() {
        if (this.type == ISpreadable.Type.CORRUPT) {
            return (Item)ConsumableItems.UNHOLY_WATER.get();
        }
        if (this.type == ISpreadable.Type.CRIMSON) {
            return (Item)ConsumableItems.BLOOD_WATER.get();
        }
        return (Item)ConsumableItems.HOLY_WATER.get();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            BlockPos blockPos = result.getBlockPos();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-2, -2, -2), (BlockPos)blockPos.offset(2, 2, 2))) {
                if (!(pos.distSqr((Vec3i)blockPos) <= 25.0)) continue;
                this.type.spread(this.level(), pos);
            }
            this.level().levelEvent(2002, this.blockPosition(), this.getColor());
            this.discard();
        }
    }

    protected int getColor() {
        if (this.type == ISpreadable.Type.CORRUPT) {
            return 0xFF00FF;
        }
        if (this.type == ISpreadable.Type.CRIMSON) {
            return 0xFF0000;
        }
        return 255;
    }
}

