/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.util.ModUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class TitaniumShardsProjectile
extends Projectile {
    private static final EntityDataAccessor<Integer> DATA_SHARDS_AMOUNT = SynchedEntityData.defineId(TitaniumShardsProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.defineId(TitaniumShardsProjectile.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public List<Vector3d> shardPos = new ArrayList<Vector3d>();
    public List<Vector3d> shardPosO = new ArrayList<Vector3d>();
    private boolean synced;

    public TitaniumShardsProjectile(EntityType<TitaniumShardsProjectile> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
        this.setInvulnerable(true);
        this.noPhysics = true;
    }

    public TitaniumShardsProjectile(Player player) {
        this((EntityType<TitaniumShardsProjectile>)((EntityType)ModEntities.TITANIUM_SHARDS_PROJECTILE.get()), player.level());
        this.setPos(player.position());
        this.setOwner((Entity)player);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SHARDS_AMOUNT, (Object)7).define(DATA_OWNER_UUID, Optional.empty());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide && DATA_OWNER_UUID.equals(key)) {
            this.ownerUUID = ((Optional)this.entityData.get(DATA_OWNER_UUID)).orElse(null);
            this.synced = true;
        }
    }

    public void baseTick() {
        Player player = this.getOwner();
        if (player == null) {
            if (!this.synced) {
                return;
            }
            this.discard();
        } else if (!player.hasEffect(ModEffects.TITANIUM_BARRIER)) {
            this.discard();
        }
        int amount = (Integer)this.entityData.get(DATA_SHARDS_AMOUNT);
        if (amount <= 0) {
            this.discard();
        }
        if (this.isRemoved()) {
            return;
        }
        assert (player != null);
        this.setPos(player.position());
        this.xo = player.xo;
        this.yo = player.yo;
        this.zo = player.zo;
        if (amount != this.shardPos.size()) {
            ArrayList<Vector3d> shardPos = new ArrayList<Vector3d>();
            ArrayList<Vector3d> shardPosO = new ArrayList<Vector3d>();
            double d = Math.PI * 2 / (double)amount;
            for (int i = 0; i < amount; ++i) {
                Vector3d e = new Vector3d(1.0 + (double)amount / 10.0, 0.0, 0.0).rotateY(d * (double)i);
                shardPos.add(e);
                shardPosO.add(new Vector3d((Vector3dc)e));
            }
            this.shardPos = shardPos;
            this.shardPosO = shardPosO;
        }
        double r = Math.PI * Mth.lerp((double)((double)amount / 8.0), (double)0.05, (double)0.2);
        for (int i = 0; i < amount; ++i) {
            Vector3d end = this.shardPos.get(i);
            end.y = (double)player.getBbHeight() * 0.5;
            Vector3d start = this.shardPosO.get(i).set((Vector3dc)end);
            end.rotateY(r);
            if (this.level().isClientSide) continue;
            Vec3 startVec = this.position().add(start.x, start.y, start.z);
            Vec3 endVec = this.position().add(end.x, end.y, end.z);
            AABB aabb = new AABB(startVec, endVec).inflate(0.5);
            EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)aabb, this::canHitEntity);
            if (hitResult == null || !hitResult.getEntity().hurt(ModDamageTypes.of(this.level(), (ResourceKey<DamageType>)DamageTypes.GENERIC, (Entity)this, (Entity)this.getOwner()), 10.0f)) continue;
            VectorUtils.knockBackA2B((Entity)this, (Entity)hitResult.getEntity(), (double)1.0, (double)0.4);
            this.entityData.set(DATA_SHARDS_AMOUNT, (Object)(amount - 1));
        }
    }

    protected boolean canHitEntity(Entity target) {
        return ModUtils.canHitEntity(target, (Entity)this.getOwner());
    }

    public void setOwner(@Nullable Entity owner) {
        if (owner != null && !(owner instanceof Player)) {
            throw new IllegalArgumentException("Owner must be a player!");
        }
        super.setOwner(owner);
    }

    @Nullable
    public Player getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return (Player)this.cachedOwner;
        }
        if (this.ownerUUID != null) {
            this.cachedOwner = this.level().getPlayerByUUID(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public boolean isPickable() {
        return false;
    }
}

