/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.bomb;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.confluence.lib.util.MultiplyExplosionDamageCalculator;
import org.confluence.mod.common.entity.projectile.bomb.BaseBombEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.util.TerraStyleExplosion;

public class BaseGrenadeEntity
extends BaseBombEntity {
    public static final float DIAMETER = 0.125f;

    public BaseGrenadeEntity(EntityType<? extends BaseGrenadeEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.diameter = 0.125f;
    }

    public BaseGrenadeEntity(EntityType<? extends BaseGrenadeEntity> entityType, LivingEntity pShooter) {
        super(entityType, pShooter);
        this.diameter = 0.125f;
    }

    public BaseGrenadeEntity(LivingEntity shooter) {
        this((EntityType<? extends BaseGrenadeEntity>)((EntityType)ModEntities.GRENADE.get()), shooter);
    }

    @Override
    public double getDefaultGravity() {
        return 0.08;
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.explodeFunction(level2);
            this.discard();
        }
    }

    @Override
    protected void explodeFunction(ServerLevel level) {
        TerraStyleExplosion.terraExplode(level, (Entity)this, Explosion.getDefaultDamageSource((Level)level, (Entity)this), this.getExplosionDamageCalculator(), this.getX(), this.getY(), this.getZ(), 1.5f, Level.ExplosionInteraction.NONE);
    }

    @Override
    protected ExplosionDamageCalculator getExplosionDamageCalculator() {
        return new MultiplyExplosionDamageCalculator(2.0f);
    }

    @Override
    protected void createEmitter() {
    }
}

