/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.bomb;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.lib.util.MultiplyExplosionDamageCalculator;
import org.confluence.mod.common.entity.projectile.bomb.BaseBombEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.util.TerraStyleExplosion;

public class DryBombEntity
extends BaseBombEntity {
    protected int radius = 4;

    public DryBombEntity(EntityType<DryBombEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public DryBombEntity(LivingEntity pShooter) {
        super((EntityType<? extends BaseBombEntity>)((EntityType)ModEntities.DRY_BOMB.get()), pShooter);
    }

    @Override
    protected void explodeFunction(ServerLevel level) {
        BlockPos blockPos = this.blockPosition();
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        BlockState air = Blocks.AIR.defaultBlockState();
        for (int i = -this.radius; i < this.radius; ++i) {
            int x = blockPos.getX() + i;
            for (int j = -this.radius; j < this.radius; ++j) {
                int y = blockPos.getY() + j;
                for (int k = -this.radius; k < this.radius; ++k) {
                    int z = blockPos.getZ() + k;
                    mutable.set(x, y, z);
                    if (level.getFluidState((BlockPos)mutable).isEmpty()) continue;
                    level.setBlockAndUpdate((BlockPos)mutable, air);
                }
            }
        }
        TerraStyleExplosion.terraExplode(level, (Entity)this, Explosion.getDefaultDamageSource((Level)level, (Entity)this), (ExplosionDamageCalculator)new MultiplyExplosionDamageCalculator(0.9f), this.getX(), this.getY(), this.getZ(), this.radius, Level.ExplosionInteraction.NONE);
    }
}

