/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.bomb;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.confluence.lib.util.MultiplyExplosionDamageCalculator;
import org.confluence.mod.common.entity.projectile.bomb.BaseBombEntity;
import org.confluence.mod.util.TerraStyleExplosion;

public class LiquidBombEntity
extends BaseBombEntity {
    private BlockState toFill;
    private int radius;

    public LiquidBombEntity(EntityType<? extends LiquidBombEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public LiquidBombEntity(EntityType<? extends LiquidBombEntity> pEntityType, LivingEntity pShooter, Fluid fluid, int radius) {
        super(pEntityType, pShooter);
        this.toFill = fluid.defaultFluidState().createLegacyBlock();
        this.radius = radius;
    }

    @Override
    protected void explodeFunction(ServerLevel level) {
        if (!level.dimensionType().ultraWarm() || this.toFill.getFluidState().getType().getFluidType() != NeoForgeMod.WATER_TYPE.value()) {
            BlockPos blockPos = this.blockPosition();
            BlockPos.MutableBlockPos mutable = blockPos.mutable();
            for (int i = -this.radius; i < this.radius; ++i) {
                int x = blockPos.getX() + i;
                for (int j = 0; j < this.radius; ++j) {
                    int y = blockPos.getY() + j;
                    for (int k = -this.radius; k < this.radius; ++k) {
                        int z = blockPos.getZ() + k;
                        mutable.set(x, y, z);
                        if (!level.getBlockState((BlockPos)mutable).isEmpty()) continue;
                        level.setBlockAndUpdate((BlockPos)mutable, this.toFill);
                    }
                }
            }
        }
        TerraStyleExplosion.terraExplode(level, (Entity)this, Explosion.getDefaultDamageSource((Level)level, (Entity)this), (ExplosionDamageCalculator)new MultiplyExplosionDamageCalculator(0.9f), this.getX(), this.getY(), this.getZ(), this.radius, Level.ExplosionInteraction.NONE);
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.isInFluidType()) {
                this.explodeFunction(level2);
                this.discard();
            }
        }
    }
}

