/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.bomb;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.MultiplyExplosionDamageCalculator;
import org.confluence.mod.common.entity.projectile.bomb.StickyBombEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.block.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class ScarabBombEntity
extends StickyBombEntity {
    private static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.defineId(ScarabBombEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private Vec3 facingDir = new Vec3(0.0, -1.0, 0.0);
    private Entity owner;

    public ScarabBombEntity(EntityType<? extends ScarabBombEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends StickyBombEntity>)pEntityType, pLevel);
        this.blastPower = 5.0f;
    }

    public ScarabBombEntity(LivingEntity pShooter) {
        super((EntityType<? extends StickyBombEntity>)((EntityType)ModEntities.SCARAB_BOMB_ENTITY.get()), pShooter);
        this.blastPower = 5.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_OWNER_ID, (Object)-1);
    }

    @Override
    protected void explodeFunction(ServerLevel level) {
        Vec3 blastPos = this.getEyePosition();
        Vec3 step = this.facingDir.normalize().scale(-3.0);
        float upperLimit = ModBlocks.getObsidianBasedExplosionResistance(50.0f);
        ObjectArrayList objectArrayList = new ObjectArrayList();
        DamageSource damageSource = Explosion.getDefaultDamageSource((Level)level, (Entity)this);
        MultiplyExplosionDamageCalculator damageCalculator = new MultiplyExplosionDamageCalculator(0.2f);
        for (int i = 0; i < 24; ++i) {
            if (i % 3 != 0) continue;
            Explosion explosion = level.explode((Entity)this, damageSource, (ExplosionDamageCalculator)damageCalculator, blastPos.x(), blastPos.y(), blastPos.z(), this.blastPower, false, Level.ExplosionInteraction.MOB);
            Vec3 end = blastPos.add(step);
            BlockPos.betweenClosedStream((AABB)new AABB(blastPos, end)).forEach(blockPos -> {
                if (!level.isLoaded(blockPos)) {
                    return;
                }
                BlockState blockState = level.getBlockState(blockPos);
                if (blockState.getExplosionResistance((BlockGetter)level, blockPos, explosion) < upperLimit) {
                    level.getProfiler().push("explosion_blocks");
                    if (blockState.canDropFromExplosion((BlockGetter)level, blockPos, explosion)) {
                        BlockEntity blockentity = blockState.hasBlockEntity() ? level.getBlockEntity(blockPos) : null;
                        LootParams.Builder lootparams$builder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockentity).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this);
                        blockState.spawnAfterBreak(level, blockPos, ItemStack.EMPTY, this.getOwner() instanceof Player);
                        blockState.getDrops(lootparams$builder).forEach(itemStack -> ScarabBombEntity.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectArrayList, itemStack, blockPos));
                    }
                    blockState.onBlockExploded((Level)level, blockPos, explosion);
                    level.getProfiler().pop();
                }
            });
            blastPos = end;
        }
        for (Pair pair : objectArrayList) {
            Block.popResource((Level)level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> pDropPositionArray, ItemStack pStack, BlockPos pPos) {
        int i = pDropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)pDropPositionArray.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.areMergable((ItemStack)itemstack, (ItemStack)pStack)) continue;
            ItemStack itemStack = ItemEntity.merge((ItemStack)itemstack, (ItemStack)pStack, (int)16);
            pDropPositionArray.set(j, (Object)Pair.of((Object)itemStack, (Object)((BlockPos)pair.getSecond())));
            if (!pStack.isEmpty()) continue;
            return;
        }
        pDropPositionArray.add((Object)Pair.of((Object)pStack, (Object)pPos));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getOwner() != null && this.stickBlock != null) {
            this.facingDir = this.getOwner().getEyePosition().subtract(this.position());
            Vec3 vec3 = this.facingDir.normalize();
            float f = (float)vec3.horizontalDistance();
            this.setYRot(90.0f - (float)Math.atan2(vec3.z, vec3.x) * 57.295776f);
            this.rotate = (float)Math.atan2(f, vec3.y);
        }
    }

    public void setOwner(@Nullable Entity owner) {
        super.setOwner(owner);
        this.entityData.set(DATA_OWNER_ID, (Object)(owner == null ? 0 : owner.getId()));
    }

    @Nullable
    public Entity getOwner() {
        if (this.owner == null) {
            if (this.level().isClientSide) {
                int id = (Integer)this.entityData.get(DATA_OWNER_ID);
                if (id != -1) {
                    this.owner = this.level().getEntity(id);
                }
            } else {
                this.owner = super.getOwner();
            }
        }
        return this.owner;
    }
}

