/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModTiers;

public class Boulder3x3Entity
extends BoulderEntity {
    private static final EntityDataAccessor<Direction> DATA_FACING = SynchedEntityData.defineId(Boulder3x3Entity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private final ItemStack simulated = Items.IRON_PICKAXE.getDefaultInstance();
    private final int power = ModTiers.getPowerForVanillaTiers(Tiers.IRON);

    public Boulder3x3Entity(EntityType<? extends BoulderEntity> entityType, Level level) {
        super(entityType, level);
        this.radius = 1.5f;
    }

    public Boulder3x3Entity(Level level, Vec3 pos, BlockState blockState) {
        super((EntityType<? extends BoulderEntity>)((EntityType)ModEntities.BOULDER_3X.get()), level, pos, blockState);
        this.radius = 1.5f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder.define(DATA_FACING, (Object)Direction.WEST));
    }

    @Override
    public void onRemove() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.blockPosition();
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.COBBLESTONE.defaultBlockState()).setPos(pos), this.getX(), this.getY() + 1.5, this.getZ(), 400, 1.0, 1.0, 1.0, 0.15);
            serverLevel.playSound(null, pos, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 5.0f, 1.0f);
        }
        this.discard();
    }

    @Override
    protected void moveAndUpdateNeighbors() {
        Vec3 vec3 = this.getDeltaMovement();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.move(MoverType.SELF, vec3.add(0.0, -this.getGravity(), 0.0));
        Vec3 motion = this.getDeltaMovement();
        if (motion.x != vec3.x || motion.y != vec3.y || motion.z != vec3.z) {
            ArrayList<BlockPos> toDestroy = new ArrayList<BlockPos>();
            Direction facing = (Direction)this.entityData.get(DATA_FACING);
            BlockPos blockPos = this.blockPosition().relative(facing, 2);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.relative(facing.getClockWise()), (BlockPos)blockPos.above(2).relative(facing.getCounterClockWise()))) {
                BlockState blockState = this.level().getBlockState(pos);
                if (blockState.getCollisionShape((BlockGetter)this.level(), pos, CollisionContext.of((Entity)this)).isEmpty()) continue;
                if (!ModTiers.isCorrectToolForDrops(this.power, this.simulated, blockState)) {
                    return;
                }
                toDestroy.add(pos.immutable());
            }
            if (!this.level().isClientSide) {
                for (BlockPos pos : toDestroy) {
                    this.level().destroyBlock(pos, true);
                }
            }
            this.setDeltaMovement(vec3.scale(1.0 - (double)toDestroy.size() * 0.01));
        }
    }

    public void shoot(Direction facing, double speed) {
        this.setYRot(facing.toYRot());
        this.setDeltaMovement(new Vec3((double)facing.getStepX() * speed, (double)facing.getStepY() * speed, (double)facing.getStepZ() * speed));
        this.entityData.set(DATA_FACING, (Object)facing);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Facing")) {
            this.entityData.set(DATA_FACING, (Object)Direction.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Facing")).result().orElse(Direction.WEST));
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        Direction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((Direction)this.entityData.get(DATA_FACING))).ifSuccess(nbt -> tag.put("Facing", nbt));
    }
}

