/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.functional.BoulderBlock;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.Nullable;

public class BoulderEntity
extends Projectile {
    private static final EntityDataAccessor<Boolean> DATA_VERTICAL = SynchedEntityData.defineId(BoulderEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE = SynchedEntityData.defineId(BoulderEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    public static final float SEARCH_RANGE = 31.5f;
    protected double speed = 0.7;
    protected double minimumBreakSpeed = 0.007;
    public float rotateO = 0.0f;
    public float rotate = 0.0f;
    public float radius = 0.5f;
    private final Object2IntOpenHashMap<UUID> hitHistory = new Object2IntOpenHashMap();

    public BoulderEntity(EntityType<? extends BoulderEntity> entityType, Level level) {
        super(entityType, level);
    }

    public BoulderEntity(Level level, Vec3 pos, BlockState blockState) {
        this((EntityType<? extends BoulderEntity>)((EntityType)ModEntities.BOULDER.get()), level, pos, blockState);
    }

    public BoulderEntity(EntityType<? extends BoulderEntity> entityType, Level level, Vec3 pos, BlockState blockState) {
        super(entityType, level);
        this.setPos(pos);
        this.entityData.set(DATA_BLOCK_STATE, (Object)blockState);
    }

    public void setVertical(boolean is) {
        this.entityData.set(DATA_VERTICAL, (Object)is);
    }

    public boolean isVertical() {
        return (Boolean)this.entityData.get(DATA_VERTICAL);
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(DATA_BLOCK_STATE);
    }

    public void onRemove() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.blockPosition();
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.COBBLESTONE.defaultBlockState()).setPos(pos), this.getX(), this.getY() + 0.5, this.getZ(), 175, 0.0, 0.0, 0.0, 0.15);
            serverLevel.playSound(null, pos, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 5.0f, 1.0f);
        }
        this.discard();
    }

    public void tick() {
        EntityHitResult hitResult1;
        super.tick();
        this.moveAndUpdateNeighbors();
        Vec3 delta = this.getDeltaMovement().scale(0.99);
        this.setDeltaMovement(delta);
        float s = (float)delta.length();
        float r = s / this.radius;
        if (this.rotate > (float)Math.PI * 2) {
            this.rotate -= (float)Math.PI * 2;
        }
        this.rotateO = this.rotate;
        this.rotate += r;
        delta = delta.add((double)((float)Mth.sign((double)delta.x) * this.radius), (double)((float)Mth.sign((double)delta.y) * this.radius), (double)((float)Mth.sign((double)delta.z) * this.radius));
        Vec3 start = this.position();
        Vec3 end = start.add(delta);
        BlockHitResult hitResult = this.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (hitResult.getType() != HitResult.Type.MISS) {
            end = hitResult.getLocation();
        }
        if ((hitResult1 = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)start, (Vec3)end, (AABB)this.getBoundingBox().expandTowards(delta).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0))) != null) {
            hitResult = hitResult1;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = hitResult;
            if (blockHitResult.getType() != HitResult.Type.MISS) {
                this.onHitBlock(blockHitResult);
            }
        } else {
            this.onHitEntity((EntityHitResult)hitResult);
        }
        if (this.onGround() && this.getDeltaMovement().length() < this.minimumBreakSpeed) {
            if (this.isVertical()) {
                this.targetTo(this.level().getNearestPlayer((Entity)this, 31.5));
                this.setVertical(false);
            } else {
                this.onRemove();
            }
        }
    }

    protected void moveAndUpdateNeighbors() {
        Vec3 vec3 = this.getDeltaMovement();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setDeltaMovement(vec3.x, this.onGround() ? 0.0 : vec3.y - this.getGravity(), vec3.z);
        vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3);
        if (!this.level().isClientSide) {
            Vec3 motion = this.getDeltaMovement();
            if (motion.x != vec3.x || motion.y != vec3.y || motion.z != vec3.z) {
                for (Direction dir : LibUtils.DIRECTIONS) {
                    BlockPos blockPos = this.blockPosition().relative(dir);
                    BlockState blockState = this.level().getBlockState(blockPos);
                    Block block = blockState.getBlock();
                    if (!(block instanceof BoulderBlock)) continue;
                    BoulderBlock block2 = (BoulderBlock)block;
                    block2.onProjectileHit(this.level(), blockState, new BlockHitResult(blockPos.getCenter(), dir, blockPos, false), this);
                }
            }
        }
    }

    protected double getDefaultGravity() {
        return 0.08;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (this.isVertical() && !this.getBlockStateOn().isAir() && blockHitResult.getDirection().getAxis() == Direction.Axis.Y) {
            this.targetTo(this.level().getNearestPlayer((Entity)this, 31.5));
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        int i;
        Entity entity = entityHitResult.getEntity();
        UUID uuid1 = entity.getUUID();
        int n = i = this.hitHistory.containsKey((Object)uuid1) ? this.hitHistory.addTo((Object)uuid1, -1) : 0;
        if (i <= 0) {
            entity.hurt(ModDamageTypes.of(entity.level(), ModDamageTypes.BOULDER, (Entity)this), 100.0f);
            this.hitHistory.put((Object)uuid1, 5);
        }
    }

    public void targetTo(@Nullable Player player) {
        Vec3 vec3 = player == null ? this.getDeltaMovement() : player.position().subtract(this.position());
        vec3 = new Vec3(vec3.x, 0.0, vec3.z).normalize();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setDeltaMovement(vec3.scale(this.speed));
        this.yRotO = this.getYRot();
    }

    public boolean fireImmune() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_VERTICAL, (Object)false);
        builder.define(DATA_BLOCK_STATE, (Object)((BoulderBlock)FunctionalBlocks.NORMAL_BOULDER.get()).defaultBlockState());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.entityData.set(DATA_BLOCK_STATE, (Object)((BlockState)BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("BlockState")).getOrThrow()));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("BlockState", (Tag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((BlockState)this.entityData.get(DATA_BLOCK_STATE))).getOrThrow());
    }
}

