/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModEntities;
import org.jetbrains.annotations.Nullable;

public class FollowerBoulderEntity
extends BoulderEntity {
    Player target;
    private int tick = 0;

    public FollowerBoulderEntity(EntityType<FollowerBoulderEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FollowerBoulderEntity(Level level, Vec3 pos, BlockState blockState) {
        super((EntityType<? extends BoulderEntity>)((EntityType)ModEntities.FOLLOWER_BOULDER.get()), level, pos, blockState);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.tick;
        if (this.target != null) {
            Vec3 vec3 = this.target.position().subtract(this.position()).normalize();
            vec3 = new Vec3(vec3.x, 0.0, vec3.z);
            this.setDeltaMovement(vec3.scale(this.speed / 1.75));
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
            this.yRotO = this.getYRot();
            if (this.distanceTo((Entity)this.target) >= 30.0f) {
                this.onRemove();
            }
        }
        if (this.tick >= 400) {
            this.onRemove();
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        this.onRemove();
    }

    @Override
    public void targetTo(@Nullable Player player) {
        if (player != null) {
            this.target = player;
        }
    }
}

