/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModEntities;

public class RollingCactusBoulderEntity
extends BoulderEntity {
    public RollingCactusBoulderEntity(EntityType<RollingCactusBoulderEntity> entityType, Level pLevel) {
        super(entityType, pLevel);
        this.minimumBreakSpeed = 0.05;
        this.speed = 0.3;
    }

    public RollingCactusBoulderEntity(Level level, Vec3 pos, BlockState blockState) {
        super((EntityType<? extends BoulderEntity>)((EntityType)ModEntities.ROLLING_CACTUS_BOULDER.get()), level, pos, blockState);
        this.minimumBreakSpeed = 0.05;
        this.speed = 0.3;
    }

    @Override
    public void onRemove() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int count = this.random.nextInt(6, 13);
            float y = this.random.nextFloat() * (float)Math.PI;
            float d = (float)Math.PI * 2 / (float)count;
            for (int i = 0; i < count; ++i) {
                float x = -Mth.nextFloat((RandomSource)this.random, (float)0.7853982f, (float)1.2566371f);
                SpikeProjectile projectile = new SpikeProjectile((EntityType<? extends Projectile>)((EntityType)ModEntities.ROLLING_CACTUS_SPIKE.get()), this.level());
                float cos = Mth.cos((float)x);
                float f = -Mth.sin((float)y) * cos;
                float f1 = -Mth.sin((float)x);
                float f2 = Mth.cos((float)y) * cos;
                projectile.setPos(this.position().add(0.0, 1.25, 0.0));
                projectile.shoot(f, f1, f2, 0.4f, 0.1f);
                this.level().addFreshEntity((Entity)projectile);
                y += d;
            }
            BlockPos pos = this.blockPosition();
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.CACTUS.defaultBlockState()).setPos(pos), this.getX(), this.getY() + 0.5, this.getZ(), 175, 0.0, 0.0, 0.0, 0.15);
            serverLevel.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.BLOCKS, 5.0f, 1.0f);
        }
        this.discard();
    }

    public static class SpikeProjectile
    extends Projectile {
        public SpikeProjectile(EntityType<? extends Projectile> entityType, Level level) {
            super(entityType, level);
        }

        protected void defineSynchedData(SynchedEntityData.Builder builder) {
        }

        public void tick() {
            EntityHitResult entityHitResult;
            Entity entity;
            HitResult hitResult;
            super.tick();
            Vec3 vec3 = this.getDeltaMovement();
            this.move(MoverType.SELF, vec3);
            Vec3 motion = this.getDeltaMovement();
            if (motion.x != vec3.x || motion.y != vec3.y || motion.z != vec3.z) {
                this.discard();
            } else if (!this.level().isClientSide && (hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity)) instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)hitResult).getEntity()).hurt(this.damageSources().cactus(), 8.0f)) {
                VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)1.0, (double)0.2);
            }
            this.setDeltaMovement(motion.add(0.0, -0.08, 0.0));
            if (this.tickCount > 200) {
                this.discard();
            }
        }

        protected boolean canHitEntity(Entity target) {
            return target.canBeHitByProjectile() && target != this.getOwner();
        }
    }
}

