/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import com.mojang.serialization.DynamicOps;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.block.common.TombstoneBlock;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.util.PlayerUtils;

public class TombstoneBoulderEntity
extends BoulderEntity {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SignText text = new SignText();

    public TombstoneBoulderEntity(EntityType<TombstoneBoulderEntity> entityType, Level pLevel) {
        super(entityType, pLevel);
        this.minimumBreakSpeed = 0.1;
        this.speed = 0.2;
    }

    public TombstoneBoulderEntity(Level level, Vec3 pos, BlockState blockState) {
        super((EntityType<? extends BoulderEntity>)((EntityType)ModEntities.TOMBSTONE_BOULDER.get()), level, pos, blockState);
        this.minimumBreakSpeed = 0.1;
        this.speed = 0.2;
    }

    @Override
    public void onRemove() {
        if (!this.level().isClientSide && this.level().getBlockState(this.blockPosition()).canBeReplaced()) {
            this.level().setBlock(this.blockPosition(), this.getBlockState(), 3);
            BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
            if (blockEntity instanceof TombstoneBlock.BEntity) {
                TombstoneBlock.BEntity entity = (TombstoneBlock.BEntity)blockEntity;
                entity.setText(this.text, true);
            }
        }
        this.discard();
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        if (ModSecretSeeds.FOR_THE_WORTHY.match()) {
            super.onHitEntity(entityHitResult);
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("text", (Tag)SignText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.text).getOrThrow());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.text = (SignText)SignText.DIRECT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("text")).getOrThrow();
    }

    public static void createTombstone(ServerPlayer serverPlayer) {
        if (((Boolean)CommonConfigs.DROPS_TOMBSTONE.get()).booleanValue()) {
            boolean isGolden = PlayerUtils.getMoney((Player)serverPlayer, true) >= 100000L;
            BlockState blockState = (BlockState)Util.getRandom((Object[])((BlockState[])ModBlocks.TOMBSTONES.object2BooleanEntrySet().stream().filter(entry -> entry.getBooleanValue() == isGolden).map(entry -> ((TombstoneBlock)((Object)((Object)((DeferredBlock)entry.getKey()).get()))).defaultBlockState()).toArray(BlockState[]::new)), (RandomSource)serverPlayer.getRandom());
            Level level = serverPlayer.level();
            Vec3 position = serverPlayer.position();
            TombstoneBoulderEntity entity = new TombstoneBoulderEntity(level, position, blockState);
            entity.text = entity.text.setMessage(0, serverPlayer.getCombatTracker().getDeathMessage()).setMessage(1, (Component)Component.literal((String)DATE_FORMAT.format(Calendar.getInstance().getTime())));
            if (level.getBlockState(serverPlayer.blockPosition().below()).isAir()) {
                entity.setVertical(true);
            } else {
                entity.targetTo(level.getNearestPlayer(position.x, position.y, position.z, 31.5, Entity::isAlive));
                entity.setVertical(false);
            }
            level.addFreshEntity((Entity)entity);
        }
    }
}

