/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.DamageSettableProjectile;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.util.ModUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractManaProjectile
extends DamageSettableProjectile {
    protected boolean localVelocity = false;

    public AbstractManaProjectile(EntityType<? extends AbstractManaProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        if (this.getOwner() == null) {
            this.discard();
        } else {
            super.tick();
        }
    }

    @Nullable
    public LivingEntity getLivingOwner() {
        LivingEntity living;
        Entity entity = this.getOwner();
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    public DamageSource getDamagesource() {
        return ModDamageTypes.of(this.level(), ModDamageTypes.MAGICAL_PROJECTILE, (Entity)this, this.getOwner());
    }

    protected boolean canHitEntity(Entity target) {
        return ModUtils.canHitEntity(target, this.getOwner());
    }

    public void shootFromRotation(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        float cos = Mth.cos((float)(x * ((float)Math.PI / 180)));
        float f = -Mth.sin((float)(y * ((float)Math.PI / 180))) * cos;
        float f1 = -Mth.sin((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(y * ((float)Math.PI / 180))) * cos;
        this.shoot(f, f1, f2, velocity, inaccuracy);
        if (this.localVelocity) {
            Vec3 vec3 = shooter.getKnownMovement();
            this.setDeltaMovement(this.getDeltaMovement().add(vec3.x, shooter.onGround() ? 0.0 : vec3.y, vec3.z));
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Age", this.tickCount);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.tickCount = compound.getInt("Age");
    }
}

