/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.terraentity.init.TEEffects;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class BallOfFireProjectile
extends AbstractManaProjectile {
    private int collideCount = 0;
    private ParticleEmitter emitter;

    public BallOfFireProjectile(EntityType<BallOfFireProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
    }

    public BallOfFireProjectile(LivingEntity living) {
        this((EntityType<BallOfFireProjectile>)((EntityType)ModEntities.BALL_OF_FIRE_PROJECTILE.get()), living.level());
        this.setOwner((Entity)living);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    public void baseTick() {
        HitResult hitResult;
        if (!this.level().getFluidState(this.blockPosition()).isEmpty()) {
            this.discard();
            return;
        }
        super.baseTick();
        Vec3 vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3.add(0.0, -0.04, 0.0));
        Vec3 motion = this.getDeltaMovement();
        if (!vec3.equals((Object)motion)) {
            if (motion.x != vec3.x) {
                motion = new Vec3(-vec3.x, vec3.y, vec3.z);
            }
            if (motion.y != vec3.y) {
                motion = new Vec3(vec3.x, -vec3.y, vec3.z);
            }
            if (motion.z != vec3.z) {
                motion = new Vec3(vec3.x, vec3.y, -vec3.z);
            }
            if (this.collideCount++ >= 6) {
                this.discard();
                return;
            }
        }
        this.setDeltaMovement(motion.scale(0.99).add(0.0, -0.04, 0.0));
        if (this.level().isClientSide && (this.emitter == null || this.emitter.isRemoved())) {
            this.emitter = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("ball_of_fire"));
            this.emitter.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.emitter, false);
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity)) instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity entity = entityHitResult.getEntity();
            boolean ddu = ModSecretSeeds.DONT_DIG_UP.match();
            if (this.random.nextBoolean()) {
                if (ddu && entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.addEffect(new MobEffectInstance((Holder)TEEffects.HELLFIRE, 100));
                } else {
                    entity.setRemainingFireTicks(100);
                }
            }
            if (entity.hurt(this.getDamagesource(), ddu ? this.getCalculatedDamage() * 1.5f : this.getCalculatedDamage())) {
                VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)0.6, (double)0.2);
            }
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.collideCount = compound.getInt("CollideCount");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("CollideCount", this.collideCount);
    }
}

