/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEntities;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class CursedFlamesProjectile
extends AbstractManaProjectile {
    private int collideCount = 0;
    private int penetrateCount = 0;
    private ParticleEmitter emitter;

    public CursedFlamesProjectile(EntityType<CursedFlamesProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
    }

    public CursedFlamesProjectile(Player player) {
        super((EntityType<? extends AbstractManaProjectile>)((EntityType)ModEntities.CURSED_FLAMES_PROJECTILE.get()), player.level());
        this.setOwner((Entity)player);
        this.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
    }

    public void baseTick() {
        HitResult hitResult;
        if (!this.level().getFluidState(this.blockPosition()).isEmpty()) {
            this.discard();
            return;
        }
        super.baseTick();
        Vec3 vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3.add(0.0, -0.04, 0.0));
        Vec3 motion = this.getDeltaMovement();
        if (!vec3.equals((Object)motion)) {
            if (motion.x != vec3.x) {
                motion = new Vec3(-vec3.x, vec3.y, vec3.z);
            }
            if (motion.y != vec3.y) {
                motion = new Vec3(vec3.x, -vec3.y, vec3.z);
            }
            if (motion.z != vec3.z) {
                motion = new Vec3(vec3.x, vec3.y, -vec3.z);
            }
            if (this.collideCount++ >= 5) {
                this.discard();
                return;
            }
        }
        this.setDeltaMovement(motion.scale(0.99).add(0.0, -0.04, 0.0));
        if (this.level().isClientSide && (this.emitter == null || this.emitter.isRemoved())) {
            this.emitter = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("cursed_flames"));
            this.emitter.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.emitter, false);
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity)) instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity entity = entityHitResult.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.addEffect(new MobEffectInstance(ModEffects.CURSED_INFERNO, 140));
            }
            if (entity.hurt(this.getDamagesource(), this.getCalculatedDamage())) {
                VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)0.6, (double)0.2);
            }
            if (this.penetrateCount++ >= 1) {
                this.discard();
            }
        }
        if (this.tickCount > 1200) {
            this.discard();
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.collideCount = compound.getInt("CollideCount");
        this.penetrateCount = compound.getInt("PenetrateCount");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("CollideCount", this.collideCount);
        compound.putInt("PenetrateCount", this.penetrateCount);
    }
}

