/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.entitiy.IAxisZRotate;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEntities;

public class DemonScytheProjectile
extends AbstractManaProjectile
implements IAxisZRotate {
    public final IAxisZRotate.Rotate rotate = new IAxisZRotate.Rotate();
    protected final Set<UUID> penetrateSet = new HashSet<UUID>();

    public DemonScytheProjectile(EntityType<DemonScytheProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
        this.setNoGravity(true);
    }

    public DemonScytheProjectile(LivingEntity living) {
        this((EntityType<DemonScytheProjectile>)((EntityType)ModEntities.DEMON_SCYTHE_PROJECTILE.get()), living.level());
        this.setOwner((Entity)living);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    public void baseTick() {
        Entity entity;
        Vec3 vec3;
        super.baseTick();
        if (this.tickCount > 10 && (vec3 = this.getDeltaMovement()).lengthSqr() < 2.18300625) {
            this.setDeltaMovement(vec3.scale(1.1940371819652));
        }
        if (this.level().isClientSide) {
            this.rotateZ(this.rotate, () -> ((DemonScytheProjectile)this).getDeltaMovement(), 0.0, 0.125f);
        }
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        this.checkInsideBlocks();
        HitResult.Type hitresult$type = hitresult.getType();
        if (hitresult$type == HitResult.Type.BLOCK) {
            this.discard();
            return;
        }
        if (hitresult$type == HitResult.Type.ENTITY && !this.level().isClientSide && !this.penetrateSet.contains((entity = ((EntityHitResult)hitresult).getEntity()).getUUID())) {
            if (entity.hurt(this.getDamagesource(), this.getCalculatedDamage())) {
                VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)0.5, (double)0.2);
            }
            this.penetrateSet.add(entity.getUUID());
            if (this.penetrateSet.size() == 5) {
                this.discard();
                return;
            }
        }
        Vec3 vec32 = this.getDeltaMovement();
        double offX = this.getX() + vec32.x;
        double offY = this.getY() + vec32.y;
        double offZ = this.getZ() + vec32.z;
        this.setPos(offX, offY, offZ);
        if (this.tickCount > 200) {
            this.discard();
        }
    }
}

