/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.mod.common.entity.projectile.ThrowableDropSelfProjectile;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModEntities;

public class MagicDaggerProjectile
extends ThrowableDropSelfProjectile {
    public MagicDaggerProjectile(EntityType<? extends ThrowableDropSelfProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public MagicDaggerProjectile(LivingEntity living) {
        super((EntityType<? extends ThrowableDropSelfProjectile>)((EntityType)ModEntities.MAGIC_DAGGER_PROJECTILE.get()), living.level());
    }

    @Override
    protected DamageSource getDamageSource() {
        return ModDamageTypes.of(this.level(), ModDamageTypes.MAGICAL_PROJECTILE, (Entity)this, this.getOwner());
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        BlockState blockstate = this.level().getBlockState(result.getBlockPos());
        blockstate.onProjectileHit(this.level(), blockstate, result, (Projectile)this);
        this.discard();
    }
}

