/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEntities;
import org.jetbrains.annotations.Nullable;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class SkullProjectile
extends AbstractManaProjectile {
    private ParticleEmitter trail;
    private static final EntityDataAccessor<Integer> DATA_TARGET_ID = SynchedEntityData.defineId(SkullProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private UUID targetUUID;
    private transient LivingEntity target;
    protected final Set<UUID> penetrateSet = new HashSet<UUID>();

    public SkullProjectile(EntityType<SkullProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
        this.setNoGravity(true);
    }

    public SkullProjectile(LivingEntity living) {
        this((EntityType<SkullProjectile>)((EntityType)ModEntities.SKULL_PROJECTILE.get()), living.level());
        this.setOwner((Entity)living);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder.define(DATA_TARGET_ID, (Object)-114514));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        Entity entity;
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide && DATA_TARGET_ID.equals(key) && (entity = this.level().getEntity(((Integer)this.entityData.get(DATA_TARGET_ID)).intValue())) instanceof LivingEntity) {
            LivingEntity living;
            this.target = living = (LivingEntity)entity;
        }
    }

    public void baseTick() {
        Entity entity;
        super.baseTick();
        if (this.getTarget() == null) {
            if (!this.level().isClientSide) {
                this.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.blockPosition()).inflate(12.5), living -> living instanceof Enemy).stream().min(Comparator.comparingDouble(living -> living.distanceToSqr((Entity)this))).ifPresent(this::setTarget);
            }
        } else if (!this.target.isRemoved()) {
            Vec3 vec3 = this.getDeltaMovement().add(VectorUtils.getVectorA2B((Entity)this, (Entity)this.target).scale(0.4375));
            if (vec3.lengthSqr() > 0.19140625) {
                this.setDeltaMovement(vec3.normalize().scale(0.4375));
            }
        } else {
            this.setTarget(null);
        }
        if (this.level().isClientSide && (this.trail == null || this.trail.isRemoved())) {
            this.trail = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("skull_projectile_flame"));
            this.trail.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.trail, false);
        }
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        this.checkInsideBlocks();
        HitResult.Type hitresult$type = hitresult.getType();
        if (hitresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)hitresult);
            this.discard();
            return;
        }
        if (hitresult$type == HitResult.Type.ENTITY && !this.penetrateSet.contains((entity = ((EntityHitResult)hitresult).getEntity()).getUUID())) {
            if (entity.hurt(this.getDamagesource(), this.getCalculatedDamage())) {
                VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)0.35, (double)0.1);
            }
            this.penetrateSet.add(entity.getUUID());
            if (this.penetrateSet.size() == 3) {
                this.discard();
                return;
            }
        }
        Vec3 vec3 = this.getDeltaMovement();
        double offX = this.getX() + vec3.x;
        double offY = this.getY() + vec3.y;
        double offZ = this.getZ() + vec3.z;
        this.setPos(offX, offY, offZ);
        this.updateRotation();
    }

    public void setTarget(@Nullable LivingEntity target) {
        this.target = target;
        if (target == null) {
            this.targetUUID = null;
            this.entityData.set(DATA_TARGET_ID, (Object)-114514);
        } else {
            this.targetUUID = target.getUUID();
            this.entityData.set(DATA_TARGET_ID, (Object)target.getId());
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        ServerLevel level;
        Entity entity;
        Level level2;
        if (this.target == null && this.targetUUID != null && (level2 = this.level()) instanceof ServerLevel && (entity = (level = (ServerLevel)level2).getEntity(this.targetUUID)) instanceof LivingEntity) {
            LivingEntity living;
            this.target = living = (LivingEntity)entity;
        }
        return this.target;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("TargetUUID")) {
            this.targetUUID = compound.getUUID("TargetUUID");
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.targetUUID != null) {
            compound.putUUID("TargetUUID", this.targetUUID);
        }
    }
}

