/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEntities;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class WaterBoltProjectile
extends AbstractManaProjectile {
    private final Set<Entity> passThrough = new HashSet<Entity>();
    private int collideCount = 0;
    private ParticleEmitter emitter;

    public WaterBoltProjectile(EntityType<WaterBoltProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
    }

    public WaterBoltProjectile(LivingEntity living) {
        this((EntityType<WaterBoltProjectile>)((EntityType)ModEntities.WATER_BOLT_PROJECTILE.get()), living.level());
        this.setOwner((Entity)living);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    public void baseTick() {
        if (this.tickCount > 600) {
            this.discard();
            return;
        }
        super.baseTick();
        Vec3 vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3);
        Vec3 motion = this.getDeltaMovement();
        if (!vec3.equals((Object)motion)) {
            if (motion.x != vec3.x) {
                motion = new Vec3(-vec3.x, vec3.y, vec3.z);
            }
            if (motion.y != vec3.y) {
                motion = new Vec3(vec3.x, -vec3.y, vec3.z);
            }
            if (motion.z != vec3.z) {
                motion = new Vec3(vec3.x, vec3.y, -vec3.z);
            }
            if (this.collideCount++ >= 5) {
                this.discard();
                return;
            }
        }
        this.setDeltaMovement(motion);
        if (this.level().isClientSide) {
            if (this.emitter == null || this.emitter.isRemoved()) {
                this.emitter = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("water_stream"));
                this.emitter.attachEntity((Entity)this);
                PSGameClient.LOADER.addEmitter(this.emitter, false);
            }
        } else {
            EntityHitResult entityHitResult;
            Entity entity;
            HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
            if (hitResult instanceof EntityHitResult && this.passThrough.add(entity = (entityHitResult = (EntityHitResult)hitResult).getEntity())) {
                if (entity.hurt(this.getDamagesource(), this.getCalculatedDamage())) {
                    VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)1.5, (double)0.2);
                }
                if (this.passThrough.size() >= 10) {
                    this.discard();
                }
            }
        }
    }
}

