/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.range.arrow;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.range.arrow.BaseArrowEntity;
import org.confluence.mod.common.item.bow.BaseArrowItem;
import org.confluence.mod.common.item.bow.TerraBowItem;
import org.confluence.terraentity.api.entity.ITrackType;
import org.confluence.terraentity.registries.track.variant.BasisTrack;
import org.confluence.terraentity.utils.TEUtils;
import org.jetbrains.annotations.Nullable;

public class BeeArrow
extends BaseArrowEntity {
    ITrackType trackType = new BasisTrack(30.0, (double)0.2f);

    public BeeArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.modify.setGravity(0.0f).setAutoDiscard(50);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public BeeArrow(EntityType<? extends AbstractArrow> pEntityType, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, BaseArrowItem arrow, TerraBowItem.Builder modifyConsumer) {
        super(pEntityType, owner, pickupItemStack, firedFromWeapon, arrow, modifyConsumer);
        this.modify.setGravity(0.0f).setAutoDiscard(50);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    @Override
    public void tick() {
        LivingEntity target;
        super.tick();
        if (!this.inGround && this.getOwner() != null && (target = TEUtils.getAABBAngleTarget((Vec3)this.position(), (Vec3)this.position().add(this.getDeltaMovement().normalize().scale(10.0)), (Level)this.level(), (Entity)this, (double)20.0, (double)30.0, this::canHitEntity)) != null) {
            Vec3 motion = this.getDeltaMovement();
            Vec3 dir = target.position().add(0.0, (double)(target.getEyeHeight() * 0.5f), 0.0).subtract(this.position());
            double angle = TEUtils.angleBetween((Vec3)motion, (Vec3)dir);
            Vec3 movement = this.trackType.calDeltaMovement(this.getDeltaMovement(), dir, angle);
            this.setDeltaMovement(movement);
        }
        Vec3 vec3 = this.getDeltaMovement();
        Vec3 pos = this.position();
        this.move(MoverType.SELF, vec3);
        Vec3 motion = this.getDeltaMovement();
        if (motion.x != vec3.x || motion.y != vec3.y || motion.z != vec3.z) {
            if (motion.x != vec3.x) {
                motion = new Vec3(-vec3.x, vec3.y, vec3.z);
            }
            if (motion.y != vec3.y) {
                motion = new Vec3(vec3.x, -vec3.y, vec3.z);
            }
            if (motion.z != vec3.z) {
                motion = new Vec3(vec3.x, vec3.y, -vec3.z);
            }
            this.setDeltaMovement(motion);
        } else {
            this.setPos(pos);
        }
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) && TEUtils.projectileCanHurtEntityTest.test(this, target);
    }
}

