/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.strip;

import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.entity.projectile.DamageSettableProjectile;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.util.ModUtils;

public abstract class StripedProjectile
extends DamageSettableProjectile {
    private static final EntityDataAccessor<Boolean> DATA_IS_HEAD = SynchedEntityData.defineId(StripedProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected double distForHeadRemove = 10.0;
    protected double distForCreateBody = 0.95;
    protected int ticksForBodyRemove = 28;
    private Vec3 startPos = Vec3.ZERO;
    private double distO = -0.5;
    public float[] rot;

    public StripedProjectile(EntityType<? extends StripedProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public StripedProjectile(EntityType<? extends StripedProjectile> entityType, LivingEntity living) {
        this(entityType, living, new Vec3(living.getX(), living.getEyeY() - 0.1, living.getZ()));
    }

    public StripedProjectile(EntityType<? extends StripedProjectile> entityType, LivingEntity living, Vec3 pos) {
        this(entityType, living.level());
        this.setOwner((Entity)living);
        this.setNoGravity(true);
        this.setPos(pos);
        this.startPos = pos;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder.define(DATA_IS_HEAD, (Object)true));
    }

    public void tick() {
        super.tick();
        if (this.isHead()) {
            Entity entity;
            Vec3 vec3 = this.getDeltaMovement();
            if (!this.level().isClientSide && (entity = this.getOwner()) instanceof LivingEntity) {
                double dist;
                double delta;
                LivingEntity living = (LivingEntity)entity;
                HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
                if (hitresult.getType() == HitResult.Type.ENTITY) {
                    this.onHitEntity((EntityHitResult)hitresult);
                }
                if ((delta = (dist = this.position().distanceTo(this.startPos)) - this.distO) >= this.distForCreateBody) {
                    if (dist > this.distForHeadRemove) {
                        this.onRemove();
                    } else {
                        StripedProjectile body = this.createBody(living);
                        body.setDeltaMovement(vec3);
                        body.setHead(false);
                        body.setDamage(this.getCalculatedDamage());
                        this.level().addFreshEntity((Entity)body);
                        this.distO = dist;
                    }
                }
            }
            this.checkInsideBlocks();
            double offX = this.getX() + vec3.x;
            double offY = this.getY() + vec3.y;
            double offZ = this.getZ() + vec3.z;
            this.setPos(offX, offY, offZ);
        } else if (!this.level().isClientSide) {
            if (this.tickCount > this.ticksForBodyRemove) {
                this.onRemove();
            } else {
                AABB boundingBox = this.getBoundingBox().inflate(1.0);
                EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)boundingBox.getMinPosition(), (Vec3)boundingBox.getMaxPosition(), (AABB)boundingBox, this::canHitEntity, (float)0.5f);
                if (hitResult != null) {
                    this.onTouchEntity(hitResult);
                }
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity.hurt(this.getDamageSource(), this.getCalculatedDamage())) {
            VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)0.5, (double)0.2);
        }
    }

    protected DamageSource getDamageSource() {
        return ModDamageTypes.of(this.level(), ModDamageTypes.MAGICAL_PROJECTILE, (Entity)this, this.getOwner());
    }

    protected void onRemove() {
        this.discard();
    }

    protected abstract void onTouchEntity(EntityHitResult var1);

    protected abstract StripedProjectile createBody(LivingEntity var1);

    public float[] getRot() {
        if (this.rot == null) {
            this.updateRotation();
            this.rot = new float[]{this.getYRot() * ((float)Math.PI / 180), this.getXRot() * ((float)Math.PI / 180)};
        }
        return this.rot;
    }

    public boolean isHead() {
        return (Boolean)this.entityData.get(DATA_IS_HEAD);
    }

    public void setHead(boolean is) {
        this.entityData.set(DATA_IS_HEAD, (Object)is);
    }

    protected boolean canHitEntity(Entity target) {
        return ModUtils.canHitEntity(target, this.getOwner());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("StartPos", (Tag)Vec3.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.startPos).getOrThrow());
        compound.putInt("Age", this.tickCount);
        compound.putBoolean("IsHead", this.isHead());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.startPos = (Vec3)Vec3.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("StartPos")).getOrThrow();
        this.tickCount = compound.getInt("Age");
        this.setHead(compound.getBoolean("IsHead"));
    }
}

