/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.sword;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.sword.SwordProjectile;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModParticleTypes;
import org.confluence.terraentity.api.entity.ICollisionAttackEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class GrassSwordProjectile
extends SwordProjectile {
    protected static final EntityDataAccessor<Float> DATA_YAW = SynchedEntityData.defineId(GrassSwordProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> DATA_PITCH = SynchedEntityData.defineId(GrassSwordProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float yawSpeed;
    private float pitchSpeed;

    public GrassSwordProjectile(EntityType<GrassSwordProjectile> entityType, Level pLevel) {
        super(entityType, pLevel);
        this.canPenalize = true;
        this.hitCount = 99999;
        this.collisionProperties = new ICollisionAttackEntity.CollisionProperties(10, 10, 1.0f);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (this.level().isClientSide) {
            if (data == DATA_YAW) {
                this.yawSpeed = ((Float)this.entityData.get(DATA_YAW)).floatValue();
            } else if (data == DATA_PITCH) {
                this.pitchSpeed = ((Float)this.entityData.get(DATA_PITCH)).floatValue();
            }
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_YAW, (Object)Float.valueOf(0.0f));
        builder.define(DATA_PITCH, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount > 5) {
            Vec3 motion = this.getDeltaMovement();
            float yaw = 1.5707964f - (float)Mth.atan2((double)motion.z, (double)motion.x);
            float pitch = (float)(-Mth.atan2((double)motion.y, (double)Math.sqrt(motion.x * motion.x + motion.z * motion.z)));
            Quaternionf q = new Quaternionf().rotateY(yaw).rotateX(pitch).rotateX(-0.1f).rotateY(this.yawSpeed);
            Vec3 transformed = new Vec3(q.transform(new Vector3f(0.0f, 0.0f, 1.0f)));
            this.setDeltaMovement(transformed);
        }
        if (this.tickCount % 2 == 0 && this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ModParticleTypes.LEAVES.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void shootFromRotation(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        super.shootFromRotation(shooter, x, y, z, velocity, inaccuracy);
        this.yawSpeed = (float)(Math.random() * 0.5 + 0.5);
        this.pitchSpeed = (float)(-Math.random() * (double)0.05f - (double)0.05f);
        this.entityData.set(DATA_YAW, (Object)Float.valueOf(this.yawSpeed));
        this.entityData.set(DATA_PITCH, (Object)Float.valueOf(this.pitchSpeed));
    }

    @Override
    public DamageSource damageSource() {
        return ModDamageTypes.of(this.level(), (ResourceKey<DamageType>)DamageTypes.GENERIC, (Entity)this, this.getOwner());
    }
}

