/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.sword;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.component.SwordProjectileComponent;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terraentity.api.entity.IAttackableProjectile;
import org.confluence.terraentity.api.entity.ICollisionAttackEntity;
import org.confluence.terraentity.utils.TEUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class SwordProjectile
extends AbstractHurtingProjectile
implements ICollisionAttackEntity {
    public int lifetime = 40;
    public int hitCount = 1;
    protected float attackDamageFactor = 1.0f;
    protected float baseAttackDamage = 0.0f;
    protected float criticalChance = 0.0f;
    protected float knockBack = 0.0f;
    protected float baseKnockBack = 0.0f;
    protected boolean canPenalize = false;
    protected ICollisionAttackEntity.CollisionProperties collisionProperties = new ICollisionAttackEntity.CollisionProperties(1, 1, 0.5f);
    protected SwordProjectileComponent projComponent;
    protected ItemStack firedFromWeapon;
    float gravity = 0.0f;
    Vec3 initSpeed = new Vec3(0.0, 0.0, 0.0);
    public Vec3 direction = new Vec3(0.0, 0.0, 0.0);
    public static final EntityDataAccessor<Vector3f> DATA_DIRECTION = SynchedEntityData.defineId(SwordProjectile.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    protected static final EntityDataAccessor<Vector3f> DATA_INIT_SPEED = SynchedEntityData.defineId(SwordProjectile.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    protected static final EntityDataAccessor<Float> DATA_INIT_GRAVITY = SynchedEntityData.defineId(SwordProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    LivingEntity target;

    public SwordProjectile(EntityType<? extends SwordProjectile> entityType, Level pLevel) {
        super(entityType, pLevel);
        if (!this.level().isClientSide()) {
            this.direction = new Vec3((double)(this.getRandom().nextFloat() - 0.5f), (double)(this.getRandom().nextFloat() - 0.5f), (double)(this.getRandom().nextFloat() - 0.5f));
            this.entityData.set(DATA_DIRECTION, (Object)this.direction.toVector3f());
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (this.level().isClientSide) {
            if (data == DATA_INIT_SPEED) {
                this.initSpeed = new Vec3((Vector3f)this.entityData.get(DATA_INIT_SPEED));
                this.setDeltaMovement(this.initSpeed);
            } else if (data == DATA_INIT_GRAVITY) {
                this.gravity = ((Float)this.entityData.get(DATA_INIT_GRAVITY)).floatValue();
            } else if (DATA_DIRECTION.equals(data)) {
                this.direction = new Vec3((Vector3f)this.entityData.get(DATA_DIRECTION));
                float yaw = (float)Math.atan2(this.direction.x, this.direction.z) * 57.295776f;
                this.setYRot(yaw);
                this.yRotO = yaw;
            }
        }
    }

    public boolean fireImmune() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_INIT_SPEED, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        builder.define(DATA_INIT_GRAVITY, (Object)Float.valueOf(0.0f));
        builder.define(DATA_DIRECTION, (Object)new Vector3f());
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    public void setWeapon(ItemStack weapon) {
        this.firedFromWeapon = weapon;
    }

    protected float getBaseDamage() {
        return this.baseAttackDamage;
    }

    protected float getBaseKnockBack() {
        return this.baseKnockBack;
    }

    public SwordProjectile addAttackDamage(float attackDamage) {
        this.baseAttackDamage += attackDamage;
        return this;
    }

    public SwordProjectile addKnockBack(float knockBack) {
        this.baseKnockBack += knockBack;
        return this;
    }

    public void setProjComponent(SwordProjectileComponent projComponent) {
        this.projComponent = projComponent;
        this.gravity = projComponent.gravity();
        this.lifetime = projComponent.existTicks();
        this.entityData.set(DATA_INIT_GRAVITY, (Object)Float.valueOf(this.gravity));
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        Entity owner1 = this.getOwner();
        if (owner1 instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)owner1;
            AttributeInstance attributeInstance = owner.getAttribute(Attributes.ATTACK_KNOCKBACK);
            if (attributeInstance != null) {
                this.knockBack += (float)attributeInstance.getValue();
            }
            if (TCAttributes.hasCustomAttribute((Holder)TCAttributes.CRIT_CHANCE)) {
                return;
            }
            attributeInstance = owner.getAttribute((Holder)TCAttributes.CRIT_CHANCE);
            if (attributeInstance != null) {
                this.criticalChance = (float)attributeInstance.getValue();
            }
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(50.0), e -> {
                LivingEntity living;
                return e instanceof LivingEntity && (living = (LivingEntity)e).isAlive() && e != owner1;
            });
            entities.sort(Comparator.comparingDouble(a -> a.distanceToSqr((Entity)this)));
            for (Entity entity : entities) {
                LivingEntity living;
                if (!(entity instanceof LivingEntity)) continue;
                this.target = living = (LivingEntity)entity;
                break;
            }
        }
    }

    protected double getDefaultGravity() {
        return this.gravity;
    }

    public void tick() {
        super.tick();
        if (this.projComponent != null) {
            if (!this.level().isClientSide() && this.tickCount >= this.projComponent.existTicks()) {
                this.discard();
            }
            this.applyGravity();
            if (this.target != null && this.target.isAlive()) {
                Vec3 dir = this.target.position().add(0.0, (double)(this.target.getEyeHeight() * 0.5f), 0.0).subtract(this.position()).normalize();
                Vec3 motion = this.getDeltaMovement();
                double angle = TEUtils.angleBetween((Vec3)motion, (Vec3)dir);
                if (this.projComponent.trackType().isPresent()) {
                    this.setDeltaMovement(this.projComponent.trackType().get().calDeltaMovement(motion, dir, angle));
                }
            }
        }
        if (!this.level().isClientSide && this.tickCount >= this.lifetime) {
            this.discard();
        }
        this.doCollisionAttack(this::canHitEntity, this::doHurt);
    }

    protected boolean canHitEntity(Entity target) {
        if (this.hitCount <= 0) {
            return false;
        }
        return TEUtils.projectileCanHitEntityTest.test(this, target);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.canPenalize && !this.level().isClientSide) {
            this.discard();
        }
    }

    public DamageSource damageSource() {
        return ModDamageTypes.of(this.level(), ModDamageTypes.SWORD_PROJECTILE, (Entity)this, this.getOwner());
    }

    public ICollisionAttackEntity.CollisionProperties getCollisionProperties() {
        return this.collisionProperties;
    }

    protected boolean doHurt(Entity target) {
        if (TEUtils.projectileCanHurtEntityTest.test(this, target)) {
            PartEntity partEntity;
            Entity entity;
            LivingEntity hurter;
            float damage = this.getBaseDamage() * this.attackDamageFactor;
            DamageSource damageSource = this.damageSource();
            if (IAttackableProjectile.tryHit((Entity)target, (DamageSource)damageSource)) {
                return true;
            }
            if (target instanceof LivingEntity) {
                LivingEntity living;
                hurter = living = (LivingEntity)target;
            } else if (target instanceof PartEntity && (entity = (partEntity = (PartEntity)target).getParent()) instanceof LivingEntity) {
                LivingEntity living;
                hurter = living = (LivingEntity)entity;
            } else {
                return false;
            }
            entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                if (this.projComponent != null) {
                    this.projComponent.hitEffect().ifPresent(effect -> effect.applyAll(owner, hurter));
                }
            }
            if (target.hurt(damageSource, damage)) {
                float attackKnockBack = this.getBaseKnockBack() + this.knockBack;
                VectorUtils.knockBackA2B((Entity)this, (Entity)hurter, (double)((double)attackKnockBack * 0.5), (double)0.2);
                if (--this.hitCount <= 0 && !this.level().isClientSide) {
                    this.discard();
                }
            }
            return true;
        }
        return false;
    }

    public void shootFromRotation(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        Vec3 vec3 = shooter.getKnownMovement().scale(0.25);
        this.setDeltaMovement(this.getDeltaMovement().add(vec3.x, shooter.onGround() ? 0.0 : vec3.y, vec3.z));
        this.entityData.set(DATA_INIT_SPEED, (Object)this.getDeltaMovement().toVector3f());
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected boolean shouldBurn() {
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    protected float getInertia() {
        return 1.0f;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public SwordProjectile setExistTime(int time) {
        this.lifetime = time;
        return this;
    }

    public boolean shouldDoCollision() {
        return true;
    }
}

