/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.equipment_set;

import com.xiaohunao.equipment_benediction.common.equipment_set.EquipmentSet;
import com.xiaohunao.equipment_benediction.common.equipment_set.EquipmentSetBranch;
import com.xiaohunao.equipment_benediction.common.equipment_set.EquippableGroup;
import com.xiaohunao.equipment_benediction.common.equippable.VanillaWearable;
import com.xiaohunao.equipment_benediction.common.hook.HookMap;
import com.xiaohunao.equipment_benediction.common.hook.HookType;
import com.xiaohunao.equipment_benediction.common.hook.IHook;
import com.xiaohunao.equipment_benediction.common.hook.hooks.AfterLivingHurtEntityHook;
import com.xiaohunao.equipment_benediction.common.init.EBHookTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.entity.projectile.FlowerPetalProjectile;
import org.confluence.mod.common.init.ModHookTypes;
import org.confluence.mod.common.init.item.ArmorItems;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terraentity.init.TEAttributes;

public class OrichalcumSet
extends EquipmentSet {
    protected void init(HookMap.Builder hook, EquippableGroup.Builder equippableGroup) {
        equippableGroup.addEquippableSet("headgear", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.HEAD, ArmorItems.ORICHALCUM_HEADGEAR}).bindHook(builder -> builder.addBonus(TCAttributes.getCriticalChance(), new AttributeModifier(ArmorItems.ORICHALCUM_HEADGEAR.getId(), 0.18, AttributeModifier.Operation.ADD_VALUE))).bindHook((HookType)ModHookTypes.ADDITIONAL_MANA.get(), (owner, player, original) -> original + 80).build());
        equippableGroup.addEquippableSet("mask", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.HEAD, ArmorItems.ORICHALCUM_MASK}).bindHook(builder -> builder.addBonus(Attributes.ATTACK_DAMAGE, new AttributeModifier(ArmorItems.ORICHALCUM_MASK.getId(), 0.11, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).addBonus(Attributes.ATTACK_SPEED, new AttributeModifier(ArmorItems.ORICHALCUM_MASK.getId(), 0.011, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).addBonus(Attributes.MOVEMENT_SPEED, new AttributeModifier(ArmorItems.ORICHALCUM_MASK.getId(), 0.07, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))).build());
        equippableGroup.addEquippableSet("helmet", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.HEAD, ArmorItems.ORICHALCUM_HELMET}).bindHook(builder -> builder.addBonus(TCAttributes.getCriticalChance(), new AttributeModifier(ArmorItems.ORICHALCUM_HELMET.getId(), 0.15, AttributeModifier.Operation.ADD_VALUE)).addBonus(Attributes.MOVEMENT_SPEED, new AttributeModifier(ArmorItems.ORICHALCUM_HELMET.getId(), 0.08, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))).build());
        equippableGroup.addEquippableSet("chestplate", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.CHEST, ArmorItems.ORICHALCUM_CHESTPLATE}).bindHook(builder -> builder.addBonus(TCAttributes.getCriticalChance(), new AttributeModifier(ArmorItems.ORICHALCUM_BOOTS.getId(), 0.06, AttributeModifier.Operation.ADD_VALUE))).build());
        equippableGroup.addEquippableSet("leggings", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.LEGS, ArmorItems.ORICHALCUM_LEGGINGS}).bindHook(builder -> builder.addBonus(Attributes.ATTACK_DAMAGE, new AttributeModifier(ArmorItems.COBALT_LEGGINGS.getId(), 0.08, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).addBonus(TCAttributes.getRangedDamage(), new AttributeModifier(ArmorItems.COBALT_LEGGINGS.getId(), 0.08, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).addBonus(TCAttributes.getMagicDamage(), new AttributeModifier(ArmorItems.COBALT_LEGGINGS.getId(), 0.08, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).addBonus(TEAttributes.SUMMON_DAMAGE, new AttributeModifier(ArmorItems.COBALT_LEGGINGS.getId(), 0.08, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))).build());
        equippableGroup.addEquippableSet("boots", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.FEET, ArmorItems.ORICHALCUM_BOOTS}).bindHook(builder -> builder.addBonus(Attributes.MOVEMENT_SPEED, new AttributeModifier(ArmorItems.ORICHALCUM_BOOTS.getId(), 0.11, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))).build());
        equippableGroup.addEquippableSet("full_set", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.HEAD, Ingredient.of((ItemLike[])new ItemLike[]{ArmorItems.ORICHALCUM_MASK, ArmorItems.ORICHALCUM_HEADGEAR, ArmorItems.ORICHALCUM_HELMET}), VanillaWearable.CHEST, ArmorItems.ORICHALCUM_CHESTPLATE, VanillaWearable.LEGS, ArmorItems.ORICHALCUM_LEGGINGS, VanillaWearable.FEET, ArmorItems.ORICHALCUM_BOOTS}).bindHook((HookType)EBHookTypes.AFTER_LIVING_HURT_ENTITY.get(), (IHook)((AfterLivingHurtEntityHook)(owner, data) -> {
            if (data.damageSource().getDirectEntity() instanceof FlowerPetalProjectile) {
                return;
            }
            Player attacker = data.attacker();
            CompoundTag tag = LibUtils.getOrCreatePersistedData((Player)attacker);
            long gameTime = attacker.level().getGameTime();
            if (gameTime - tag.getLong("confluence:last_flower_petal_attack") < 6L) {
                return;
            }
            tag.putLong("confluence:last_flower_petal_attack", gameTime);
            FlowerPetalProjectile projectile = new FlowerPetalProjectile(attacker);
            Vec3 position = data.victim().position().add(0.0, (double)data.victim().getBbHeight() * 0.5, 0.0);
            RandomSource random = attacker.getRandom();
            double y = ((double)random.nextFloat() - 0.5) * 10.0;
            Vec3 offset = position.add(((double)random.nextFloat() - 0.5) * 10.0, y > 0.0 ? y + 5.0 : y, ((double)random.nextFloat() - 0.5) * 10.0);
            projectile.setPos(offset);
            projectile.shoot(position.x - offset.x, position.y - offset.y, position.z - offset.z, 1.2f, 0.0f);
            attacker.level().addFreshEntity((Entity)projectile);
        })).build());
    }
}

