/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.equipment_set;

import com.xiaohunao.equipment_benediction.common.equipment_set.EquipmentSet;
import com.xiaohunao.equipment_benediction.common.equipment_set.EquipmentSetBranch;
import com.xiaohunao.equipment_benediction.common.equipment_set.EquippableGroup;
import com.xiaohunao.equipment_benediction.common.equippable.VanillaWearable;
import com.xiaohunao.equipment_benediction.common.hook.HookMap;
import com.xiaohunao.equipment_benediction.common.hook.HookType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModHookTypes;
import org.confluence.mod.common.init.item.ArmorItems;
import org.confluence.terra_curio.common.init.TCAttributes;

public class WizardSet
extends EquipmentSet {
    protected void init(HookMap.Builder hook, EquippableGroup.Builder equippableGroup) {
        equippableGroup.addEquippableSet("wizard_hat", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.HEAD, ArmorItems.WIZARD_HAT}).bindHook(builder -> builder.addBonus(TCAttributes.getMagicDamage(), new AttributeModifier(ArmorItems.WIZARD_HAT.getId(), 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))).build());
        equippableGroup.addEquippableSet("magic_hat", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.HEAD, ArmorItems.MAGIC_HAT}).bindHook(builder -> builder.addBonus(TCAttributes.getMagicDamage(), new AttributeModifier(ArmorItems.MAGIC_HAT.getId(), 0.06, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).addBonus(TCAttributes.getCriticalChance(), new AttributeModifier(ArmorItems.MAGIC_HAT.getId(), 0.06, AttributeModifier.Operation.ADD_VALUE))).build());
        equippableGroup.addEquippableSet("amethyst_robe", WizardSet.robeBonus(ArmorItems.AMETHYST_ROBE, 20, 0.95f));
        equippableGroup.addEquippableSet("topaz_robe", WizardSet.robeBonus(ArmorItems.TOPAZ_ROBE, 40, 0.93f));
        equippableGroup.addEquippableSet("sapphire_robe", WizardSet.robeBonus(ArmorItems.SAPPHIRE_ROBE, 40, 0.91f));
        equippableGroup.addEquippableSet("emerald_robe", WizardSet.robeBonus(ArmorItems.JADE_ROBE, 60, 0.89f));
        equippableGroup.addEquippableSet("ruby_robe", WizardSet.robeBonus(ArmorItems.RUBY_ROBE, 60, 0.87f));
        equippableGroup.addEquippableSet("diamond_robe", WizardSet.robeBonus(ArmorItems.DIAMOND_ROBE, 80, 0.85f));
        equippableGroup.addEquippableSet("amber_robe", WizardSet.robeBonus(ArmorItems.AMBER_ROBE, 60, 0.87f));
        Ingredient robes = Ingredient.of((ItemLike[])new ItemLike[]{ArmorItems.AMETHYST_ROBE, ArmorItems.TOPAZ_ROBE, ArmorItems.SAPPHIRE_ROBE, ArmorItems.JADE_ROBE, ArmorItems.RUBY_ROBE, ArmorItems.MYSTIC_ROBE, ArmorItems.DIAMOND_ROBE, ArmorItems.AMBER_ROBE});
        equippableGroup.addEquippableSet("wizard_set", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.HEAD, ArmorItems.WIZARD_HAT, VanillaWearable.CHEST, robes}).bindHook(builder -> builder.addBonus(TCAttributes.getCriticalChance(), new AttributeModifier(Confluence.asResource("wizard_set"), 0.1, AttributeModifier.Operation.ADD_VALUE))).build());
        equippableGroup.addEquippableSet("magic_set", new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.HEAD, ArmorItems.MAGIC_HAT, VanillaWearable.CHEST, robes}).bindHook((HookType)ModHookTypes.ADDITIONAL_MANA.get(), (owner, player, original) -> original + 100).build());
    }

    private static EquipmentSetBranch robeBonus(DeferredItem<? extends ArmorItem> item, int additionalMana, float manaConsume) {
        return new EquipmentSetBranch.Builder().addEquippable(new Object[]{VanillaWearable.CHEST, item}).bindHook((HookType)ModHookTypes.ADDITIONAL_MANA.get(), (owner, player, original) -> original + additionalMana).bindHook((HookType)ModHookTypes.MANA_CONSUME.get(), (owner, itemStack, original) -> () -> original.getAsFloat() * manaConsume).build();
    }
}

