/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.event.game;

import java.util.Collection;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import org.confluence.lib.common.item.ColoredItem;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.component.prefix.PrefixComponent;
import org.confluence.mod.common.component.prefix.PrefixType;
import org.confluence.mod.common.entity.TreasureBagItemEntity;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.GunItems;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.item.accessory.GuideVooDooDollItem;
import org.confluence.mod.common.item.gun.ManaGunItem;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.PrefixUtils;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terra_guns.api.event.GunEvent;
import org.confluence.terra_guns.common.item.gun.BaseGun;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="confluence")
public final class ItemEvents {
    @SubscribeEvent(receiveCanceled=true)
    public static void itemStackedOnOther(ItemStackedOnOtherEvent event) {
        ItemStack carried = event.getCarriedItem();
        ItemStack onSlot = event.getStackedOnItem();
        if (event.getClickAction() == ClickAction.SECONDARY && ModUtils.useKey(carried, onSlot, event.getPlayer())) {
            event.setCanceled(true);
        }
        if (carried.is(MaterialItems.GEL)) {
            ColoredItem.merge((ItemStack)carried, (ItemStack)onSlot);
        }
    }

    @SubscribeEvent
    public static void attributeModifier(ItemAttributeModifierEvent event) {
        ItemStack itemStack = event.getItemStack();
        PrefixComponent prefix = PrefixUtils.getPrefix(itemStack);
        if (prefix == null || prefix.type() == PrefixType.UNKNOWN || prefix.type() == PrefixType.ACCESSORY || prefix.modifiers().isEmpty()) {
            return;
        }
        for (Map.Entry entry : prefix.modifiers().get().asMap().entrySet()) {
            Holder attribute = (Holder)entry.getKey();
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                event.addModifier(attribute, modifier, EquipmentSlotGroup.MAINHAND);
            }
        }
    }

    @SubscribeEvent
    public static void toss(ItemTossEvent event) {
        ItemEntity itemEntity = event.getEntity();
        ItemStack itemStack = itemEntity.getItem();
        if (itemStack.is(ModTags.Items.TREASURE_BAG)) {
            TreasureBagItemEntity.convert(itemEntity);
            event.setCanceled(true);
        } else if (itemStack.is(AccessoryItems.GUIDE_VOODOO_DOLL)) {
            GuideVooDooDollItem.setForward(event.getPlayer(), itemStack);
        } else if (itemStack.is(ModTags.Items.COINS)) {
            itemEntity.playSound((SoundEvent)ModSoundEvents.COINS_SMALL.get());
        }
        ModUtils.makeItemAntigravity(itemEntity);
    }

    @SubscribeEvent
    public static void gunFire(GunEvent.GunFireEvent event) {
        if (event.getGun() instanceof ManaGunItem) {
            event.setFire(true);
        }
    }

    @SubscribeEvent
    public static void shirkAmmo(GunEvent.ShrinkBulletEvent event) {
        if (event.getGun() instanceof ManaGunItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void ammoData(GunEvent.AmmoDataEvent event) {
        Player player = event.getPlayer();
        float velocityModify = (float)player.getAttributeValue(TCAttributes.getRangedVelocity());
        float knockbackModify = (float)player.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        BaseGun baseGun = event.getGun();
        if (baseGun instanceof ManaGunItem) {
            ManaGunItem manaGunItem = (ManaGunItem)baseGun;
            event.setDamage(manaGunItem.getDamage());
            event.setInaccuracy(manaGunItem.getInaccuracy());
            event.setVelocity(manaGunItem.getVelocity());
            event.setPenetrate(manaGunItem.getPenetrate());
            event.setKnockback(manaGunItem.getKnockback());
            event.setCritical(manaGunItem.getCritical());
        }
        event.setVelocity(event.getVelocity() * velocityModify);
        event.setKnockback(event.getKnockback() * knockbackModify);
    }

    @SubscribeEvent
    public static void ammoSelection(GunEvent.AmmoSelectionEvent event) {
        if (GunItems.STAR_CANNON.toStack().is((Item)event.getGun())) {
            event.setSelected(event.getAmmo().is((Item)MaterialItems.FALLING_STAR.get()));
        }
    }

    @SubscribeEvent
    public static void extraInventory(GunEvent.InventoryExtraEvent event) {
        event.addAmmoFirst(ExtraInventory.of((LivingEntity)event.getPlayer()).getAllAmmo());
    }
}

