/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.event.game;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.ChunkDropletsData;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.attachment.PlayerSpecialData;
import org.confluence.mod.common.block.functional.network.PathService;
import org.confluence.mod.common.data.saved.BossDelaySpawner;
import org.confluence.mod.common.data.saved.ConfluenceData;
import org.confluence.mod.common.data.saved.HardmodeConvertor;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.data.saved.MeteoriteTracker;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.common.entity.FallingStarItemEntity;
import org.confluence.mod.common.item.fishing.AbstractFishingPole;
import org.confluence.mod.common.worldgen.secret_seed.TheConstant;
import org.confluence.mod.common.worldgen.structure.DungeonStructure;
import org.confluence.mod.mixed.IServerPlayer;
import org.confluence.mod.mixed.Immunity;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terraentity.entity.boss.AbstractTerraBossBase;
import org.confluence.terraentity.entity.boss.EyeOfCthulhu;
import org.confluence.terraentity.init.entity.TEBossEntities;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="confluence")
public final class TickEvents {
    @SubscribeEvent
    public static void levelTick$Post(LevelTickEvent.Post event) {
        ServerLevel serverLevel;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel) || (serverLevel = (ServerLevel)level).dimension() != OverworldUtils.dimension()) {
            return;
        }
        FallingStarItemEntity.summon(serverLevel);
        MeteoriteTracker.INSTANCE.tick(serverLevel);
        BossDelaySpawner.INSTANCE.tick(serverLevel);
        int dayTime = LibDateUtils.getDayTime((Level)serverLevel);
        if (dayTime == LibDateUtils._06$00) {
            float factorX = Mth.nextFloat((RandomSource)serverLevel.random, (float)-1.0f, (float)1.0f);
            float factorZ = Mth.nextFloat((RandomSource)serverLevel.random, (float)-1.0f, (float)1.0f);
            ConfluenceData.get(serverLevel).setWindSpeed(factorX, factorZ);
        } else if (dayTime == LibDateUtils._19$30) {
            EntityType type = (EntityType)TEBossEntities.EYE_OF_CTHULHU.get();
            if (!KillBoard.INSTANCE.isDefeated(type) && !BossDelaySpawner.INSTANCE.hasSameTypeInQueue(type)) {
                for (ServerPlayer player : serverLevel.players()) {
                    boolean npcFactor;
                    boolean attributeFactor = player.getMaxHealth() >= 40.0f && player.getArmorValue() >= 10;
                    boolean bl = npcFactor = NPCSpawner.INSTANCE.getAliveNpcCount(new NPCSpawner.Region(NPCSpawner.getNpcSpawnPos(player)), entityType -> true) >= 4;
                    if (!attributeFactor || !npcFactor) continue;
                    if (!(serverLevel.random.nextFloat() < 0.3333f)) break;
                    BossDelaySpawner.INSTANCE.pushBoss(1350, (AbstractTerraBossBase)new EyeOfCthulhu((Level)serverLevel), LibDateUtils::isNight);
                    serverLevel.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"event.confluence.eye_of_cthulhu").withColor(GlobalColors.MESSAGE.get()), false);
                    break;
                }
            }
            if (KillBoard.INSTANCE.isAnyDefeated((EntityType)TEBossEntities.EATER_OF_WORLDS.get(), (EntityType)TEBossEntities.BRAIN_OF_CTHULHU.get()) && serverLevel.random.nextFloat() < 0.02f) {
                MeteoriteTracker.INSTANCE.spawnAtNextNight = true;
            }
        }
        if (((Boolean)CommonConfigs.DO_NPC_SPAWNING.get()).booleanValue() && LibDateUtils.isDay((int)dayTime) && serverLevel.getGameTime() % (long)((Integer)CommonConfigs.NPC_SPAWN_INTERVAL.get()).intValue() == 0L && serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            NPCSpawner.INSTANCE.checkNpcRespawn(serverLevel);
        }
        HardmodeConvertor.INSTANCE.scheduleRefill(serverLevel);
    }

    @SubscribeEvent
    public static void playerTick$Post(PlayerTickEvent.Post event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerLevel level = player.serverLevel();
            IServerPlayer.of(player).confluence$setCouldPickupItem(true);
            PlayerUtils.regenerateMana(player);
            ExtraInventory.of((LivingEntity)player).sync(player);
            AchievementUtils.youCanDoIt(player, level);
            AchievementUtils.quietNeighborhood(player, level);
            AchievementUtils.aRareRealm(player, level);
            TheConstant.applyDarkness(player, level);
            DungeonStructure.checkSkeletronDefeated(player, level);
            ChunkDropletsData.syncDroplets(player);
        }
        if (entity.level().getGameTime() % 60L == 3L) {
            AbstractFishingPole.resetCurrentBait(entity);
            PlayerSpecialData.resetSomeData(entity);
        }
    }

    @SubscribeEvent
    public static void entityTick$Post(EntityTickEvent.Post event) {
        Immunity.tick(event.getEntity());
    }

    @SubscribeEvent
    public static void serverTick$Post(ServerTickEvent.Post event) {
        PathService.INSTANCE.pathFindingTick();
    }
}

