/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.event.game.entity;

import com.xiaohunao.equipment_benediction.common.hook.HookMapManager;
import com.xiaohunao.equipment_benediction.common.hook.HookType;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.EffectParticleModificationEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.EverBeneficial;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.common.attachment.PlayerSpecialData;
import org.confluence.mod.common.block.natural.BloodthirstCrystallizedBlock;
import org.confluence.mod.common.block.natural.DecomposeTheSourceExtractBlock;
import org.confluence.mod.common.data.map.GamePhase2AttributeModifiers;
import org.confluence.mod.common.data.map.LivingInvulnerableEffects;
import org.confluence.mod.common.data.saved.Bestiary;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.common.effect.beneficial.ArcheryEffect;
import org.confluence.mod.common.effect.beneficial.LuckEffect;
import org.confluence.mod.common.effect.flask.FlaskEffect;
import org.confluence.mod.common.effect.harmful.ManaSicknessEffect;
import org.confluence.mod.common.effect.neutral.LoveEffect;
import org.confluence.mod.common.entity.projectile.boulder.TombstoneBoulderEntity;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModHookTypes;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.ArmorItems;
import org.confluence.mod.common.init.item.FoodItems;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.init.item.PickaxeItems;
import org.confluence.mod.common.init.item.SwordItems;
import org.confluence.mod.common.item.accessory.GuideVooDooDollItem;
import org.confluence.mod.common.item.common.BaseLanceItem;
import org.confluence.mod.common.item.sword.BaseSwordItem;
import org.confluence.mod.common.item.sword.SweetSword;
import org.confluence.mod.common.particle.DamageIndicatorOptions;
import org.confluence.mod.common.worldgen.secret_seed.NoTraps;
import org.confluence.mod.common.worldgen.secret_seed.TheConstant;
import org.confluence.mod.common.worldgen.structure.DungeonStructure;
import org.confluence.mod.mixed.IDamageSource;
import org.confluence.mod.mixed.ILevelChunkSection;
import org.confluence.mod.mixed.ILivingEntity;
import org.confluence.mod.mixed.IMobEffectInstance;
import org.confluence.mod.mixed.Immunity;
import org.confluence.mod.network.s2c.DeathMotionPacketS2C;
import org.confluence.mod.network.s2c.VisibilityPacketS2C;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.mod.util.DateUtils;
import org.confluence.mod.util.DynamicBiomeUtils;
import org.confluence.mod.util.EnchantmentUtils;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terra_curio.util.TCUtils;
import org.confluence.terraentity.api.entity.Boss;
import org.confluence.terraentity.api.entity.IMinion;
import org.confluence.terraentity.entity.boss.AbstractTerraBossBase;
import org.confluence.terraentity.entity.boss.Skeletron;
import org.confluence.terraentity.entity.monster.slime.GoldenSlime;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.confluence.terraentity.init.TETags;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.confluence.terraentity.init.entity.TEMonsterEntities;
import org.confluence.terraentity.init.entity.TENpcEntities;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="confluence")
public final class LivingEntityEvents {
    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        LivingEntity victim = event.getEntity();
        DamageSource damageSource = event.getSource();
        Level level = victim.level();
        if (level instanceof ServerLevel) {
            Boss boss;
            ServerLevel level2 = (ServerLevel)level;
            Entity attacker = damageSource.getEntity();
            if (attacker instanceof ServerPlayer) {
                IMinion minion;
                if (victim instanceof Enemy && ((Boolean)CommonConfigs.DROP_MONEY.get()).booleanValue() && level2.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT) && (!(victim instanceof IMinion) || (minion = (IMinion)victim).minion_getOwnerUUID() == null)) {
                    ModUtils.enemyDropMoney(victim, level2);
                }
                Bestiary.INSTANCE.updateEntry(victim, true);
            }
            if (attacker != null && attacker.getType().is(TETags.EntityTypes.CORRUPT)) {
                ((DecomposeTheSourceExtractBlock)((Object)NatureBlocks.DECOMPOSE_THE_SOURCE_EXTRACT_BLOCK.get())).checkVisibilityAndSummonEntity((Level)level2, victim);
            }
            if (victim instanceof Boss && (boss = (Boss)victim).shouldShowMessage()) {
                ModUtils.bossDeath(level2, victim);
            }
            if (victim instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)victim;
                PlayerUtils.dropMoney((Player)player);
                TombstoneBoulderEntity.createTombstone(player);
            }
            for (ServerPlayer player : level2.players()) {
                if (player.position().distanceToSqr(victim.position()) > 1024.0 || !ManaStorage.of((LivingEntity)player).canReceive() || !(player.getRandom().nextFloat() < 0.083f)) continue;
                LibUtils.createItemEntity((ItemStack)DateUtils.getStarItem().getDefaultInstance(), (Vec3)victim.position(), (Level)level2, (int)0);
                break;
            }
            if (victim instanceof AbstractTerraNPC) {
                AbstractTerraNPC npc = (AbstractTerraNPC)victim;
                NPCSpawner.INSTANCE.onNPCRemoved(npc);
                if (attacker != null && npc.getType() == TENpcEntities.CLOTHIER.get() && attacker instanceof Player) {
                    ServerPlayer player;
                    player = (Player)attacker;
                    if (LibDateUtils.isNight((Level)level2) && TCUtils.hasAccessoriesType((LivingEntity)player, AccessoryItems.CLOTHIER$KILLER)) {
                        Skeletron skeletron = new Skeletron((EntityType)TEBossEntities.SKELETRON.get(), (Level)level2);
                        skeletron.finalizeSpawn((ServerLevelAccessor)level2, level2.getCurrentDifficultyAt(skeletron.blockPosition()), MobSpawnType.EVENT, null);
                        ModUtils.summonBoss(level2, attacker.blockPosition(), (AbstractTerraBossBase)skeletron);
                    }
                }
                if (npc.getType() == TENpcEntities.GUIDE.get() && level2.dimension() == OverworldUtils.underworld() && damageSource.is(DamageTypes.LAVA)) {
                    GuideVooDooDollItem.summon((Entity)npc, level2, npc.getRandom().nextBoolean(), () -> null);
                }
            }
            if (victim.hasEffect(ModEffects.BLOOD_BUTCHERED)) {
                ((BloodthirstCrystallizedBlock)((Object)NatureBlocks.BLOODTHIRST_CRYSTALLIZED_BLOCK.get())).checkVisibility((Level)level2, victim);
            }
            DeathMotionPacketS2C.sendToAll(victim);
            NoTraps.entityDropsGrenade(victim);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void livingHeal(LivingHealEvent event) {
        LivingEntity living = event.getEntity();
        Level level = living.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        float amount = event.getAmount();
        if (EverBeneficial.of(living).isVitalCrystalUsed()) {
            amount *= 1.2f;
        }
        if (living.hasEffect(ModEffects.COZY_FIRE)) {
            amount *= 1.1f;
        }
        event.setAmount(amount);
        DamageIndicatorOptions.sendHealParticle(event.getAmount(), level2, living);
    }

    @SubscribeEvent
    public static void livingIncomingDamage(LivingIncomingDamageEvent event) {
        Player player;
        Entity entity;
        DamageSource damageSource = event.getSource();
        LivingEntity living = event.getEntity();
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            AccessoryItems.applyHurtGetMana(serverPlayer, damageSource, event.getAmount());
        }
        Immunity cause = Immunity.getCause(event.getSource());
        if (ILivingEntity.of(living).confluence$getImmunityTicks().containsKey((Object)cause)) {
            event.setCanceled(true);
        }
        if (cause != null) {
            event.getContainer().setPostAttackInvulnerabilityTicks(living.invulnerableTime);
        }
        if (!living.getType().is(ModTags.EntityTypes.CRITTER_COMPANIONSHIP_BLACKLIST) && (entity = damageSource.getEntity()) instanceof Player && !PlayerSpecialData.of(player = (Player)entity).isCouldHurtCritters() && (LibUtils.isAnimal((LivingEntity)living) || living.getType().is(ModTags.EntityTypes.CRITTER_COMPANIONSHIP_WHITELIST))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingDamage$Pre(LivingDamageEvent.Pre event) {
        Entity entity;
        Player player;
        Item item;
        ItemStack weapon;
        ServerPlayer player2;
        float amount = event.getNewDamage();
        if (amount <= 0.0f) {
            return;
        }
        LivingEntity victim = event.getEntity();
        Level level = victim.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        DamageSource damageSource = event.getSource();
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return;
        }
        @Nullable Entity attacker = damageSource.getEntity();
        amount = ArcheryEffect.apply(victim, damageSource, amount);
        amount = ManaSicknessEffect.apply(damageSource, amount);
        amount = TheConstant.applyAttackDamage(attacker, amount);
        ModUtils.applyBrainOfCthulhuDebuff(level2, attacker, victim);
        ModUtils.applyCursedSkullDebuff(attacker, victim);
        if (attacker instanceof ServerPlayer) {
            player2 = (ServerPlayer)attacker;
            EnchantmentUtils.dropsStar(player2, victim, damageSource);
            amount = EnchantmentUtils.processMagicAttack(player2, damageSource, amount);
        }
        if (victim instanceof ServerPlayer) {
            player2 = (ServerPlayer)victim;
            amount = EnchantmentUtils.processManaProtection(player2, damageSource, amount);
        }
        if (damageSource.is(DamageTypes.DROWN) && LibUtils.anyHandHasItem((LivingEntity)victim, (Item)((Item)SwordItems.BREATHING_REED.get()))) {
            amount *= 0.5f;
        }
        if ((weapon = damageSource.getWeaponItem()) != null && (item = weapon.getItem()) instanceof BaseSwordItem) {
            BaseSwordItem sword = (BaseSwordItem)item;
            sword.applyHitEffects(weapon, attacker, victim, damageSource);
        }
        boolean crit = false;
        if (!TCAttributes.hasCustomAttribute((Holder)TCAttributes.CRIT_CHANCE) && attacker instanceof Player && LibUtils.checkChance((double)(player = (Player)attacker).getAttributeValue((Holder)TCAttributes.CRIT_CHANCE), (RandomSource)player.getRandom())) {
            amount *= 1.5f;
            player.crit((Entity)victim);
            crit = true;
        }
        if ((entity = damageSource.getDirectEntity()) instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            crit |= arrow.isCritArrow();
        }
        ((IDamageSource)damageSource).confluence$setCritical(crit |= ((IDamageSource)damageSource).confluence$isCritical());
        event.setNewDamage(amount);
    }

    @SubscribeEvent
    public static void livingDamage$Post(LivingDamageEvent.Post event) {
        LivingEntity victim = event.getEntity();
        Level level = victim.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        DamageSource damageSource = event.getSource();
        Entity attacker = damageSource.getEntity();
        float amount = event.getNewDamage();
        FlaskEffect.onLivingDamage(victim, attacker, damageSource, amount);
        Immunity.calculateInvTicks(damageSource, victim);
        DamageIndicatorOptions.sendDamageParticle(serverLevel, damageSource, amount, victim);
        if (victim instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)victim;
            AchievementUtils.luckyBreak_watchYourStep(player, damageSource, attacker);
            BaseLanceItem.cancelSting(player);
        }
    }

    @SubscribeEvent
    public static void mobEffect$Applicable(MobEffectEvent.Applicable event) {
        if (event.getResult() == MobEffectEvent.Applicable.Result.DEFAULT && !(event.getEntity() instanceof Player)) {
            Holder effect = event.getEffectInstance().getEffect();
            if (LivingInvulnerableEffects.isInvulnerableTo(event.getEntity(), (Holder<MobEffect>)effect)) {
                event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
        }
        SweetSword.applyEffects(event);
    }

    @SubscribeEvent
    public static void mobEffect$Added(MobEffectEvent.Added event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        LoveEffect.onAdd(effectInstance, event.getEntity(), event.getEffectSource());
        FlaskEffect.removeAnotherFlaskEffects(effectInstance, event.getEntity());
    }

    @SubscribeEvent
    public static void mobEffect$Remove(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance == null) {
            return;
        }
        LuckEffect.onRemove(event.getEntity(), (Holder<MobEffect>)effectInstance.getEffect(), effectInstance.getAmplifier());
    }

    @SubscribeEvent
    public static void livingEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity living = event.getEntity();
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            AchievementUtils.matchingAttire_fashionStatement(event.getSlot(), serverPlayer);
            if (event.getTo().is(ModTags.Items.SHOW_SIGNAL)) {
                VisibilityPacketS2C.sendSignal(serverPlayer, true);
            } else if (event.getFrom().is(ModTags.Items.SHOW_SIGNAL)) {
                VisibilityPacketS2C.sendSignal(serverPlayer, false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void livingDrops(LivingDropsEvent event) {
        IMinion minion;
        Item holidayGift;
        LivingEntity living = event.getEntity();
        ServerLevel level = (ServerLevel)living.level();
        if (!level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            return;
        }
        Collection drops = event.getDrops();
        double x = living.getX();
        double y = living.getY();
        double z = living.getZ();
        if (living instanceof Player) {
            Player player = (Player)living;
            ExtraInventory data = ExtraInventory.of((LivingEntity)player);
            for (int i = 0; i < 4; ++i) {
                ItemStack itemStack = data.getCoins(i);
                if (!itemStack.isEmpty()) {
                    data.setItem(i, ItemStack.EMPTY);
                }
                drops.add(new ItemEntity((Level)level, x, y, z, itemStack));
            }
        }
        if (living.getRandom().nextFloat() < 0.011f && (holidayGift = DateUtils.getHolidayGift(living.getRandom())) != Items.AIR) {
            ItemEntity entity = new ItemEntity((Level)level, x, y, z, holidayGift.getDefaultInstance());
            entity.setNoPickUpDelay();
            drops.add(entity);
        }
        if (KillBoard.INSTANCE.getGamePhase().isHardmode() && living instanceof Enemy && (!(living instanceof IMinion) || (minion = (IMinion)living).minion_getOwnerUUID() == null) && !living.getType().is(ModTags.EntityTypes.DO_NOT_DROPS_EVIL_SOUL) && (y < (double)OverworldUtils.getUndergroundY() || ModSecretSeeds.DONT_DIG_UP.match(level) || ModSecretSeeds.GET_FIXED_BOI.match(level))) {
            float f = living.getRandom().nextFloat();
            float f2 = LibUtils.isAtLeastExpert((Level)level, (BlockPos)living.blockPosition()) ? 0.36f : 0.2f;
            if (f < f2) {
                Holder biome = level.getBiome(living.blockPosition());
                ItemStack soul = ItemStack.EMPTY;
                if (biome.is(ModTags.Biomes.THE_HALLOW)) {
                    soul = MaterialItems.SOUL_OF_LIGHT.toStack();
                } else if (biome.is(ModTags.Biomes.THE_CORRUPTION) || biome.is(ModTags.Biomes.THE_CRIMSON)) {
                    soul = MaterialItems.SOUL_OF_NIGHT.toStack();
                }
                if (soul != ItemStack.EMPTY) {
                    drops.add(new ItemEntity((Level)level, x, y, z, soul, 0.0, 0.02, 0.0));
                }
            }
        }
        for (ItemEntity entity : drops) {
            ModUtils.makeItemAntigravity(entity);
        }
    }

    @SubscribeEvent
    public static void livingGetProjectile(LivingGetProjectileEvent event) {
        LivingEntity living = event.getEntity();
        event.setProjectileItemStack(ExtraInventory.getProjectile(event.getProjectileItemStack(), event.getProjectileWeaponItemStack(), living));
        if (!event.getProjectileItemStack().isEmpty()) {
            if (living.hasEffect(ModEffects.AMMO_BOX) && living.getRandom().nextFloat() < 0.2f) {
                event.setProjectileItemStack(event.getProjectileItemStack().copy());
                return;
            }
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                HookMapManager.postHooks((HookType)((HookType)ModHookTypes.SKIP_AMMO_CONSUME.get()), (owner, hook, original) -> {
                    if (hook.shouldSkipConsume(owner, original.getEntity(), original.getProjectileItemStack())) {
                        original.setProjectileItemStack(original.getProjectileItemStack().copy());
                    }
                    return original;
                }, (Entity)player, (Object)event);
            }
        }
    }

    @SubscribeEvent
    public static void livingBreathe(LivingBreatheEvent event) {
        boolean b;
        LivingEntity living = event.getEntity();
        boolean bl = b = !living.getActiveEffectsMap().isEmpty();
        if (b && living.hasEffect(ModEffects.CHOKING)) {
            living.setAirSupply(living.getAirSupply() - 5);
        }
        if (event.canBreathe()) {
            return;
        }
        if (b && living.hasEffect(ModEffects.SHIMMER)) {
            event.setCanBreathe(true);
        } else if (LibUtils.anyHandHasItem((LivingEntity)living, itemStack -> !itemStack.isEmpty() && itemStack.is(SwordItems.BREATHING_REED))) {
            if (living.canDrownInFluidType(living.level().getFluidState(living.blockPosition().offset(0, 2, 0)).getFluidType())) {
                event.setConsumeAirAmount(living.getRandom().nextInt(2) > 0 ? 0 : 1);
            } else {
                event.setCanBreathe(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void finalizeSpawn(FinalizeSpawnEvent event) {
        Mob difficulty3;
        Mob mob = event.getEntity();
        if (mob.getType() == EntityType.ZOMBIE) {
            BlockPos blockPos = BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ());
            Holder biome = mob.level().getBiome(blockPos);
            DifficultyInstance difficulty2 = event.getDifficulty();
            if (biome.is(Tags.Biomes.IS_ICY) || biome.is(Tags.Biomes.IS_SNOWY)) {
                boolean pink = mob.getRandom().nextFloat() < 0.01f;
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty2, (EquipmentSlot)EquipmentSlot.HEAD, (Item)((Item)(pink ? ArmorItems.PINK_SNOW_CAPS : ArmorItems.SNOW_CAPS).get()), (float)0.003f);
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty2, (EquipmentSlot)EquipmentSlot.CHEST, (Item)((Item)(pink ? ArmorItems.PINK_SNOW_SUITS : ArmorItems.SNOW_SUITS).get()), (float)0.003f);
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty2, (EquipmentSlot)EquipmentSlot.LEGS, (Item)((Item)(pink ? ArmorItems.PINK_INSULATED_PANTS : ArmorItems.INSULATED_PANTS).get()), (float)0.003f);
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty2, (EquipmentSlot)EquipmentSlot.FEET, (Item)((Item)(pink ? ArmorItems.PINK_INSULATED_SHOES : ArmorItems.INSULATED_SHOES).get()), (float)0.003f);
                mob.setCustomName((Component)Component.translatable((String)"entity.confluence.frozen_zombie"));
                event.setCanceled(true);
            } else if (ModUtils.isRainingAt(mob.level(), blockPos)) {
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty2, (EquipmentSlot)EquipmentSlot.HEAD, (Item)((Item)ArmorItems.RAIN_CAP.get()), (float)0.003f);
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty2, (EquipmentSlot)EquipmentSlot.CHEST, (Item)((Item)ArmorItems.RAINCOAT.get()), (float)0.003f);
                mob.setCustomName((Component)Component.translatable((String)"entity.confluence.raincoat_zombie"));
                event.setCanceled(true);
            }
        } else if (mob.getType() == EntityType.SKELETON) {
            DifficultyInstance difficulty3 = event.getDifficulty();
            if (!mob.level().canSeeSky(BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ())) && mob.getRandom().nextFloat() < 0.01f) {
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty3, (EquipmentSlot)EquipmentSlot.HEAD, (Item)((Item)ArmorItems.MINING_HELMET.get()), (float)1.0f);
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty3, (EquipmentSlot)EquipmentSlot.CHEST, (Item)((Item)ArmorItems.MINING_CHESTPLATE.get()), (float)1.0f);
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty3, (EquipmentSlot)EquipmentSlot.LEGS, (Item)((Item)ArmorItems.MINING_LEGGINGS.get()), (float)1.0f);
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty3, (EquipmentSlot)EquipmentSlot.FEET, (Item)((Item)ArmorItems.MINING_BOOTS.get()), (float)1.0f);
                LibUtils.setItemAndDropChance((Mob)mob, (DifficultyInstance)difficulty3, (EquipmentSlot)EquipmentSlot.MAINHAND, (Item)((Item)PickaxeItems.BONE_PICKAXE.get()), (float)0.25f);
                mob.setCustomName((Component)Component.translatable((String)"entity.confluence.undead_miner"));
                event.setCanceled(true);
            }
        } else if (event.getSpawnType() == MobSpawnType.NATURAL && (difficulty3 = event.getEntity()) instanceof Slime) {
            Slime slime = (Slime)difficulty3;
            if ((ModSecretSeeds.CELEBRATIONMK10.match() || ModSecretSeeds.GET_FIXED_BOI.match()) && mob.getRandom().nextInt(140) == 1) {
                event.setCanceled(true);
                GoldenSlime goldenSlime = (GoldenSlime)((EntityType)TEMonsterEntities.GOLDEN_SLIME.get()).create(mob.level());
                if (goldenSlime != null) {
                    goldenSlime.moveTo(slime.getX(), slime.getY(), slime.getZ(), slime.getYRot(), slime.getXRot());
                    mob.level().addFreshEntity((Entity)goldenSlime);
                }
            }
        }
        if (!event.isCanceled()) {
            GamePhase2AttributeModifiers.applyModifiers((LivingEntity)mob);
        }
    }

    @SubscribeEvent
    public static void livingEntityUseItem$Start(LivingEntityUseItemEvent.Start event) {
        ItemStack itemStack;
        LivingEntity living = event.getEntity();
        if (!living.level().isClientSide && living.hasEffect(ModEffects.CHOKING) && (itemStack = event.getItem()).getFoodProperties(living) != null) {
            event.setCanceled(true);
            living.sendSystemMessage((Component)Component.translatable((String)"message.confluence.choking"));
        }
    }

    @SubscribeEvent
    public static void livingEntityUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack itemStack = event.getItem();
        RandomSource random = player.getRandom();
        if (itemStack.is((Item)FoodItems.GREEN_DUMPLING.get()) && random.nextInt(6) == 0) {
            player.addEffect(new MobEffectInstance(ModEffects.CHOKING, 2400));
        }
        if (player.hasEffect(ModEffects.CHOKING) && ModUtils.isWaterBottle(itemStack)) {
            player.removeEffect(ModEffects.CHOKING);
            ItemStack resultItem = itemStack.finishUsingItem(player.level(), (LivingEntity)player);
            event.setResultStack(resultItem);
        }
        if (itemStack.is((Item)FoodItems.PIGLIN_STEW.get())) {
            player.setHealth(player.getMaxHealth());
            player.getFoodData().setFoodLevel(20);
            player.getFoodData().setSaturation(20.0f);
            PlayerUtils.receiveMana(player, () -> 1000.0f);
            List<Holder> negativeEffects = player.getActiveEffects().stream().map(MobEffectInstance::getEffect).filter(effect -> !((MobEffect)effect.value()).isBeneficial()).toList();
            for (int i = negativeEffects.size() - 1; i >= 0; --i) {
                player.removeEffect(negativeEffects.get(i));
            }
        }
    }

    @SubscribeEvent
    public static void mobSpawn$PositionCheck(MobSpawnEvent.PositionCheck event) {
        if (event.getSpawnType() == MobSpawnType.NATURAL) {
            ILevelChunkSection iSection;
            Mob mob = event.getEntity();
            if (event.getResult() != MobSpawnEvent.PositionCheck.Result.FAIL && DungeonStructure.skipSpawn(mob, event.getLevel().getLevel())) {
                event.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
            }
            if (mob.getType().is(ModTags.EntityTypes.SPAWN_AT_GRAVEYARD) && (iSection = DynamicBiomeUtils.getISection((LevelAccessor)event.getLevel(), mob.blockPosition())) != null && iSection.confluence$isGraveyard()) {
                event.setResult(MobSpawnEvent.PositionCheck.Result.SUCCEED);
            }
        }
    }

    @SubscribeEvent
    public static void mobSpawn$SpawnPlacementCheck(MobSpawnEvent.SpawnPlacementCheck event) {
        ILevelChunkSection iSection;
        EntityType entityType;
        if (event.getSpawnType() == MobSpawnType.NATURAL && !event.getPlacementCheckResult() && (entityType = event.getEntityType()).is(ModTags.EntityTypes.SPAWN_AT_GRAVEYARD) && (iSection = DynamicBiomeUtils.getISection((LevelAccessor)event.getLevel(), event.getPos())) != null && iSection.confluence$isGraveyard()) {
            event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.SUCCEED);
        }
    }

    @SubscribeEvent
    public static void effectParticleModification(EffectParticleModificationEvent event) {
        if (event.isVisible() && !IMobEffectInstance.of(event.getEffect()).confluence$isEnabled()) {
            event.setVisible(false);
        }
    }
}

