/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.event.game.entity;

import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.confluence.lib.common.item.ColoredItem;
import org.confluence.mod.api.event.MinecartAbilityEvent;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.ChunkDropletsData;
import org.confluence.mod.common.attachment.EverBeneficial;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.common.attachment.PlayerPiggyBankContainer;
import org.confluence.mod.common.block.functional.crafting.AltarBlock;
import org.confluence.mod.common.data.AchievementOffsetLoader;
import org.confluence.mod.common.data.map.DiggingPower;
import org.confluence.mod.common.data.saved.HardmodeConvertor;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.common.entity.TreasureBagItemEntity;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.ModTiers;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.init.item.PotionItems;
import org.confluence.mod.common.item.common.BaseAxeItem;
import org.confluence.mod.common.item.common.DungeonCompass;
import org.confluence.mod.common.item.common.EverBeneficialItem;
import org.confluence.mod.common.menu.FletchingTableMenu;
import org.confluence.mod.common.worldgen.secret_seed.BoulderWorld;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.mixed.IServerPlayer;
import org.confluence.mod.network.s2c.CompatibilitySyncPacketS2c;
import org.confluence.mod.network.s2c.ExtraInventorySyncPacketS2C;
import org.confluence.mod.network.s2c.FishingPowerInfoPacketS2C;
import org.confluence.mod.network.s2c.PiggyBankTotalMoneyPacket;
import org.confluence.mod.network.s2c.SecretFlagSyncPacketS2C;
import org.confluence.mod.network.s2c.VisibilityPacketS2C;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terra_curio.util.TCUtils;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="confluence")
public final class PlayerEvents {
    @SubscribeEvent
    public static void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        PlayerUtils.syncMana2Client(player);
        PlayerUtils.syncSavedData(player);
        ExtraInventorySyncPacketS2C.sendToClient(player, player, ExtraInventory.of((LivingEntity)player));
        PiggyBankTotalMoneyPacket.sendToClient(player, PlayerPiggyBankContainer.of((Player)player), true);
        FishingPowerInfoPacketS2C.sendAndGet(player);
        VisibilityPacketS2C.sendEcho(player);
        BoulderWorld.forceSetAccessory(player);
        VisibilityPacketS2C.sendTheConstantPostEffect(player);
        SecretFlagSyncPacketS2C.sendToAll(IMinecraftServer.of(player.server).confluence$getSecretFlag());
        if (HardmodeConvertor.INSTANCE.isCompleted()) {
            AchievementUtils.awardAchievement(player, "its_hard");
        }
        if (((Boolean)CommonConfigs.DO_NPC_SPAWNING.get()).booleanValue() && player.level().getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            NPCSpawner.INSTANCE.trySpawnGuide(player);
        }
        CompatibilitySyncPacketS2c.sendToAll();
    }

    @SubscribeEvent
    public static void loggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ChunkDropletsData.of((Level)player.serverLevel()).getLastSync().remove(player.getUUID());
    }

    @SubscribeEvent
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        AltarBlock.onLeftClick(level.getBlockState(pos), level, pos, event.getEntity());
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos blockPos = event.getPos();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (!event.getUseBlock().isTrue() && block instanceof AltarBlock) {
            event.setUseBlock(TriState.TRUE);
        }
        if (player.isCrouching()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (((Boolean)CommonConfigs.RIGHT_CLICK_RIDE_MINECART.get()).booleanValue() && !(itemStack.getItem() instanceof BlockItem) && !itemStack.is(ModTags.Items.MINECART) && block instanceof BaseRailBlock) {
            BaseRailBlock railBlock = (BaseRailBlock)block;
            if (!player.isSpectator() && !player.isPassenger()) {
                player.swing(InteractionHand.MAIN_HAND);
                if (!level.isClientSide) {
                    ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)player);
                    ItemStack minecartItemStack = extraInventory.getMinecart(false);
                    MinecartAbilityEvent.RightClickRailBlock e = (MinecartAbilityEvent.RightClickRailBlock)NeoForge.EVENT_BUS.post((Event)new MinecartAbilityEvent.RightClickRailBlock(player, minecartItemStack, blockState, railBlock, blockPos));
                    if (e.isCanceled()) {
                        return;
                    }
                    AbstractMinecart minecart = e.getMinecart();
                    if (minecart != null) {
                        extraInventory.setEquipment(2, ItemStack.EMPTY, false);
                        level.addFreshEntity((Entity)minecart);
                        player.startRiding((Entity)minecart, true);
                    }
                }
                event.setCanceled(true);
            }
        }
        if (((Boolean)CommonConfigs.FLETCHING_MENU.get()).booleanValue() && blockState.is(Blocks.FLETCHING_TABLE)) {
            if (!level.isClientSide) {
                player.openMenu((MenuProvider)new FletchingTableMenu.Provider(level, blockPos));
            }
            player.swing(InteractionHand.MAIN_HAND);
            event.setCanceled(true);
        }
        if (!level.isClientSide && itemStack.is(ModTags.Items.CROP_FORTUNE)) {
            BaseAxeItem.dropAndPlaceOnRightClick(player, itemStack, blockPos);
        }
        DungeonCompass.matches(player, event.getHand(), level, itemStack, blockState, blockPos);
    }

    @SubscribeEvent
    public static void playerInteract$EntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof LivingEntity) {
                LivingEntity targetEntity = (LivingEntity)player;
                ItemStack item = serverPlayer.getMainHandItem();
                boolean isWaterBottle = ModUtils.isWaterBottle(item);
                if (isWaterBottle && targetEntity.hasEffect(ModEffects.CHOKING)) {
                    ItemStack emptyBottle;
                    targetEntity.removeEffect(ModEffects.CHOKING);
                    ItemStack itemStack = emptyBottle = item.is(PotionItems.BOTTLED_WATER) ? PotionItems.BOTTLE.toStack() : Items.GLASS_BOTTLE.getDefaultInstance();
                    if (!serverPlayer.hasInfiniteMaterials()) {
                        serverPlayer.getInventory().add(emptyBottle);
                        item.shrink(1);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void itemEntityPickup$Pre(ItemEntityPickupEvent.Pre event) {
        TreasureBagItemEntity entity;
        ItemEntity itemEntity = event.getItemEntity();
        ItemStack itemStack = itemEntity.getItem();
        Player player = event.getPlayer();
        if (itemStack.is(ModTags.Items.PROVIDE_MANA)) {
            ManaStorage.of((LivingEntity)player).receiveMana(() -> (float)itemStack.getCount() * 100.0f);
            itemEntity.discard();
            event.setCanPickup(TriState.FALSE);
        } else if (itemStack.is(ModTags.Items.PROVIDE_LIFE)) {
            player.heal((float)itemStack.getCount() * 4.0f);
            itemEntity.discard();
            event.setCanPickup(TriState.FALSE);
        } else if (itemEntity instanceof TreasureBagItemEntity && !(entity = (TreasureBagItemEntity)itemEntity).isOwner(player)) {
            event.setCanPickup(TriState.FALSE);
        }
    }

    @SubscribeEvent
    public static void itemEntityPickup$Post(ItemEntityPickupEvent.Post event) {
        ItemEntity itemEntity = event.getItemEntity();
        ItemStack itemStack = event.getOriginalStack();
        if (itemStack.is(ModTags.Items.COINS)) {
            if (itemStack.is(ModItems.COPPER_COIN)) {
                itemEntity.playSound((SoundEvent)ModSoundEvents.COINS_SMALL.get());
            } else if (itemStack.is(ModItems.SILVER_COIN)) {
                itemEntity.playSound((SoundEvent)ModSoundEvents.COINS_MEDIUM.get());
            } else {
                itemEntity.playSound((SoundEvent)ModSoundEvents.COINS_LARGE.get());
            }
        }
    }

    @SubscribeEvent
    public static void itemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (!TCUtils.hasAccessoriesType((LivingEntity)player, AccessoryItems.HIGH$TEST$FISHING$LINE) && player.getRandom().nextFloat() < 0.1429f) {
            player.level().playSound(null, event.getHookEntity().blockPosition(), (SoundEvent)ModSoundEvents.DECOUPLING.get(), SoundSource.AMBIENT);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.isSpectator()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack.is(ModTags.Items.MANA_WEAPON) && player.hasEffect(ModEffects.SILENCED)) {
            event.setCanceled(true);
        } else if (!itemStack.isEmpty() && (player.hasEffect(ModEffects.STONED) || player.hasEffect(ModEffects.FROZEN) || player.hasEffect(ModEffects.CURSED))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Entity target = event.getTarget();
            AccessoryItems.applyLuckyCoin(serverPlayer, target);
        }
        if (player.getMainHandItem().is(ModTags.Items.SPEAR)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void clone(PlayerEvent.Clone event) {
        Player old = event.getOriginal();
        Player neo = event.getEntity();
        for (MobEffectInstance activeEffect : old.getActiveEffects()) {
            neo.forceAddEffect(activeEffect, null);
        }
    }

    @SubscribeEvent
    public static void respawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        EverBeneficial everBeneficial = EverBeneficial.of((LivingEntity)player);
        EverBeneficialItem.LIFE_CRYSTAL.recovery(everBeneficial, eb -> eb.getUsedLifeCrystals() > 0, player);
        EverBeneficialItem.LIFE_FRUITS.recovery(everBeneficial, eb -> eb.getUsedLifeFruits() > 0, player);
        EverBeneficialItem.AEGIS_APPLE.recovery(everBeneficial, EverBeneficial::isAegisAppleUsed, player);
        EverBeneficialItem.AMBROSIA.recovery(everBeneficial, EverBeneficial::isAmbrosiaUsed, player);
        EverBeneficialItem.GALAXY_PEARL.recovery(everBeneficial, EverBeneficial::isGalaxyPearlUsed, player);
        EverBeneficialItem.ARTISAN_LOAF.recovery(everBeneficial, EverBeneficial::isArtisanLoafUsed, player);
        BoulderWorld.forceSetAccessory(player);
        ExtraInventorySyncPacketS2C.sendToClient(player, player, ExtraInventory.of((LivingEntity)player));
    }

    @SubscribeEvent
    public static void harvestCheck(PlayerEvent.HarvestCheck event) {
        ItemStack itemStack = event.getEntity().getMainHandItem();
        if (!itemStack.isEmpty() && itemStack.is(ItemTags.PICKAXES)) {
            event.setCanHarvest(ModTiers.isCorrectToolForDrops(DiggingPower.getPower(itemStack), itemStack, event.getTargetBlock()));
        }
    }

    @SubscribeEvent
    public static void itemPickup(ItemEntityPickupEvent.Pre event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        if (IServerPlayer.of(player).confluence$isCouldPickupItem()) {
            Item gel;
            ItemStack itemStack;
            if (((Boolean)CommonConfigs.AUTO_STACK_GELS_COLOR.get()).booleanValue() && (itemStack = event.getItemEntity().getItem()).is(gel = (Item)MaterialItems.GEL.get())) {
                int defaultMaxStackSize = gel.getDefaultMaxStackSize();
                for (ItemStack stack : player.getInventory().items) {
                    if (stack.isEmpty() || !stack.is(gel) || stack.getCount() + itemStack.getCount() > defaultMaxStackSize) continue;
                    ColoredItem.setRGBA((ItemStack)itemStack, (int)ColoredItem.getRGBA((ItemStack)stack));
                    break;
                }
            }
        } else {
            event.setCanPickup(TriState.FALSE);
        }
    }

    @SubscribeEvent
    public static void advancementEarn(AdvancementEvent.AdvancementEarnEvent event) {
        AdvancementHolder advancement = event.getAdvancement();
        if (advancement.value().display().map(DisplayInfo::shouldAnnounceChat).orElse(false).booleanValue() && AchievementOffsetLoader.getDisplayOffset().containsKey(advancement.id())) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            player.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"chat.type.advancement.achievement", (Object[])new Object[]{player.getDisplayName(), Advancement.name((AdvancementHolder)advancement)}), false);
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ExtraInventorySyncPacketS2C.sendToClient((ServerPlayer)event.getEntity(), player, ExtraInventory.of((LivingEntity)player));
        } else {
            entity = event.getTarget();
            if (entity instanceof AbstractTerraNPC) {
                AbstractTerraNPC npc = (AbstractTerraNPC)entity;
                NPCSpawner.INSTANCE.applyBenedictions(npc);
            }
        }
    }

    @SubscribeEvent
    public static void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ExtraInventorySyncPacketS2C.sendToClient(player, player, ExtraInventory.of((LivingEntity)player));
    }
}

