/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.command.EnumArgument;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.attachment.ChunkBrushData;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.common.component.prefix.ModPrefix;
import org.confluence.mod.common.component.prefix.PrefixComponent;
import org.confluence.mod.common.component.prefix.PrefixType;
import org.confluence.mod.common.data.PrefixArgument;
import org.confluence.mod.common.data.saved.BrushData;
import org.confluence.mod.common.data.saved.ConfluenceData;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.data.saved.MeteoriteTracker;
import org.confluence.mod.common.data.saved.StarPhase;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.item.PaintItems;
import org.confluence.mod.common.item.paint.PaintItem;
import org.confluence.mod.network.s2c.BrushingColorPacketS2C;
import org.confluence.mod.util.DynamicBiomeUtils;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.mod.util.PrefixUtils;
import org.jetbrains.annotations.Contract;

public final class ModCommands {
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> ARGUMENT_TYPE_INFOS = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"confluence");
    public static final Holder<ArgumentTypeInfo<?, ?>> PREFIX_ARGUMENT_TYPE = ARGUMENT_TYPE_INFOS.register("prefix", () -> (PrefixArgument.Info)ArgumentTypeInfos.registerByClass(PrefixArgument.class, (ArgumentTypeInfo)new PrefixArgument.Info()));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"confluence").requires(sourceStack -> sourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"starPhases").then(Commands.literal((String)"get").then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0, (int)9)).executes(context -> {
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
            StarPhase starPhase = ConfluenceData.get(((CommandSourceStack)context.getSource()).getLevel()).getStarPhase(index);
            if (starPhase == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No such StarPhase!"));
                return 0;
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)starPhase.toString()));
            return 1;
        })))).then(Commands.literal((String)"set").then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0, (int)9)).then(Commands.argument((String)"timeOffset", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"radius", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"angle", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
            int timeOffset = IntegerArgumentType.getInteger((CommandContext)context, (String)"timeOffset");
            float radius = FloatArgumentType.getFloat((CommandContext)context, (String)"radius");
            float angle = FloatArgumentType.getFloat((CommandContext)context, (String)"angle");
            ConfluenceData data = ConfluenceData.get(((CommandSourceStack)context.getSource()).getLevel());
            if (!data.setStarPhase(index, timeOffset, radius, angle)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Can not set StarPhase!"));
                return 0;
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Has been set to " + String.valueOf(data.getStarPhase(index)))), true);
            return 1;
        })))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"gamePhase").then(Commands.literal((String)"get").executes(context -> {
            String gamePhase = KillBoard.INSTANCE.getGamePhase().getSerializedName();
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("GamePhase: " + gamePhase)));
            return 1;
        }))).then(Commands.literal((String)"set").then(Commands.argument((String)"value", (ArgumentType)EnumArgument.enumArgument(GamePhase.class)).executes(context -> {
            GamePhase gamePhase = (GamePhase)((Object)((Object)context.getArgument("value", GamePhase.class)));
            ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).getLevel();
            KillBoard.INSTANCE.setGamePhase(serverLevel.getServer(), gamePhase);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Has been set to " + gamePhase.getSerializedName())), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"windSpeed").then(Commands.literal((String)"get").executes(context -> {
            ConfluenceData data = ConfluenceData.get(((CommandSourceStack)context.getSource()).getLevel());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Wind speed: [" + data.getWindSpeedX() + ", " + data.getWindSpeedZ() + "]")));
            return 1;
        }))).then(Commands.literal((String)"set").then(Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            float x = FloatArgumentType.getFloat((CommandContext)context, (String)"x");
            float z = FloatArgumentType.getFloat((CommandContext)context, (String)"z");
            ConfluenceData.get(((CommandSourceStack)context.getSource()).getLevel()).setWindSpeed(x, z);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Has been set to [" + x + ", " + z + "]")));
            return 1;
        })))))).then(((LiteralArgumentBuilder)Commands.literal((String)"meteorite").then(Commands.literal((String)"random").then(Commands.argument((String)"tickUntilLanding", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int tickUntilLanding = IntegerArgumentType.getInteger((CommandContext)context, (String)"tickUntilLanding");
            MeteoriteTracker.INSTANCE.generateLandingDetail(((CommandSourceStack)context.getSource()).getLevel(), tickUntilLanding);
            return 1;
        })))).then(Commands.argument((String)"location", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"tickUntilLanding", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            BlockPos location = BlockPosArgument.getBlockPos((CommandContext)context, (String)"location");
            int tickUntilLanding = IntegerArgumentType.getInteger((CommandContext)context, (String)"tickUntilLanding");
            ConfluenceData.get(((CommandSourceStack)context.getSource()).getLevel()).setMeteorite(location, tickUntilLanding);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"paint").then(Commands.argument((String)"start", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"end", (ArgumentType)BlockPosArgument.blockPos()).then(((LiteralArgumentBuilder)Commands.literal((String)"brush").then(Commands.argument((String)"face", (ArgumentType)EnumArgument.enumArgument(Direction.class)).then(Commands.argument((String)"color", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Direction face = (Direction)context.getArgument("face", Direction.class);
            int color = IntegerArgumentType.getInteger((CommandContext)context, (String)"color");
            int[] list = BrushData.createColor(-1);
            list[face.get3DDataValue()] = color;
            return ModCommands.fillPaints((CommandContext<CommandSourceStack>)context, list);
        })))).then(Commands.argument((String)"color", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int color = IntegerArgumentType.getInteger((CommandContext)context, (String)"color");
            int[] list = BrushData.createColor(color);
            return ModCommands.fillPaints((CommandContext<CommandSourceStack>)context, list);
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"scraper").then(Commands.argument((String)"face", (ArgumentType)EnumArgument.enumArgument(Direction.class)).executes(context -> {
            Direction face = (Direction)context.getArgument("face", Direction.class);
            int[] list = BrushData.createColor(-1);
            list[face.get3DDataValue()] = -2;
            return ModCommands.fillPaints((CommandContext<CommandSourceStack>)context, list);
        }))).executes(context -> ModCommands.fillPaints((CommandContext<CommandSourceStack>)context, BrushingColorPacketS2C.CLEAR_COLORS)))))).then(Commands.literal((String)"item").then(Commands.argument((String)"color", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntityOrException();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                int color = IntegerArgumentType.getInteger((CommandContext)context, (String)"color");
                ItemStack itemStack = ((PaintItem)((Object)((Object)PaintItems.PAINT.get()))).getDefaultInstance();
                itemStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, true));
                player.getInventory().add(itemStack);
                return 1;
            }
            return 0;
        }))))).then(Commands.literal((String)"judgeBiome").executes(context -> {
            BlockPos pos;
            Level level;
            CommandSource patt0$temp = ((CommandSourceStack)context.getSource()).source;
            if (patt0$temp instanceof Entity) {
                Entity entity = (Entity)patt0$temp;
                level = entity.level();
                pos = entity.blockPosition();
            } else {
                CommandSource patt1$temp = ((CommandSourceStack)context.getSource()).source;
                if (patt1$temp instanceof BaseCommandBlock) {
                    BaseCommandBlock commandBlock = (BaseCommandBlock)patt1$temp;
                    level = commandBlock.getLevel();
                    Vec3 position = commandBlock.getPosition();
                    pos = new BlockPos((int)position.x, (int)position.y, (int)position.z);
                } else {
                    return 1;
                }
            }
            LevelChunk chunk = level.getChunkAt(pos);
            LevelChunkSection section = chunk.getSection(chunk.getSectionIndex(pos.getY()));
            Holder<Biome> result = DynamicBiomeUtils.judgeSection(section, (HolderLookup.RegistryLookup<Biome>)level.registryAccess().lookupOrThrow(Registries.BIOME));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> {
                if (result == null) {
                    return Component.literal((String)(String.valueOf(pos) + " pure"));
                }
                return Component.literal((String)(String.valueOf(pos) + " " + String.valueOf(result)));
            }, true);
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mana").then(Commands.literal((String)"receive").then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)Float.MAX_VALUE)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            boolean value = ManaStorage.of((LivingEntity)player).receiveMana(() -> FloatArgumentType.getFloat((CommandContext)context, (String)"value"));
            PlayerUtils.syncMana2Client(player);
            return value ? 1 : 0;
        })))).then(Commands.literal((String)"extract").then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)Float.MAX_VALUE)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            boolean value = ManaStorage.of((LivingEntity)player).extractMana(() -> FloatArgumentType.getFloat((CommandContext)context, (String)"value"), player);
            PlayerUtils.syncMana2Client(player);
            return value ? 1 : 0;
        })))).then(Commands.literal((String)"clearStars").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            ManaStorage.of((LivingEntity)player).clearStars();
            PlayerUtils.syncMana2Client(player);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reforge").then(Commands.literal((String)"random").executes(context -> {
            ServerPlayer player;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (ModCommands.cannotBeReforged(source, player = source.getPlayer())) {
                return 0;
            }
            ItemStack itemStack = player.getMainHandItem();
            PrefixComponent prefix = PrefixUtils.random(player.getRandom(), itemStack);
            if (ModCommands.unknownPrefixType(source, prefix)) {
                return 0;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.confluence.reforge.success", (Object[])new Object[]{ModRarity.withColor((ItemStack)itemStack, (MutableComponent)prefix.getName())}), false);
            return 1;
        }))).then(Commands.literal((String)"best").executes(context -> {
            ServerPlayer player;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (ModCommands.cannotBeReforged(source, player = source.getPlayer())) {
                return 0;
            }
            ItemStack itemStack = player.getMainHandItem();
            PrefixComponent prefix = PrefixUtils.best(player.getRandom(), itemStack);
            if (ModCommands.unknownPrefixType(source, prefix)) {
                return 0;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.confluence.reforge.success", (Object[])new Object[]{ModRarity.withColor((ItemStack)itemStack, (MutableComponent)prefix.getName())}), false);
            return 1;
        }))).then(Commands.literal((String)"clear").executes(context -> {
            ServerPlayer player;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (ModCommands.cannotBeReforged(source, player = source.getPlayer())) {
                return 0;
            }
            ItemStack itemStack = player.getMainHandItem();
            PrefixUtils.unknown(itemStack);
            LibUtils.resetDataComponent((ItemStack)itemStack, (DataComponentType)((DataComponentType)ConfluenceMagicLib.MOD_RARITY.get()));
            LibUtils.resetDataComponent((ItemStack)itemStack, ModDataComponentTypes.VALUE.get());
            source.sendSuccess(() -> Component.translatable((String)"commands.confluence.reforge.clear.success"), false);
            return 1;
        }))).then(ModCommands.setPrefixBuilder())));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> setPrefixBuilder() {
        LiteralArgumentBuilder builder = Commands.literal((String)"set");
        for (String group : ModPrefix.GROUPS.keySet()) {
            builder.then(Commands.literal((String)group).then(Commands.argument((String)"group", (ArgumentType)new PrefixArgument(group)).executes(context -> {
                ServerPlayer player;
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                if (ModCommands.cannotBeReforged(source, player = source.getPlayer())) {
                    return 0;
                }
                ItemStack itemStack = player.getMainHandItem();
                PrefixType type = PrefixUtils.getPrefixType(itemStack);
                if (!type.isGroupAvailable(group)) {
                    source.sendFailure((Component)Component.translatable((String)"commands.confluence.reforge.set.unavailable_group").withStyle(ChatFormatting.RED));
                    return 0;
                }
                PrefixComponent prefix = PrefixUtils.setAndUpdate(itemStack, type, (ModPrefix)context.getArgument("group", ModPrefix.class));
                if (ModCommands.unknownPrefixType(source, prefix)) {
                    return 0;
                }
                source.sendSuccess(() -> Component.translatable((String)"commands.confluence.reforge.success", (Object[])new Object[]{ModRarity.withColor((ItemStack)itemStack, (MutableComponent)prefix.getName())}), false);
                return 1;
            })));
        }
        return builder;
    }

    private static boolean cannotBeReforged(CommandSourceStack source, ServerPlayer player) {
        if (player == null) {
            return true;
        }
        if (!PrefixUtils.couldReforge(player.getMainHandItem())) {
            source.sendFailure((Component)Component.translatable((String)"commands.confluence.reforge.cannot_be_reforged").withStyle(ChatFormatting.RED));
            return true;
        }
        return false;
    }

    @Contract(value="_, null -> true")
    private static boolean unknownPrefixType(CommandSourceStack source, PrefixComponent prefix) {
        if (prefix == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.confluence.reforge.unknown_prefix_type").withStyle(ChatFormatting.RED));
            return true;
        }
        return false;
    }

    private static int fillPaints(CommandContext<CommandSourceStack> context, int[] list) throws CommandSyntaxException {
        BlockPos start = BlockPosArgument.getLoadedBlockPos(context, (String)"start");
        BlockPos end = BlockPosArgument.getLoadedBlockPos(context, (String)"end");
        HashMap<ChunkPos, Map> chunkPosMap = new HashMap<ChunkPos, Map>();
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)start, (BlockPos)end)) {
            chunkPosMap.computeIfAbsent(new ChunkPos(blockPos), pos -> new HashMap()).put(blockPos.immutable(), list);
        }
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        Map<ChunkPos, BrushData> dataMap = ChunkBrushData.of((Level)level).getDataMap();
        for (Map.Entry entry : chunkPosMap.entrySet()) {
            BrushData brushData = new BrushData((Map)entry.getValue());
            ChunkPos chunkPos = (ChunkPos)entry.getKey();
            dataMap.computeIfAbsent(chunkPos, pos -> new BrushData(new Hashtable<BlockPos, int[]>())).merge(brushData);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new BrushingColorPacketS2C(chunkPos, brushData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return 1;
    }
}

