/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.confluence.mod.Confluence;
import org.confluence.terraentity.init.TETags;

public final class ModDamageTypes {
    public static final ResourceKey<DamageType> FALLING_STAR = ModDamageTypes.register("falling_star");
    public static final ResourceKey<DamageType> ACID_VENOM = ModDamageTypes.register("acid_venom");
    public static final ResourceKey<DamageType> CURSED_INFERNO = ModDamageTypes.register("cursed_inferno");
    public static final ResourceKey<DamageType> BOULDER = ModDamageTypes.register("boulder");
    public static final ResourceKey<DamageType> DARKNESS = ModDamageTypes.register("darkness");
    public static final ResourceKey<DamageType> MAGICAL_PROJECTILE = ModDamageTypes.register("magical_projectile");
    public static final ResourceKey<DamageType> SWORD_PROJECTILE = ModDamageTypes.register("sword_projectile");

    private static ResourceKey<DamageType> register(String id) {
        return Confluence.asResourceKey(Registries.DAMAGE_TYPE, id);
    }

    public static DamageSource of(Level level, ResourceKey<DamageType> key) {
        return ModDamageTypes.of(level, key, null, null);
    }

    public static DamageSource of(Level level, ResourceKey<DamageType> key, Entity causing) {
        return ModDamageTypes.of(level, key, causing, causing);
    }

    public static DamageSource of(Level level, ResourceKey<DamageType> key, Entity direct, Entity causing) {
        return level.damageSources().source(key, direct, causing);
    }

    public static void bootstrap(BootstrapContext<DamageType> context) {
        TETags.DamageTypes.createDamageTypes(context);
        context.register(SWORD_PROJECTILE, (Object)new DamageType("sword_projectile_damage_type", 0.1f));
    }
}

