/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.datamaps.AdvancedDataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapValueMerger;
import net.neoforged.neoforge.registries.datamaps.DataMapValueRemover;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.component.ValueComponent;
import org.confluence.mod.common.data.map.BlockBreakSpawns;
import org.confluence.mod.common.data.map.BugNetEntityToItem;
import org.confluence.mod.common.data.map.DiggingPower;
import org.confluence.mod.common.data.map.ExtractinatorData;
import org.confluence.mod.common.data.map.GamePhase2AttributeModifiers;
import org.confluence.mod.common.data.map.ImmunityDataMap;
import org.confluence.mod.common.data.map.LivingInvulnerableEffects;
import org.confluence.mod.common.data.map.PresetBestiaryEntry;
import org.confluence.mod.common.data.map.TreasureBagDrop;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="confluence", bus=EventBusSubscriber.Bus.MOD)
public final class ModDataMaps {
    private static List<DataMapType<?, ?>> types = new LinkedList();
    private static final boolean jei = ModList.get().isLoaded("jei");
    public static final DataMapType<Item, ValueComponent> VALUE = ModDataMaps.register("value", Registries.ITEM, ValueComponent.CODEC, true);
    public static final DataMapType<Item, ExtractinatorData> EXTRACTINATOR = ModDataMaps.register("extractinator", Registries.ITEM, ExtractinatorData.CODEC, jei);
    public static final DataMapType<Item, ExtractinatorData> CHLOROPHYTE_EXTRACTINATOR = ModDataMaps.register("chlorophyte_extractinator", Registries.ITEM, ExtractinatorData.CODEC, jei);
    public static final DataMapType<Item, DiggingPower> DIGGING_POWER = ModDataMaps.register("digging_power", Registries.ITEM, DiggingPower.CODEC, true);
    public static final DataMapType<EntityType<?>, TreasureBagDrop> TREASURE_BAG = ModDataMaps.register("treasure_bag", Registries.ENTITY_TYPE, TreasureBagDrop.CODEC, false);
    public static final DataMapType<EntityType<?>, ImmunityDataMap> IMMUNITY = ModDataMaps.register("immunity", Registries.ENTITY_TYPE, ImmunityDataMap.CODEC, true);
    public static final DataMapType<EntityType<?>, BugNetEntityToItem> BUG_NET_ENTITY_TO_ITEM = ModDataMaps.register("bug_net_entity_to_item", Registries.ENTITY_TYPE, BugNetEntityToItem.CODEC, false);
    public static final DataMapType<EntityType<?>, LivingInvulnerableEffects> LIVING_INVULNERABLE_EFFECTS = ModDataMaps.register("living_invulnerable_effects", Registries.ENTITY_TYPE, LivingInvulnerableEffects.CODEC, true);
    public static final AdvancedDataMapType<EntityType<?>, GamePhase2AttributeModifiers, GamePhase2AttributeModifiers.Remover> GAME_PHASE_2_ATTRIBUTE_MODIFIERS = ModDataMaps.register("game_phase_2_attribute_modifiers", Registries.ENTITY_TYPE, GamePhase2AttributeModifiers.CODEC, GamePhase2AttributeModifiers.Remover.CODEC, new GamePhase2AttributeModifiers.Merger(), false);
    public static final DataMapType<EntityType<?>, PresetBestiaryEntry> BESTIARY_ENTRY = ModDataMaps.register("bestiary", Registries.ENTITY_TYPE, PresetBestiaryEntry.CODEC, false);
    public static final DataMapType<Block, BlockBreakSpawns> BLOCK_BREAK_SPAWNS = ModDataMaps.register("block_break_spawns", Registries.BLOCK, BlockBreakSpawns.CODEC, false);

    private static <R, T> DataMapType<R, T> register(String path, ResourceKey<Registry<R>> resourceKey, Codec<T> codec, boolean synced) {
        DataMapType.Builder builder = DataMapType.builder((ResourceLocation)Confluence.asResource(path), resourceKey, codec);
        if (synced) {
            builder.synced(codec, false);
        }
        DataMapType type = builder.build();
        types.add(type);
        return type;
    }

    private static <R, T, VR extends DataMapValueRemover<R, T>> AdvancedDataMapType<R, T, VR> register(String path, ResourceKey<Registry<R>> resourceKey, Codec<T> codec, Codec<VR> removerCodec, @Nullable DataMapValueMerger<R, T> merger, boolean synced) {
        AdvancedDataMapType.Builder builder = AdvancedDataMapType.builder((ResourceLocation)Confluence.asResource(path), resourceKey, codec).remover(removerCodec);
        if (merger != null) {
            builder.merger(merger);
        }
        if (synced) {
            builder.synced(codec, false);
        }
        AdvancedDataMapType type = builder.build();
        types.add((DataMapType<?, ?>)type);
        return type;
    }

    private static <R, T, VR extends DataMapValueRemover<R, T>> AdvancedDataMapType<R, T, VR> register(String path, ResourceKey<Registry<R>> resourceKey, Codec<T> codec, Codec<VR> removerCodec, boolean synced) {
        return ModDataMaps.register(path, resourceKey, codec, removerCodec, null, synced);
    }

    @SubscribeEvent
    public static void registerDataMapTypes(RegisterDataMapTypesEvent event) {
        for (DataMapType<?, ?> type : types) {
            event.register(type);
        }
        types = null;
    }

    @Nullable
    public static <T> T getEntityData(DataMapType<EntityType<?>, T> type, Entity entity) {
        return ModDataMaps.getEntityData(type, entity.getType());
    }

    @Nullable
    public static <T> T getEntityData(DataMapType<EntityType<?>, T> type, EntityType<?> entityType) {
        return (T)BuiltInRegistries.ENTITY_TYPE.getData(type, (ResourceKey)entityType.builtInRegistryHolder().unwrapKey().orElseThrow());
    }
}

