/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.WorldOptions;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.worldgen.secret_seed.BoulderWorld;
import org.confluence.mod.common.worldgen.secret_seed.Celebrationmk10;
import org.confluence.mod.common.worldgen.secret_seed.DontDigUp;
import org.confluence.mod.common.worldgen.secret_seed.DrunkWorld;
import org.confluence.mod.common.worldgen.secret_seed.ForTheWorthy;
import org.confluence.mod.common.worldgen.secret_seed.GetFixedBoi;
import org.confluence.mod.common.worldgen.secret_seed.NoTraps;
import org.confluence.mod.common.worldgen.secret_seed.NotTheBees;
import org.confluence.mod.common.worldgen.secret_seed.SecretSeed;
import org.confluence.mod.common.worldgen.secret_seed.TheConstant;
import org.confluence.mod.mixed.IWorldOptions;

public final class ModSecretSeeds {
    public static final List<SecretSeed> VALUES = new ArrayList<SecretSeed>();
    public static final Map<ResourceLocation, SecretSeed> BY_ID = new Hashtable<ResourceLocation, SecretSeed>();
    public static final Codec<SecretSeed> CODEC = ResourceLocation.CODEC.xmap(BY_ID::get, SecretSeed::getId);
    public static final int RESERVE = 8;
    public static final SecretSeed DRUNK_WORLD = ModSecretSeeds.register(Confluence.asResource("drunk_world"), DrunkWorld::new);
    public static final SecretSeed NOT_THE_BEES = ModSecretSeeds.register(Confluence.asResource("not_the_bees"), NotTheBees::new);
    public static final SecretSeed FOR_THE_WORTHY = ModSecretSeeds.register(Confluence.asResource("for_the_worthy"), ForTheWorthy::new);
    public static final SecretSeed CELEBRATIONMK10 = ModSecretSeeds.register(Confluence.asResource("celebrationmk10"), Celebrationmk10::new);
    public static final SecretSeed THE_CONSTANT = ModSecretSeeds.register(Confluence.asResource("the_constant"), TheConstant::new);
    public static final SecretSeed NO_TRAPS = ModSecretSeeds.register(Confluence.asResource("no_traps"), NoTraps::new);
    public static final SecretSeed DONT_DIG_UP = ModSecretSeeds.register(Confluence.asResource("dont_dig_up"), DontDigUp::new);
    public static final SecretSeed GET_FIXED_BOI = ModSecretSeeds.register(Confluence.asResource("get_fixed_boi"), GetFixedBoi::new);
    public static final SecretSeed BOULDER_WORLD = ModSecretSeeds.register(Confluence.asResource("boulder_world"), BoulderWorld::new);

    private static SecretSeed register(ResourceLocation id, BiFunction<Long, ResourceLocation, SecretSeed> function) {
        SecretSeed secretSeed = function.apply(1L << VALUES.size() + 8, id);
        VALUES.add(secretSeed);
        BY_ID.put(id, secretSeed);
        return secretSeed;
    }

    public static Pair<SecretSeed, WorldOptions> matchSeed(String seed, WorldOptions worldOptions) {
        String s = seed;
        String[] split = seed.split("\\|");
        OptionalLong l = OptionalLong.empty();
        if (split.length > 1) {
            s = split[0];
            try {
                l = OptionalLong.of(Long.parseLong(split[1].trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        s = s.trim().toLowerCase(Locale.ROOT);
        for (SecretSeed secretSeed : VALUES) {
            if (!secretSeed.match(s)) continue;
            IWorldOptions.of(worldOptions).confluence$withSecretFlag(secretSeed.getFlag());
            return new Pair((Object)secretSeed, (Object)worldOptions.withSeed(l.isPresent() ? l : OptionalLong.of(WorldOptions.randomSeed())));
        }
        return new Pair(null, (Object)worldOptions);
    }
}

