/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.SimpleTier;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.confluence.mod.common.init.item.MaterialItems;
import org.jetbrains.annotations.NotNull;

public final class ModTiers {
    public static final Tier CACTUS = new PoweredTier(35, ModTags.Blocks.NEEDS_2_LEVEL, 220, 4.0f, 1.0f, 4, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.CACTUS}));
    public static final Tier COPPER = new PoweredTier(35, ModTags.Blocks.NEEDS_2_LEVEL, 250, 4.0f, 1.0f, 5, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_INGOT}));
    public static final Tier TIN = new PoweredTier(35, ModTags.Blocks.NEEDS_2_LEVEL, 270, 4.0f, 1.0f, 6, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.TIN_INGOT}));
    public static final Tier IRON = new PoweredTier(40, ModTags.Blocks.NEEDS_2_LEVEL, 286, 5.0f, 2.0f, 7, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}));
    public static final Tier LEAD = new PoweredTier(43, ModTags.Blocks.NEEDS_2_LEVEL, 304, 6.0f, 2.0f, 8, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.LEAD_INGOT}));
    public static final Tier SILVER = new PoweredTier(45, ModTags.Blocks.NEEDS_2_LEVEL, 546, 6.0f, 2.0f, 9, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.SILVER_INGOT}));
    public static final Tier TUNGSTEN = new PoweredTier(50, ModTags.Blocks.NEEDS_3_LEVEL, 890, 7.0f, 2.0f, 10, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.TUNGSTEN_INGOT}));
    public static final Tier GOLD = new PoweredTier(55, ModTags.Blocks.NEEDS_4_LEVEL, 1600, 10.0f, 3.0f, 11, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}));
    public static final Tier CANDY_CANE = new PoweredTier(55, ModTags.Blocks.NEEDS_4_LEVEL, 10000, 7.0f, 2.0f, 11, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}));
    public static final Tier FOSSIL = new PoweredTier(55, ModTags.Blocks.NEEDS_4_LEVEL, 10000, 8.0f, 3.0f, 11, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.STURDY_FOSSIL}));
    public static final Tier BONE = new PoweredTier(55, ModTags.Blocks.NEEDS_4_LEVEL, 10000, 13.0f, 3.0f, 11, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE_BLOCK}));
    public static final Tier PLATINUM = new PoweredTier(59, ModTags.Blocks.NEEDS_4_LEVEL, 1661, 10.0f, 3.0f, 11, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.PLATINUM_INGOT}));
    public static final Tier REAVER_SHARK = new PoweredTier(59, ModTags.Blocks.NEEDS_4_LEVEL, 10000, 9.0f, 3.0f, 10, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.SHARK_FIN}));
    public static final Tier DEMONITE = new PoweredTier(65, ModTags.Blocks.NEEDS_5_LEVEL, 10000, 24.0f, 5.0f, 12, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.DEMONITE_INGOT}));
    public static final Tier CRIMTANE = new PoweredTier(70, ModTags.Blocks.NEEDS_5_LEVEL, 10000, 25.0f, 6.0f, 13, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.CRIMTANE_INGOT}));
    public static final Tier METEOR = new PoweredTier(80, ModTags.Blocks.NEEDS_6_LEVEL, 10000, 27.0f, 6.5f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.METEORITE_INGOT}));
    public static final Tier HELLSTONE = new PoweredTier(100, ModTags.Blocks.NEEDS_6_LEVEL, 10000, 30.0f, 7.0f, 15, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.HELLSTONE_INGOT}));
    public static final Tier COBALT = new PoweredTier(110, ModTags.Blocks.NEEDS_7_LEVEL, 10000, 31.0f, 8.0f, 15, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.COBALT_INGOT}));
    public static final Tier PALLADIUM = new PoweredTier(130, ModTags.Blocks.NEEDS_7_LEVEL, 10000, 32.0f, 12.0f, 15, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.PALLADIUM_INGOT}));
    public static final Tier MYTHRIL = new PoweredTier(150, ModTags.Blocks.NEEDS_8_LEVEL, 10000, 33.0f, 14.0f, 16, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.MYTHRIL_INGOT}));
    public static final Tier ORICHALCUM = new PoweredTier(165, ModTags.Blocks.NEEDS_8_LEVEL, 10000, 34.0f, 16.0f, 16, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.ORICHALCUM_INGOT}));
    public static final Tier ADAMANTITE = new PoweredTier(180, ModTags.Blocks.NEEDS_8_LEVEL, 10000, 35.0f, 22.0f, 17, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.ADAMANTITE_INGOT}));
    public static final Tier TITANIUM = new PoweredTier(190, ModTags.Blocks.NEEDS_8_LEVEL, 10000, 36.0f, 24.0f, 18, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.TITANIUM_INGOT}));
    public static final Tier SPECTRE = new PoweredTier(200, ModTags.Blocks.NEEDS_9_LEVEL, 10000, 48.0f, 26.0f, 21, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.SPECTRE_INGOT}));
    public static final Tier CHLOROPHYTE = new PoweredTier(200, ModTags.Blocks.NEEDS_9_LEVEL, 10000, 47.0f, 26.0f, 20, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.CHLOROPHYTE_INGOT}));
    public static final Tier HALLOWED = new PoweredTier(200, ModTags.Blocks.NEEDS_9_LEVEL, 10000, 46.0f, 25.0f, 19, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.HALLOWED_INGOT}));
    public static final Tier SHROOMITE = new PoweredTier(200, ModTags.Blocks.NEEDS_9_LEVEL, 10000, 60.0f, 28.0f, 22, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.SHROOMITE_INGOT}));
    public static final Tier LIHZAHRD = new PoweredTier(210, ModTags.Blocks.UNBREAKABLE, 10000, 80.0f, 32.0f, 24, () -> Ingredient.of((ItemLike[])new ItemLike[]{DecorativeBlocks.LIHZAHRD_BRICKS}));
    public static final Tier LUMINITE = new PoweredTier(225, ModTags.Blocks.UNBREAKABLE, 10000, 95.0f, 38.0f, 25, () -> Ingredient.of((ItemLike[])new ItemLike[]{MaterialItems.LUMINITE_INGOT}));
    public static final Tier UNBREAKABLE = new PoweredTier(190, ModTags.Blocks.NEEDS_2_LEVEL, 10000, 4.0f, 1.0f, 18, Ingredient::of);

    public static int getPowerForVanillaTiers(Tiers tiers) {
        return switch (tiers) {
            default -> throw new MatchException(null, null);
            case Tiers.WOOD -> 35;
            case Tiers.STONE -> 38;
            case Tiers.GOLD -> 39;
            case Tiers.IRON -> 40;
            case Tiers.DIAMOND -> 59;
            case Tiers.NETHERITE -> 90;
        };
    }

    public static boolean isCorrectToolForDrops(int power, ItemStack pickaxeItem, BlockState blockState) {
        if (!blockState.requiresCorrectToolForDrops()) {
            return true;
        }
        if (!pickaxeItem.isCorrectToolForDrops(blockState)) {
            return false;
        }
        if (power == -1 || power >= 201) {
            return true;
        }
        if (power >= 191) {
            return !blockState.is(ModTags.Blocks.NEEDS_9_LEVEL);
        }
        if (power >= 131) {
            return !blockState.is(ModTags.Blocks.NEEDS_8_LEVEL);
        }
        if (power >= 101) {
            return !blockState.is(ModTags.Blocks.NEEDS_7_LEVEL);
        }
        if (power >= 71) {
            return !blockState.is(ModTags.Blocks.NEEDS_6_LEVEL);
        }
        if (power >= 60) {
            return !blockState.is(ModTags.Blocks.NEEDS_5_LEVEL);
        }
        if (power >= 51) {
            return !blockState.is(ModTags.Blocks.NEEDS_4_LEVEL);
        }
        if (power >= 46) {
            return !blockState.is(ModTags.Blocks.NEEDS_3_LEVEL);
        }
        if (power >= 34) {
            return !blockState.is(ModTags.Blocks.NEEDS_2_LEVEL);
        }
        return !blockState.is(ModTags.Blocks.NEEDS_1_LEVEL);
    }

    public static class PoweredTier
    extends SimpleTier {
        private final int power;

        public PoweredTier(int power, TagKey<Block> incorrectBlocksForDrops, int uses, float speed, float attackDamageBonus, int enchantmentValue, Supplier<Ingredient> repairIngredient) {
            super(incorrectBlocksForDrops, uses, speed, attackDamageBonus, enchantmentValue, repairIngredient);
            this.power = power;
        }

        public int getPower() {
            return this.power;
        }

        @NotNull
        public String toString() {
            return "PoweredTier[incorrectBlocksForDrops=" + String.valueOf(this.getIncorrectBlocksForDrops()) + ", uses=" + this.getUses() + ", speed=" + this.getSpeed() + ", attackDamageBonus=" + this.getAttackDamageBonus() + ", enchantmentValue=" + this.getEnchantmentValue() + ", repairIngredient=" + String.valueOf(this.getRepairIngredient()) + ", power=" + this.power + "]";
        }
    }
}

