/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.IntegerRange;
import org.confluence.mod.common.block.functional.SafeBlock;
import org.confluence.mod.common.block.functional.crafting.CookingPotBlock;
import org.confluence.mod.common.block.functional.crafting.SkyMillBlock;
import org.confluence.mod.common.entity.npc.RandomItemListing;
import org.confluence.mod.common.entity.npc.SkyVillagerItemListing;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.ArmorItems;
import org.confluence.mod.common.init.item.ArrowItems;
import org.confluence.mod.common.init.item.AxeItems;
import org.confluence.mod.common.init.item.BowItems;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.mod.common.init.item.FishingPoleItems;
import org.confluence.mod.common.init.item.FoodItems;
import org.confluence.mod.common.init.item.HammerItems;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.init.item.PickaxeItems;
import org.confluence.mod.common.init.item.SwordItems;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.terra_curio.common.init.TCItems;

public final class ModVillagers {
    public static final DeferredRegister<PoiType> POIS = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"confluence");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"confluence");
    public static final DeferredRegister<VillagerType> TYPES = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_TYPE, (String)"confluence");
    public static final DeferredHolder<PoiType, PoiType> SKY_POI = POIS.register("sky", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((SkyMillBlock)((Object)((Object)FunctionalBlocks.SKY_MILL.get()))).getStateDefinition().getPossibleStates()), 1, 1));
    public static final DeferredHolder<PoiType, PoiType> COOKING_POI = POIS.register("cooking", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((CookingPotBlock)((Object)((Object)FunctionalBlocks.COOKING_POT.get()))).getStateDefinition().getPossibleStates()), 1, 1));
    public static final DeferredHolder<PoiType, PoiType> COIN_POI = POIS.register("coin", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((SafeBlock)((Object)((Object)FunctionalBlocks.SAFE.get()))).getStateDefinition().getPossibleStates()), 1, 1));
    public static final Supplier<VillagerProfession> SKY_MILLER = PROFESSIONS.register("sky_miller", () -> new VillagerProfession("sky", holder -> holder.is(SKY_POI.getId()), holder -> holder.is(SKY_POI.getId()), ImmutableSet.of((Object)((Item)MaterialItems.FALLING_STAR.get())), ImmutableSet.of(), SoundEvents.VILLAGER_WORK_WEAPONSMITH));
    public static final Supplier<VillagerProfession> CHEF = PROFESSIONS.register("chef", () -> new VillagerProfession("chef", holder -> holder.is(COOKING_POI.getId()), holder -> holder.is(COOKING_POI.getId()), ImmutableSet.of((Object)((Item)FoodItems.COOK_FISH.get())), ImmutableSet.of(), SoundEvents.CAMPFIRE_CRACKLE));
    public static final Supplier<VillagerProfession> BANKER = PROFESSIONS.register("banker", () -> new VillagerProfession("coin", holder -> holder.is(COIN_POI.getId()), holder -> holder.is(COIN_POI.getId()), ImmutableSet.of((Object)((Item)ModItems.GOLD_COIN.get()), (Object)((Item)ModItems.PLATINUM_COIN.get()), (Object)((Item)ModItems.EMERALD_COIN.get())), ImmutableSet.of(), (SoundEvent)ModSoundEvents.COINS.get()));
    public static final Supplier<VillagerType> SKY_TYPE = TYPES.register("sky", () -> new VillagerType("confluence_sky"));

    public static void villagerTrades(VillagerTradesEvent event) {
        VillagerProfession type = event.getType();
        Int2ObjectMap trades = event.getTrades();
        List tier1 = (List)trades.get(1);
        List tier2 = (List)trades.get(2);
        List tier3 = (List)trades.get(3);
        List tier4 = (List)trades.get(4);
        List tier5 = (List)trades.get(5);
        if (type == SKY_MILLER.get()) {
            tier1.add(new RandomItemListing((ItemLike)Items.EMERALD, (ItemLike)NatureBlocks.CLOUD_BLOCK.get(), IntegerRange.of((int)2, (int)3), 12, 5, 0.05f));
            tier1.add(new BasicItemListing(new ItemStack((ItemLike)MaterialItems.WEAVING_CLOUD_COTTON.get(), 5), new ItemStack((ItemLike)Items.EMERALD), 7, 5, 0.05f));
            tier2.add(new RandomItemListing((ItemLike)Items.DIRT, IntegerRange.of((int)61, (int)64), (ItemLike)Items.EMERALD, 2, 10, 0.05f));
            tier3.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.EMERALD_COIN.get()), new ItemStack((ItemLike)FoodItems.CLOUDWEAVER_SEED.get(), 3), 25, 10, 0.05f));
            tier3.add(new BasicItemListing(new ItemStack((ItemLike)Items.WATER_BUCKET), new ItemStack((ItemLike)NatureBlocks.RAIN_CLOUD_BLOCK.get()), 12, 20, 0.05f));
            tier3.add(new RandomItemListing((ItemLike)MaterialItems.FALLING_STAR.get(), IntegerRange.of((int)2, (int)3), (ItemLike)DecorativeBlocks.SUN_PLATE.get(), 10, 12, 20, 0.05f));
            tier4.add(new BasicItemListing(new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET), new ItemStack((ItemLike)Items.EMERALD), 12, 30, 0.05f));
            tier5.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.EMERALD_COIN.get(), 2), new ItemStack((ItemLike)FunctionalBlocks.SKY_MILL.get()), 12, 30, 0.05f));
        } else if (type == VillagerProfession.FARMER) {
            tier1.add(new SkyVillagerItemListing((ItemLike)NatureBlocks.FLOATING_WHEAT.get(), IntegerRange.of((int)4, (int)8), (ItemLike)Items.EMERALD, 3, 25, 0.05f));
            tier1.add(new SkyVillagerItemListing((ItemLike)MaterialItems.WEAVING_CLOUD_COTTON.get(), IntegerRange.of((int)4, (int)8), (ItemLike)Items.EMERALD, 3, 25, 0.05f));
            tier1.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 3, (ItemLike)FoodItems.CLOUD_BREAD.get(), 3, 25, 0.05f));
            tier2.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 2, (ItemLike)FoodItems.APRICOT.get(), 7, 25, 0.05f));
            tier2.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 2, (ItemLike)FoodItems.PLUM.get(), 7, 25, 0.05f));
            tier2.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 6, (ItemLike)FoodItems.HONEY_MOONCAKES.get(), 7, 25, 0.05f));
            tier3.add(new SkyVillagerItemListing((ItemLike)MaterialItems.FALLING_STAR.get(), IntegerRange.of((int)20, (int)22), (ItemLike)Items.EMERALD, 2, 7, 25, 0.05f));
            tier5.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, (ItemLike)FoodItems.CLOUDWEAVER_SEED.get(), 2, 7, 25, 0.05f));
            tier5.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, (ItemLike)FoodItems.STELLAR_BLOSSOM_SEED.get(), 2, 7, 25, 0.05f));
            tier5.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, (ItemLike)FoodItems.FLOATING_WHEAT_SEED.get(), 2, 7, 25, 0.05f));
        } else if (type == VillagerProfession.ARMORER) {
            tier1.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)6, (int)10), (ItemLike)ArmorItems.LEAD_HELMET.get(), 5, 25, 0.05f));
            tier1.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)10, (int)14), (ItemLike)ArmorItems.LEAD_CHESTPLATE.get(), 5, 25, 0.05f));
            tier1.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)8, (int)12), (ItemLike)ArmorItems.LEAD_LEGGINGS.get(), 5, 25, 0.05f));
            tier1.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)6, (int)10), (ItemLike)ArmorItems.LEAD_BOOTS.get(), 5, 25, 0.05f));
            tier2.add(new BasicItemListing(new ItemStack((ItemLike)MaterialItems.LEAD_INGOT.get(), 5), new ItemStack((ItemLike)Items.EMERALD), 10, 25, 0.05f));
            tier2.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)Items.COPPER_INGOT, 8), 10, 25, 0.05f));
            tier3.add(new SkyVillagerItemListing((ItemLike)MaterialItems.RUBY.get(), IntegerRange.of((int)1, (int)2), (ItemLike)Items.EMERALD, 2, 10, 25, 0.05f));
            tier3.add(new SkyVillagerItemListing((ItemLike)MaterialItems.AMBER.get(), IntegerRange.of((int)1, (int)2), (ItemLike)Items.EMERALD, 2, 10, 25, 0.05f));
            tier3.add(new SkyVillagerItemListing((ItemLike)MaterialItems.TOPAZ.get(), IntegerRange.of((int)1, (int)2), (ItemLike)Items.EMERALD, 2, 10, 25, 0.05f));
            tier3.add(new SkyVillagerItemListing((ItemLike)MaterialItems.JADE.get(), IntegerRange.of((int)1, (int)2), (ItemLike)Items.EMERALD, 2, 10, 25, 0.05f));
            tier3.add(new SkyVillagerItemListing((ItemLike)MaterialItems.AMETHYST.get(), IntegerRange.of((int)1, (int)2), (ItemLike)Items.EMERALD, 2, 10, 25, 0.05f));
            tier3.add(new SkyVillagerItemListing((ItemLike)MaterialItems.SAPPHIRE.get(), IntegerRange.of((int)1, (int)2), (ItemLike)Items.EMERALD, 2, 10, 25, 0.05f));
            tier4.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)7, (int)9), (ItemLike)MaterialItems.PLATINUM_INGOT.get(), 10, 25, 0.05f));
            tier5.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)19, (int)20), (ItemLike)ArmorItems.PLATINUM_HELMET.get(), 10, 25, 0.05f));
            tier5.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)22, (int)23), (ItemLike)ArmorItems.PLATINUM_CHESTPLATE.get(), 10, 25, 0.05f));
            tier5.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)20, (int)21), (ItemLike)ArmorItems.PLATINUM_LEGGINGS.get(), 10, 25, 0.05f));
            tier5.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)18, (int)19), (ItemLike)ArmorItems.PLATINUM_BOOTS.get(), 10, 25, 0.05f));
        } else if (type == VillagerProfession.BUTCHER) {
            tier1.add(new SkyVillagerItemListing((ItemLike)Items.BEEF, IntegerRange.of((int)6, (int)7), (ItemLike)Items.EMERALD, 5, 25, 0.05f));
            tier1.add(new SkyVillagerItemListing((ItemLike)Items.MUTTON, IntegerRange.of((int)6, (int)7), (ItemLike)Items.EMERALD, 5, 25, 0.05f));
            tier1.add(new SkyVillagerItemListing((ItemLike)Items.PORKCHOP, IntegerRange.of((int)6, (int)7), (ItemLike)Items.EMERALD, 5, 25, 0.05f));
            tier2.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 5, (ItemLike)FoodItems.BOWL_OF_SOUP.get(), 10, 25, 0.05f));
            tier3.add(new SkyVillagerItemListing((ItemLike)Items.RABBIT, 2, (ItemLike)Items.EMERALD, 10, 25, 0.05f));
            tier3.add(new SkyVillagerItemListing((ItemLike)Items.CHICKEN, 10, (ItemLike)Items.EMERALD, 2, 10, 25, 0.05f));
            tier5.add(new SkyVillagerItemListing((ItemLike)ModItems.EMERALD_COIN.get(), 120, (ItemLike)TCItems.SEXTANT.get(), 10, 25, 0.05f));
        } else if (type != VillagerProfession.CARTOGRAPHER && type != VillagerProfession.CLERIC) {
            if (type == VillagerProfession.FISHERMAN) {
                tier1.add(new SkyVillagerItemListing((ItemLike)FoodItems.DAMSEL_FISH.get(), IntegerRange.of((int)8, (int)10), (ItemLike)Items.EMERALD, 5, 25, 0.05f));
                tier1.add(new SkyVillagerItemListing((ItemLike)Items.PUFFERFISH, IntegerRange.of((int)8, (int)10), (ItemLike)Items.EMERALD, 5, 25, 0.05f));
                tier3.add(new SkyVillagerItemListing((ItemLike)FoodItems.GOLDEN_CARP.get(), (ItemLike)ModItems.EMERALD_COIN.get(), 20, 25, 0.05f));
                tier5.add(new SkyVillagerItemListing((ItemLike)ModItems.EMERALD_COIN.get(), 120, (ItemLike)FishingPoleItems.FIBERGLASS_FISHING_POLE.get(), 10, 25, 0.05f));
                tier5.add(new SkyVillagerItemListing((ItemLike)ModItems.EMERALD_COIN.get(), 120, (ItemLike)TCItems.FISHERMANS_POCKET_GUIDE.get(), 10, 25, 0.05f));
                tier5.add(new SkyVillagerItemListing((ItemLike)ModItems.EMERALD_COIN.get(), 120, (ItemLike)TCItems.WEATHER_RADIO.get(), 10, 25, 0.05f));
                tier5.add(new SkyVillagerItemListing((ItemLike)ModItems.EMERALD_COIN.get(), 120, (ItemLike)TCItems.SEXTANT.get(), 10, 25, 0.05f));
            } else if (type == VillagerProfession.FLETCHER) {
                tier2.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 2, (ItemLike)ArrowItems.FLAMING_ARROW.get(), 15, 10, 25, 0.05f));
                tier3.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 2, (ItemLike)BowItems.WOODEN_SHORT_BOW.get(), 10, 25, 0.05f));
                tier4.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 12, (ItemLike)BowItems.TUNGSTEN_SHORT_BOW.get(), 10, 25, 0.05f));
                tier5.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 3, (ItemLike)ArrowItems.STAR_ARROW.get(), 25, 10, 25, 0.05f));
            } else if (type == VillagerProfession.LEATHERWORKER) {
                tier3.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 4, (ItemLike)ArmorItems.SNOW_CAPS.get(), 10, 25, 0.05f));
                tier3.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 4, (ItemLike)ArmorItems.PINK_SNOW_CAPS.get(), 10, 25, 0.05f));
                tier3.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 4, (ItemLike)ArmorItems.SNOW_SUITS.get(), 10, 25, 0.05f));
                tier3.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 4, (ItemLike)ArmorItems.PINK_SNOW_SUITS.get(), 10, 25, 0.05f));
                tier4.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 5, (ItemLike)ArmorItems.INSULATED_PANTS.get(), 10, 25, 0.05f));
                tier4.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 5, (ItemLike)ArmorItems.PINK_INSULATED_PANTS.get(), 10, 25, 0.05f));
                tier4.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 5, (ItemLike)ArmorItems.INSULATED_SHOES.get(), 10, 25, 0.05f));
                tier4.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 5, (ItemLike)ArmorItems.PINK_INSULATED_SHOES.get(), 10, 25, 0.05f));
                tier5.add(new SkyVillagerItemListing((ItemLike)ModItems.EMERALD_COIN.get(), 60, (ItemLike)ToolItems.GOLDEN_BUG_NET.get(), 10, 25, 0.05f));
            } else if (type != VillagerProfession.LIBRARIAN) {
                if (type == VillagerProfession.MASON) {
                    tier1.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, (ItemLike)Blocks.MUD_BRICKS, 9, 5, 25, 0.05f));
                    tier1.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, (ItemLike)Blocks.BRICKS, 9, 5, 25, 0.05f));
                    tier2.add(new SkyVillagerItemListing((ItemLike)Blocks.STONE, 20, (ItemLike)Items.EMERALD, 2, 5, 25, 0.05f));
                    tier2.add(new SkyVillagerItemListing((ItemLike)Items.DIRT, IntegerRange.of((int)61, (int)64), (ItemLike)Items.EMERALD, 2, 10, 0.05f));
                    tier3.add(new SkyVillagerItemListing((ItemLike)NatureBlocks.DESERT_FOSSIL.get(), IntegerRange.of((int)7, (int)8), (ItemLike)Items.EMERALD, 5, 25, 0.05f));
                    tier3.add(new SkyVillagerItemListing((ItemLike)NatureBlocks.MARINE_GRAVEL.get(), IntegerRange.of((int)7, (int)8), (ItemLike)Items.EMERALD, 5, 25, 0.05f));
                    tier5.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)10, (int)12), (ItemLike)HammerItems.PLATINUM_HAMMER.get(), 15, 25, 0.05f));
                    tier5.add(new SkyVillagerItemListing((ItemLike)ModItems.EMERALD_COIN.get(), 5, (ItemLike)FunctionalBlocks.EXTRACTINATOR.get(), 25, 25, 0.05f));
                } else if (type == VillagerProfession.SHEPHERD) {
                    tier3.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 4, (ItemLike)ArmorItems.SNOW_CAPS.get(), 10, 25, 0.05f));
                    tier3.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 4, (ItemLike)ArmorItems.PINK_SNOW_CAPS.get(), 10, 25, 0.05f));
                    tier3.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 4, (ItemLike)ArmorItems.SNOW_SUITS.get(), 10, 25, 0.05f));
                    tier3.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 4, (ItemLike)ArmorItems.PINK_SNOW_SUITS.get(), 10, 25, 0.05f));
                    tier4.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 5, (ItemLike)ArmorItems.INSULATED_PANTS.get(), 10, 25, 0.05f));
                    tier4.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 5, (ItemLike)ArmorItems.PINK_INSULATED_PANTS.get(), 10, 25, 0.05f));
                    tier4.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 5, (ItemLike)ArmorItems.INSULATED_SHOES.get(), 10, 25, 0.05f));
                    tier4.add(new SkyVillagerItemListing((ItemLike)Items.EMERALD, 5, (ItemLike)ArmorItems.PINK_INSULATED_SHOES.get(), 10, 25, 0.05f));
                    tier5.add(new SkyVillagerItemListing((ItemLike)ModItems.EMERALD_COIN.get(), 4, (ItemLike)TCItems.HAND_WARMER.get(), 10, 25, 0.05f));
                } else if (type == VillagerProfession.WEAPONSMITH) {
                    tier1.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)SwordItems.LEAD_SHORT_SWORD.get()), 10, 25, 0.05f));
                    tier1.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 7), new ItemStack((ItemLike)SwordItems.LEAD_BROADSWORD.get()), 10, 25, 0.05f));
                    tier2.add(new BasicItemListing(new ItemStack((ItemLike)MaterialItems.LEAD_INGOT.get(), 5), new ItemStack((ItemLike)Items.EMERALD), 10, 25, 0.05f));
                    tier4.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)8, (int)9), (ItemLike)SwordItems.PLATINUM_SHORT_SWORD.get(), 10, 25, 0.05f));
                    tier4.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)9, (int)11), (ItemLike)SwordItems.PLATINUM_BROADSWORD.get(), 10, 25, 0.05f));
                    tier5.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)9, (int)11), (ItemLike)BowItems.PLATINUM_SHORT_BOW.get(), 10, 25, 0.05f));
                    tier5.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)11, (int)12), (ItemLike)BowItems.PLATINUM_BOW.get(), 10, 25, 0.05f));
                } else if (type == VillagerProfession.TOOLSMITH) {
                    tier2.add(new BasicItemListing(new ItemStack((ItemLike)MaterialItems.LEAD_INGOT.get(), 5), new ItemStack((ItemLike)Items.EMERALD), 10, 25, 0.05f));
                    tier4.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)9, (int)11), (ItemLike)AxeItems.PLATINUM_AXE.get(), 10, 25, 0.05f));
                    tier4.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)9, (int)11), (ItemLike)PickaxeItems.PLATINUM_PICKAXE.get(), 10, 25, 0.05f));
                    tier4.add(new RandomItemListing((ItemLike)Items.EMERALD, IntegerRange.of((int)7, (int)7), (ItemLike)HammerItems.PLATINUM_HAMMER.get(), 10, 25, 0.05f));
                } else if (type == BANKER.get()) {
                    tier1.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)Blocks.CHEST), 30, 15, 0.05f));
                    tier1.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.SILVER_COIN.get(), 20), new ItemStack((ItemLike)Items.EMERALD), 30, 15, 0.05f));
                    tier2.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.GOLD_COIN.get(), 3), new ItemStack((ItemLike)ModItems.EMERALD_COIN.get()), 30, 15, 0.05f));
                    tier3.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 20), new ItemStack((ItemLike)ModItems.EMERALD_COIN.get()), 30, 15, 0.05f));
                    tier4.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.SILVER_COIN.get(), 15), new ItemStack((ItemLike)Items.EMERALD), 45, 10, 0.05f));
                    tier5.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.GOLD_COIN.get(), 2), new ItemStack((ItemLike)ModItems.EMERALD_COIN.get()), 45, 10, 0.05f));
                } else if (type == CHEF.get()) {
                    tier1.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)Items.BREAD, 3), 12, 10, 0.05f));
                    tier1.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)Items.COOKED_BEEF, 2), 12, 10, 0.05f));
                    tier1.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)Items.COOKED_PORKCHOP, 2), 12, 10, 0.05f));
                    tier1.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)FoodItems.COOK_FISH.get()), 12, 10, 0.05f));
                    tier1.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)FoodItems.MARSHMALLOW.get()), 15, 10, 0.05f));
                    tier2.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.RABBIT_STEW), 12, 10, 0.05f));
                    tier2.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)FoodItems.LOBSTER_TAIL.get()), 12, 10, 0.05f));
                    tier2.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)FoodItems.BOWL_OF_SOUP.get()), 15, 10, 0.05f));
                    tier3.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)FoodItems.FRIES.get()), 12, 10, 0.05f));
                    tier3.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)FoodItems.PEACH_SANGRIA.get()), 12, 10, 0.05f));
                    tier3.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)FoodItems.BANANA_SPLIT.get()), 12, 10, 0.05f));
                    tier4.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)FoodItems.FRIED_EGG.get()), 12, 10, 0.05f));
                    tier4.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)FoodItems.LEMONADE.get()), 12, 10, 0.05f));
                    tier4.add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 14), new ItemStack((ItemLike)FoodItems.SHRIMP_PO_BOY.get()), 12, 10, 0.05f));
                    tier5.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.EMERALD_COIN.get(), 2), new ItemStack((ItemLike)ConsumableItems.DELUXE_PACKAGE.get()), 5, 10, 0.05f));
                    tier5.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.EMERALD_COIN.get(), 1), new ItemStack((ItemLike)FoodItems.PHO.get()), 10, 10, 0.05f));
                }
            }
        }
    }

    public static void setVillagerType(Villager villager) {
        if (villager.position().y >= 240.0) {
            villager.setVariant(SKY_TYPE.get());
        }
    }

    public static void register(IEventBus eventBus) {
        POIS.register(eventBus);
        PROFESSIONS.register(eventBus);
        TYPES.register(eventBus);
        NeoForge.EVENT_BUS.addListener(ModVillagers::villagerTrades);
    }
}

