/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.block;

import com.mojang.datafixers.DSL;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.common.block.EmptyPickupLiquidBlock;
import org.confluence.mod.common.block.common.AetheriumCauldronBlock;
import org.confluence.mod.common.block.common.BaseRopeBlock;
import org.confluence.mod.common.block.common.BaseSkullBlock;
import org.confluence.mod.common.block.common.HoneyCauldronBlock;
import org.confluence.mod.common.block.common.PooBlock;
import org.confluence.mod.common.block.common.TombstoneBlock;
import org.confluence.mod.common.block.natural.CoinPileBlock;
import org.confluence.mod.common.block.natural.CursedFlameBlock;
import org.confluence.mod.common.block.natural.food.BoulderBreadBlock;
import org.confluence.mod.common.block.natural.food.GreenDumplingBlock;
import org.confluence.mod.common.block.natural.herbs.BaseHerbBlock;
import org.confluence.mod.common.block.natural.herbs.Blinkroot;
import org.confluence.mod.common.block.natural.herbs.Daybloom;
import org.confluence.mod.common.block.natural.herbs.DeathWeed;
import org.confluence.mod.common.block.natural.herbs.Fireblossom;
import org.confluence.mod.common.block.natural.herbs.Moonglow;
import org.confluence.mod.common.block.natural.herbs.ShiveringThorn;
import org.confluence.mod.common.block.natural.herbs.Waterleaf;
import org.confluence.mod.common.init.ModFluids;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.common.init.block.CrateBlocks;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.block.OreBlocks;
import org.confluence.mod.common.init.block.PotBlocks;
import org.confluence.mod.common.init.block.StatueBlocks;
import org.confluence.mod.common.init.item.ModItems;

public final class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"confluence");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"confluence");
    public static final Object2BooleanMap<DeferredBlock<TombstoneBlock>> TOMBSTONES = new Object2BooleanOpenHashMap();
    public static final DeferredBlock<Block> ANDESITE_CASING = ModBlocks.registerWithItem("andesite_casing", () -> new Block(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<CoinPileBlock> COPPER_COIN = ModBlocks.registerWithoutItem("copper_coin", CoinPileBlock::new);
    public static final DeferredBlock<CoinPileBlock> SILVER_COIN = ModBlocks.registerWithoutItem("silver_coin", CoinPileBlock::new);
    public static final DeferredBlock<CoinPileBlock> GOLD_COIN = ModBlocks.registerWithoutItem("gold_coin", CoinPileBlock::new);
    public static final DeferredBlock<CoinPileBlock> PLATINUM_COIN = ModBlocks.registerWithoutItem("platinum_coin", CoinPileBlock::new);
    public static final DeferredBlock<CoinPileBlock> EMERALD_COIN = ModBlocks.registerWithoutItem("emerald_coin", CoinPileBlock::new);
    public static final DeferredBlock<LiquidBlock> HONEY = ModBlocks.registerWithoutItem("honey", () -> new LiquidBlock((FlowingFluid)ModFluids.HONEY.fluid().get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).mapColor(MapColor.COLOR_YELLOW)));
    public static final DeferredBlock<LiquidBlock> SHIMMER = ModBlocks.registerWithoutItem("shimmer", () -> new EmptyPickupLiquidBlock((FlowingFluid)ModFluids.SHIMMER.fluid().get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).mapColor(MapColor.COLOR_PINK).lightLevel(blockState -> 10)));
    public static final DeferredBlock<AetheriumCauldronBlock> AETHERIUM_CAULDRON = ModBlocks.registerWithItem("aetherium_cauldron", () -> new AetheriumCauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER_CAULDRON)));
    public static final DeferredBlock<HoneyCauldronBlock> HONEY_CAULDRON = ModBlocks.registerWithItem("honey_cauldron", () -> new HoneyCauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER_CAULDRON)));
    public static final DeferredBlock<BaseHerbBlock> WATERLEAF = ModBlocks.registerWithoutItem("waterleaf", Waterleaf::new);
    public static final DeferredBlock<Fireblossom> FIREBLOSSOM = ModBlocks.registerWithoutItem("fireblossom", Fireblossom::new);
    public static final DeferredBlock<Moonglow> MOONGLOW = ModBlocks.registerWithoutItem("moonglow", Moonglow::new);
    public static final DeferredBlock<BaseHerbBlock> BLINKROOT = ModBlocks.registerWithoutItem("blinkroot", Blinkroot::new);
    public static final DeferredBlock<BaseHerbBlock> SHIVERTHORN = ModBlocks.registerWithoutItem("shiverthorn", ShiveringThorn::new);
    public static final DeferredBlock<BaseHerbBlock> DAYBLOOM = ModBlocks.registerWithoutItem("daybloom", Daybloom::new);
    public static final DeferredBlock<DeathWeed> DEATHWEED = ModBlocks.registerWithoutItem("deathweed", DeathWeed::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BaseHerbBlock.BEntity>> HERBS_ENTITY = BLOCK_ENTITIES.register("herbs_entity", () -> BlockEntityType.Builder.of(BaseHerbBlock.BEntity::new, (Block[])new Block[]{(Block)WATERLEAF.get(), (Block)FIREBLOSSOM.get(), (Block)MOONGLOW.get(), (Block)BLINKROOT.get(), (Block)SHIVERTHORN.get(), (Block)DAYBLOOM.get(), (Block)DEATHWEED.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<PooBlock> POO = ModBlocks.registerWithItem("poo", () -> new PooBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<BaseRopeBlock> ROPE = ModBlocks.registerWithItem("rope", () -> new BaseRopeBlock(BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).sound(SoundType.WOOL).noCollission().instabreak()), BaseRopeBlock.BItem::new);
    public static final DeferredBlock<BaseRopeBlock> VINE_ROPE = ModBlocks.registerWithItem("vine_rope", () -> new BaseRopeBlock(BlockBehaviour.Properties.of().mapColor(DyeColor.GREEN).sound(SoundType.WOOL).noCollission().instabreak()), BaseRopeBlock.BItem::new);
    public static final DeferredBlock<BaseRopeBlock> SILK_ROPE = ModBlocks.registerWithItem("silk_rope", () -> new BaseRopeBlock(BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).sound(SoundType.WOOL).noCollission().instabreak()), BaseRopeBlock.BItem::new);
    public static final DeferredBlock<BaseRopeBlock> WEB_ROPE = ModBlocks.registerWithItem("web_rope", () -> new BaseRopeBlock(BlockBehaviour.Properties.of().mapColor(DyeColor.BLUE).sound(SoundType.WOOL).noCollission().instabreak()), BaseRopeBlock.BItem::new);
    public static final DeferredBlock<Block> FAILED_SKULL_BLOCK = ModBlocks.registerWithoutItem("failed_skull_block", () -> new BaseSkullBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.CREEPER).strength(1.0f).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> FAILED_SKULL_WALL_BLOCK = ModBlocks.registerWithoutItem("failed_skull_wall_block", () -> new BaseSkullBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.CREEPER).strength(1.0f).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<TombstoneBlock> TOMBSTONE = ModBlocks.registerTombstone("tombstone", false);
    public static final DeferredBlock<TombstoneBlock> GRAVE_MARKER = ModBlocks.registerTombstone("grave_marker", false);
    public static final DeferredBlock<TombstoneBlock> CROSS_GRAVE_MARKER = ModBlocks.registerTombstone("cross_grave_marker", false);
    public static final DeferredBlock<TombstoneBlock> HEADSTONE = ModBlocks.registerTombstone("headstone", false);
    public static final DeferredBlock<TombstoneBlock> GRAVESTONE = ModBlocks.registerTombstone("gravestone", false);
    public static final DeferredBlock<TombstoneBlock> OBELISK = ModBlocks.registerTombstone("obelisk", false);
    public static final DeferredBlock<TombstoneBlock> GOLDEN_TOMBSTONE = ModBlocks.registerTombstone("golden_tombstone", true);
    public static final DeferredBlock<TombstoneBlock> GOLDEN_GRAVE_MARKER = ModBlocks.registerTombstone("golden_grave_marker", true);
    public static final DeferredBlock<TombstoneBlock> GOLDEN_CROSS_GRAVE_MARKER = ModBlocks.registerTombstone("golden_cross_grave_marker", true);
    public static final DeferredBlock<TombstoneBlock> GOLDEN_HEADSTONE = ModBlocks.registerTombstone("golden_headstone", true);
    public static final DeferredBlock<TombstoneBlock> GOLDEN_GRAVESTONE = ModBlocks.registerTombstone("golden_gravestone", true);
    public static final Supplier<BlockEntityType<TombstoneBlock.BEntity>> TOMBSTONE_ENTITY = BLOCK_ENTITIES.register("tombstone_entity", () -> BlockEntityType.Builder.of(TombstoneBlock.BEntity::new, (Block[])((Block[])TOMBSTONES.keySet().stream().map(DeferredHolder::get).toArray(TombstoneBlock[]::new))).build(DSL.remainderType()));
    public static final DeferredBlock<GreenDumplingBlock> GREEN_DUMPLING_BLOCK = ModBlocks.registerWithoutItem("green_dumpling_block", GreenDumplingBlock::new);
    public static final DeferredBlock<BoulderBreadBlock> BOULDER_BREAD_BLOCK = ModBlocks.registerWithoutItem("boulder_bread_block", BoulderBreadBlock::new);
    public static final DeferredBlock<CursedFlameBlock> CURSED_FLAME_BLOCK = ModBlocks.registerWithoutItem("cursed_flame_block", () -> new CursedFlameBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).replaceable().noCollission().instabreak().lightLevel(l -> 7).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY)));

    private static DeferredBlock<TombstoneBlock> registerTombstone(String id, boolean isGolden) {
        DeferredBlock<TombstoneBlock> tombstone = ModBlocks.registerWithItem(id, TombstoneBlock::new);
        TOMBSTONES.put(tombstone, isGolden);
        return tombstone;
    }

    public static <B extends Block> DeferredBlock<B> registerWithItem(String id, Supplier<B> block) {
        return ModBlocks.registerWithItem(id, block, new Item.Properties());
    }

    public static <B extends Block> DeferredBlock<B> registerWithItem(String id, Supplier<B> block, Function<B, BlockItem> item) {
        DeferredBlock object = BLOCKS.register(id, block);
        ModItems.BLOCK_ITEMS.register(id, () -> (BlockItem)item.apply((Block)object.get()));
        return object;
    }

    public static <B extends Block> DeferredBlock<B> registerWithItem(String id, Supplier<B> block, Item.Properties properties) {
        DeferredBlock object = BLOCKS.register(id, block);
        ModItems.BLOCK_ITEMS.registerSimpleBlockItem((Holder)object, properties);
        return object;
    }

    public static <B extends Block> DeferredBlock<B> registerWithoutItem(String id, Supplier<B> block) {
        return BLOCKS.register(id, block);
    }

    public static float getObsidianBasedExplosionResistance(float delta) {
        return Blocks.OBSIDIAN.getExplosionResistance() + delta;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        BLOCK_ENTITIES.register(eventBus);
        ChestBlocks.BLOCKS.register(eventBus);
        CrateBlocks.BLOCKS.register(eventBus);
        DecorativeBlocks.BLOCKS.register(eventBus);
        FunctionalBlocks.BLOCKS.register(eventBus);
        NatureBlocks.BLOCKS.register(eventBus);
        OreBlocks.BLOCKS.register(eventBus);
        PotBlocks.BLOCKS.register(eventBus);
        StatueBlocks.BLOCKS.register(eventBus);
    }
}

