/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.block;

import com.mojang.datafixers.DSL;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.common.block.TransparentLeavesBlock;
import org.confluence.mod.common.block.natural.AetheriumBlock;
import org.confluence.mod.common.block.natural.AshPathBlock;
import org.confluence.mod.common.block.natural.BaseDroopingPlantsHeadBlock;
import org.confluence.mod.common.block.natural.BaseMossBlock;
import org.confluence.mod.common.block.natural.BasePlantBlock;
import org.confluence.mod.common.block.natural.BaseTallPlantBlock;
import org.confluence.mod.common.block.natural.BlinkingRoyalShimmerlilyBlock;
import org.confluence.mod.common.block.natural.BloodthirstCrystallizedBlock;
import org.confluence.mod.common.block.natural.BranchesBlock;
import org.confluence.mod.common.block.natural.CattailsBodyBlock;
import org.confluence.mod.common.block.natural.CattailsHeadBlock;
import org.confluence.mod.common.block.natural.CloudBlock;
import org.confluence.mod.common.block.natural.CloudWeaverBlock;
import org.confluence.mod.common.block.natural.CorrodedWormRootsBlock;
import org.confluence.mod.common.block.natural.CorruptedOvariesBlock;
import org.confluence.mod.common.block.natural.CrimsonHeartBlock;
import org.confluence.mod.common.block.natural.CrimsonVenusFlytrapBlock;
import org.confluence.mod.common.block.natural.DecomposeTheSourceExtractBlock;
import org.confluence.mod.common.block.natural.DesertPlantBlock;
import org.confluence.mod.common.block.natural.EvaporativeCloudBlock;
import org.confluence.mod.common.block.natural.FloatingWheatBlock;
import org.confluence.mod.common.block.natural.GlowingMushroomPileusBlock;
import org.confluence.mod.common.block.natural.IndusiumBlock;
import org.confluence.mod.common.block.natural.JungleHiveBlock;
import org.confluence.mod.common.block.natural.JungleSporeBlock;
import org.confluence.mod.common.block.natural.LarvaBlock;
import org.confluence.mod.common.block.natural.LifeCrystalBlock;
import org.confluence.mod.common.block.natural.LogBlockSet;
import org.confluence.mod.common.block.natural.LostPaperBlock;
import org.confluence.mod.common.block.natural.MoistSandBlock;
import org.confluence.mod.common.block.natural.MudPathBlock;
import org.confluence.mod.common.block.natural.MushroomBlock;
import org.confluence.mod.common.block.natural.NaturesGiftBlock;
import org.confluence.mod.common.block.natural.PalmLeaves;
import org.confluence.mod.common.block.natural.ParticleCloudBlock;
import org.confluence.mod.common.block.natural.SandLayerBlock;
import org.confluence.mod.common.block.natural.ShadowOrbBlock;
import org.confluence.mod.common.block.natural.ShimmerCrystalslBlock;
import org.confluence.mod.common.block.natural.ShimmerDroopingVinesBlock;
import org.confluence.mod.common.block.natural.ShimmerDroopingVinesPlantBlock;
import org.confluence.mod.common.block.natural.SmallCactusBlock;
import org.confluence.mod.common.block.natural.SpreadableMoistedSandBlock;
import org.confluence.mod.common.block.natural.StellarBlossomBlock;
import org.confluence.mod.common.block.natural.TaperedTwoPartBlock;
import org.confluence.mod.common.block.natural.ThinHoneyBlock;
import org.confluence.mod.common.block.natural.ThinIceBlock;
import org.confluence.mod.common.block.natural.ThornBlock;
import org.confluence.mod.common.block.natural.sapling.BaseSaplingBlock;
import org.confluence.mod.common.block.natural.sapling.StoneSaplingBlock;
import org.confluence.mod.common.block.natural.spreadable.AshGrassBlock;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.block.natural.spreadable.JungleGrassBlock;
import org.confluence.mod.common.block.natural.spreadable.MushroomGrassBlock;
import org.confluence.mod.common.block.natural.spreadable.PearlstoneBlock;
import org.confluence.mod.common.block.natural.spreadable.SpreadingBlock;
import org.confluence.mod.common.block.natural.spreadable.SpreadingGrassBlock;
import org.confluence.mod.common.block.natural.spreadable.SpreadingIceBlock;
import org.confluence.mod.common.block.natural.spreadable.SpreadingSandBlock;
import org.confluence.mod.common.block.natural.spreadable.SpreadingThornBlock;
import org.confluence.mod.common.init.ModFeatures;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.ModItems;

@ParametersAreNonnullByDefault
public class NatureBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"confluence");
    public static final DeferredBlock<Block> RUBY_SAPLING = NatureBlocks.registerWithItem("ruby_sapling", () -> new StoneSaplingBlock(ModFeatures.TreeGrowers.RUBY_GROWER));
    public static final DeferredBlock<Block> AMBER_SAPLING = NatureBlocks.registerWithItem("amber_sapling", () -> new StoneSaplingBlock(ModFeatures.TreeGrowers.AMBER_GROWER));
    public static final DeferredBlock<Block> TOPAZ_SAPLING = NatureBlocks.registerWithItem("topaz_sapling", () -> new StoneSaplingBlock(ModFeatures.TreeGrowers.TOPAZ_GROWER));
    public static final DeferredBlock<Block> JADE_SAPLING = NatureBlocks.registerWithItem("jade_sapling", () -> new StoneSaplingBlock(ModFeatures.TreeGrowers.JADE_GROWER));
    public static final DeferredBlock<Block> DIAMOND_SAPLING = NatureBlocks.registerWithItem("diamond_sapling", () -> new StoneSaplingBlock(ModFeatures.TreeGrowers.DIAMOND_GROWER));
    public static final DeferredBlock<Block> SAPPHIRE_SAPLING = NatureBlocks.registerWithItem("sapphire_sapling", () -> new StoneSaplingBlock(ModFeatures.TreeGrowers.SAPPHIRE_GROWER));
    public static final DeferredBlock<Block> AMETHYST_SAPLING = NatureBlocks.registerWithItem("amethyst_sapling", () -> new StoneSaplingBlock(ModFeatures.TreeGrowers.AMETHYST_GROWER));
    public static final DeferredBlock<ThinHoneyBlock> THIN_HONEY_BLOCK = NatureBlocks.registerWithItem("thin_honey_block", () -> new ThinHoneyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HONEY_BLOCK).mapColor(MapColor.COLOR_ORANGE).isViewBlocking((state, level, pos) -> false)));
    public static final DeferredBlock<Block> LOOSE_HONEY_BLOCK = NatureBlocks.registerWithItem("loose_honey_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HONEY_BLOCK).mapColor(MapColor.COLOR_ORANGE)));
    public static final DeferredBlock<AetheriumBlock> AETHERIUM_BLOCK = NatureBlocks.registerWithItem("aetherium_block", () -> new AetheriumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(MapColor.COLOR_PINK).lightLevel(blockState -> 10)));
    public static final DeferredBlock<Block> DARK_AETHERIUM_BLOCK = NatureBlocks.registerWithItem("dark_aetherium_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(MapColor.COLOR_GRAY)));
    public static final DeferredBlock<CattailsBodyBlock> CATTAILS_BODY = NatureBlocks.registerWithoutItem("cattails_body", () -> new CattailsBodyBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<CattailsBodyBlock> JUNGLE_CATTAILS_BODY = NatureBlocks.registerWithoutItem("jungle_cattails_body", () -> new CattailsBodyBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<CattailsBodyBlock> GLOWING_MUSHROOM_CATTAILS_BODY = NatureBlocks.registerWithoutItem("glowing_mushroom_cattails_body", () -> new CattailsBodyBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<CattailsBodyBlock> HALLOW_CATTAILS_BODY = NatureBlocks.registerWithoutItem("hallow_cattails_body", () -> new CattailsBodyBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<CattailsBodyBlock> EBONY_CATTAILS_BODY = NatureBlocks.registerWithoutItem("ebony_cattails_body", () -> new CattailsBodyBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<CattailsBodyBlock> CRIMSON_CATTAILS_BODY = NatureBlocks.registerWithoutItem("crimson_cattails_body", () -> new CattailsBodyBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<CattailsHeadBlock> CATTAILS_HEAD = NatureBlocks.registerWithoutItem("cattails_head", () -> new CattailsHeadBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY).sound(SoundType.GRASS)));
    public static final DeferredBlock<CattailsHeadBlock> JUNGLE_CATTAILS_HEAD = NatureBlocks.registerWithoutItem("jungle_cattails_head", () -> new CattailsHeadBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY).sound(SoundType.GRASS)));
    public static final DeferredBlock<CattailsHeadBlock> GLOWING_MUSHROOM_CATTAILS_HEAD = NatureBlocks.registerWithoutItem("glowing_mushroom_cattails_head", () -> new CattailsHeadBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY).sound(SoundType.GRASS)));
    public static final DeferredBlock<CattailsHeadBlock> HALLOW_CATTAILS_HEAD = NatureBlocks.registerWithoutItem("hallow_cattails_head", () -> new CattailsHeadBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY).sound(SoundType.GRASS)));
    public static final DeferredBlock<CattailsHeadBlock> EBONY_CATTAILS_HEAD = NatureBlocks.registerWithoutItem("ebony_cattails_head", () -> new CattailsHeadBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY).sound(SoundType.GRASS)));
    public static final DeferredBlock<CattailsHeadBlock> CRIMSON_CATTAILS_HEAD = NatureBlocks.registerWithoutItem("crimson_cattails_head", () -> new CattailsHeadBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noCollission().randomTicks().pushReaction(PushReaction.DESTROY).sound(SoundType.GRASS)));
    public static final DeferredBlock<ThinIceBlock> THIN_ICE_BLOCK = NatureBlocks.registerWithItem("thin_ice_block", ThinIceBlock::new);
    public static final DeferredBlock<Block> HARDENED_SAND_BLOCK = NatureBlocks.registerWithItem("hardened_sand_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE).mapColor(MapColor.SAND)));
    public static final DeferredBlock<Block> MOISTENED_SAND_BLOCK = NatureBlocks.registerWithItem("moistened_sand_block", () -> new MoistSandBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD).mapColor(MapColor.SAND), Blocks.SAND));
    public static final DeferredBlock<Block> HARDENED_RED_SAND_BLOCK = NatureBlocks.registerWithItem("hardened_red_sand_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE).mapColor(MapColor.TERRACOTTA_RED)));
    public static final DeferredBlock<Block> MOISTENED_RED_SAND_BLOCK = NatureBlocks.registerWithItem("moistened_red_sand_block", () -> new MoistSandBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD).mapColor(MapColor.TERRACOTTA_RED), Blocks.RED_SAND));
    public static final DeferredBlock<Block> DIATOMACEOUS = NatureBlocks.registerWithItem("diatomaceous", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.TERRACOTTA_PINK)));
    public static final DeferredBlock<SandLayerBlock> SAND_LAYER_BLOCK = NatureBlocks.registerWithItem("sand_layer_block", SandLayerBlock::new);
    public static final DeferredBlock<SandLayerBlock> RED_SAND_LAYER_BLOCK = NatureBlocks.registerWithItem("red_sand_layer_block", SandLayerBlock::new);
    public static final DeferredBlock<Block> DESERT_FOSSIL = NatureBlocks.registerWithItem("desert_fossil", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE).mapColor(MapColor.TERRACOTTA_RED)));
    public static final DeferredBlock<Block> SLUSH = NatureBlocks.registerWithItem("slush", () -> new ColoredFallingBlock(new ColorRGBA(1531531531), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final DeferredBlock<Block> SILT_BLOCK = NatureBlocks.registerWithItem("silt_block", () -> new ColoredFallingBlock(new ColorRGBA(1531531531), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.TERRACOTTA_GRAY)));
    public static final DeferredBlock<Block> MARINE_GRAVEL = NatureBlocks.registerWithItem("marine_gravel", () -> new ColoredFallingBlock(new ColorRGBA(1531531531), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.TERRACOTTA_CYAN)));
    public static final DeferredBlock<RotatedPillarBlock> STONY_LOG = NatureBlocks.registerWithItem("stony_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.COLOR_LIGHT_GRAY)));
    public static final DeferredBlock<LifeCrystalBlock> LIFE_CRYSTAL_BLOCK = NatureBlocks.registerWithItem("life_crystal_block", () -> new LifeCrystalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).mapColor(MapColor.COLOR_RED).lightLevel(state -> 7)), LifeCrystalBlock.BItem::new);
    public static final Supplier<BlockEntityType<LifeCrystalBlock.BEntity>> LIFE_CRYSTAL_BLOCK_ENTITY = ModBlocks.BLOCK_ENTITIES.register("life_crystal_block_entity", () -> BlockEntityType.Builder.of(LifeCrystalBlock.BEntity::new, (Block[])new Block[]{(Block)LIFE_CRYSTAL_BLOCK.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<Block> GRANITE = NatureBlocks.registerWithItem("granite", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE)));
    public static final DeferredBlock<Block> MARBLE = NatureBlocks.registerWithItem("marble", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE)));
    public static final DeferredBlock<Block> LIFE_MUSHROOM = NatureBlocks.registerWithoutItem("life_mushroom", () -> new MushroomBlock(ISpreadable.Type.PURE, Blocks.GRASS_BLOCK));
    public static final DeferredBlock<Block> CORRUPT_GRASS_BLOCK = NatureBlocks.registerWithItem("corrupt_grass_block", () -> new SpreadingGrassBlock(ISpreadable.Type.CORRUPT, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).mapColor(MapColor.COLOR_PURPLE)));
    public static final LogBlockSet EBONY_LOG_BLOCKS = LogBlockSet.builder("ebony", true, LogBlockSet.WoodSetType.EBONY).sapling(properties -> new BaseSaplingBlock(ModFeatures.TreeGrowers.EBONY_GROWER, (BlockBehaviour.Properties)properties, null, new Supplier[]{CORRUPT_GRASS_BLOCK})).build();
    public static final DeferredBlock<Block> EBONSTONE = NatureBlocks.registerWithItem("ebonstone", () -> new SpreadingBlock(ISpreadable.Type.CORRUPT, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.TERRACOTTA_PURPLE)));
    public static final DeferredBlock<Block> COBBLED_EBONSTONE = NatureBlocks.registerWithItem("cobbled_ebonstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).mapColor(MapColor.TERRACOTTA_PURPLE)));
    public static final DeferredBlock<Block> EBONSANDSTONE = NatureBlocks.registerWithItem("ebonsandstone", () -> new SpreadingBlock(ISpreadable.Type.CORRUPT, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE).mapColor(MapColor.TERRACOTTA_PURPLE)));
    public static final DeferredBlock<Block> HARDENED_EBONSAND_BLOCK = NatureBlocks.registerWithItem("hardened_ebonsand_block", () -> new SpreadingBlock(ISpreadable.Type.CORRUPT, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.TERRACOTTA_PURPLE)));
    public static final DeferredBlock<Block> EBONSAND = NatureBlocks.registerWithItem("ebonsand", () -> new SpreadingSandBlock(ISpreadable.Type.CORRUPT, 3615563, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.COLOR_BLACK)));
    public static final DeferredBlock<Block> MOISTENED_EBONSAND_BLOCK = NatureBlocks.registerWithItem("moistened_ebonsand_block", () -> new SpreadableMoistedSandBlock(ISpreadable.Type.CORRUPT, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD).mapColor(MapColor.COLOR_BLACK), (Supplier<Block>)EBONSAND));
    public static final DeferredBlock<Block> PURPLE_ICE = NatureBlocks.registerWithItem("purple_ice", () -> new SpreadingIceBlock(ISpreadable.Type.CORRUPT, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ICE).mapColor(MapColor.COLOR_PURPLE)));
    public static final DeferredBlock<Block> PURPLE_PACKED_ICE = NatureBlocks.registerWithItem("purple_packed_ice", () -> new SpreadingIceBlock(ISpreadable.Type.CORRUPT, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE).mapColor(MapColor.COLOR_PURPLE)));
    public static final DeferredBlock<SandLayerBlock> EBONSAND_LAYER_BLOCK = NatureBlocks.registerWithItem("ebonsand_layer_block", SandLayerBlock::new);
    public static final DeferredBlock<Block> VILE_MUSHROOM = NatureBlocks.registerWithoutItem("vile_mushroom", () -> new MushroomBlock(ISpreadable.Type.CORRUPT, (Block)CORRUPT_GRASS_BLOCK.get()));
    public static final DeferredBlock<ThornBlock> CORRUPTION_THORN = NatureBlocks.registerWithItem("corruption_thorn", () -> new SpreadingThornBlock(2.0f, (Block)CORRUPT_GRASS_BLOCK.get(), ISpreadable.Type.CORRUPT));
    public static final DeferredBlock<Block> CORRUPT_GRASS = NatureBlocks.registerWithItem("corrupt_grass", () -> new BasePlantBlock((Block)CORRUPT_GRASS_BLOCK.get()));
    public static final DeferredBlock<Block> CORRUPT_JUNGLE_GRASS_BLOCK = NatureBlocks.registerWithItem("corrupt_jungle_grass_block", () -> new JungleGrassBlock(ISpreadable.Type.CORRUPT, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD).mapColor(MapColor.COLOR_PURPLE)));
    public static final DeferredBlock<ShadowOrbBlock> SHADOW_ORB = NatureBlocks.registerWithoutItem("shadow_orb", ShadowOrbBlock::new);
    public static final DeferredBlock<Block> CORRUPT_CACTUS = NatureBlocks.registerWithItem("corrupt_cactus", () -> new CactusBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CACTUS).mapColor(MapColor.COLOR_CYAN)){

        protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate = level.getBlockState(pos.relative(direction));
                if (!blockstate.isSolid() && !level.getFluidState(pos.relative(direction)).is(FluidTags.LAVA)) continue;
                return false;
            }
            BlockState blockstate1 = level.getBlockState(pos.below());
            TriState soilDecision = blockstate1.canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
            if (!soilDecision.isDefault()) {
                return soilDecision.isTrue();
            }
            return (blockstate1.is(ModTags.Blocks.CACTUS) || blockstate1.is(BlockTags.SAND)) && !level.getBlockState(pos.above()).liquid();
        }
    });
    public static final DeferredBlock<Block> HALLOW_GRASS_BLOCK = NatureBlocks.registerWithItem("hallow_grass_block", () -> new SpreadingGrassBlock(ISpreadable.Type.HALLOW, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).mapColor(MapColor.COLOR_CYAN)));
    public static final DeferredBlock<Block> HALLOW_GRASS = NatureBlocks.registerWithItem("hallow_grass", () -> new BasePlantBlock((Block)HALLOW_GRASS_BLOCK.get()));
    public static final LogBlockSet PEARL_LOG_BLOCKS = LogBlockSet.builder("pearl", true, LogBlockSet.WoodSetType.PEARL).sapling(properties -> new BaseSaplingBlock(ModFeatures.TreeGrowers.PEARL_GROWER, (BlockBehaviour.Properties)properties, null, new Supplier[]{HALLOW_GRASS_BLOCK})).build();
    public static final DeferredBlock<Block> PEARLSTONE = NatureBlocks.registerWithItem("pearlstone", () -> new PearlstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.TERRACOTTA_MAGENTA)));
    public static final DeferredBlock<Block> COBBLED_PEARLSTONE = NatureBlocks.registerWithItem("cobbled_pearlstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).mapColor(MapColor.TERRACOTTA_MAGENTA)));
    public static final DeferredBlock<Block> HARDENED_PEARLSAND_BLOCK = NatureBlocks.registerWithItem("hardened_pearlsand_block", () -> new PearlstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.TERRACOTTA_PINK)));
    public static final DeferredBlock<Block> PEARLSANDSTONE = NatureBlocks.registerWithItem("pearlsandstone", () -> new PearlstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE).mapColor(MapColor.TERRACOTTA_PINK)));
    public static final DeferredBlock<Block> PEARLSAND = NatureBlocks.registerWithItem("pearlsand", () -> new SpreadingSandBlock(ISpreadable.Type.HALLOW, 15586806, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.TERRACOTTA_PINK)){

        @Override
        public void spread(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
            super.spread(blockState, serverLevel, blockPos, randomSource);
            PearlstoneBlock.generateCrystal(serverLevel, blockPos, randomSource);
        }
    });
    public static final DeferredBlock<Block> MOISTENED_PEARLSAND_BLOCK = NatureBlocks.registerWithItem("moistened_pearlsand_block", () -> new SpreadableMoistedSandBlock(ISpreadable.Type.HALLOW, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD).mapColor(MapColor.TERRACOTTA_PINK), (Supplier)PEARLSAND){

        @Override
        public void spread(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
            super.spread(blockState, serverLevel, blockPos, randomSource);
            PearlstoneBlock.generateCrystal(serverLevel, blockPos, randomSource);
        }
    });
    public static final DeferredBlock<SandLayerBlock> PEARLSAND_LAYER_BLOCK = NatureBlocks.registerWithItem("pearlsand_layer_block", SandLayerBlock::new);
    public static final DeferredBlock<Block> PINK_ICE = NatureBlocks.registerWithItem("pink_ice", () -> new SpreadingIceBlock(ISpreadable.Type.HALLOW, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ICE).mapColor(MapColor.COLOR_PINK)));
    public static final DeferredBlock<Block> PINK_PACKED_ICE = NatureBlocks.registerWithItem("pink_packed_ice", () -> new SpreadingIceBlock(ISpreadable.Type.HALLOW, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE).mapColor(MapColor.COLOR_PINK).randomTicks()){

        @Override
        public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
            if (serverLevel.isAreaLoaded(blockPos, 3)) {
                PearlstoneBlock.generateCrystal(serverLevel, blockPos, randomSource);
            }
        }
    });
    public static final DeferredBlock<AmethystClusterBlock> CRYSTAL_SHARDS = NatureBlocks.registerWithoutItem("crystal_shards", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).mapColor(MapColor.COLOR_PINK).lightLevel(state -> 7)));
    public static final DeferredBlock<AmethystClusterBlock> GELATIN_CRYSTAL = NatureBlocks.registerWithoutItem("gelatin_crystal", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).mapColor(MapColor.COLOR_PINK).lightLevel(state -> 9)));
    public static final DeferredBlock<Block> HALLOW_CACTUS = NatureBlocks.registerWithItem("hallow_cactus", () -> new CactusBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CACTUS).mapColor(MapColor.COLOR_CYAN)){

        protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate = level.getBlockState(pos.relative(direction));
                if (!blockstate.isSolid() && !level.getFluidState(pos.relative(direction)).is(FluidTags.LAVA)) continue;
                return false;
            }
            BlockState blockstate1 = level.getBlockState(pos.below());
            TriState soilDecision = blockstate1.canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
            if (!soilDecision.isDefault()) {
                return soilDecision.isTrue();
            }
            return (blockstate1.is(ModTags.Blocks.CACTUS) || blockstate1.is(BlockTags.SAND)) && !level.getBlockState(pos.above()).liquid();
        }
    });
    public static final DeferredBlock<Block> CRIMSON_GRASS_BLOCK = NatureBlocks.registerWithItem("crimson_grass_block", () -> new SpreadingGrassBlock(ISpreadable.Type.CRIMSON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).mapColor(MapColor.COLOR_RED)));
    public static final LogBlockSet SHADOW_LOG_BLOCKS = LogBlockSet.builder("shadow", true, LogBlockSet.WoodSetType.SHADOW).sapling(properties -> new BaseSaplingBlock(ModFeatures.TreeGrowers.SHADOW_GROWER, (BlockBehaviour.Properties)properties, null, new Supplier[]{CRIMSON_GRASS_BLOCK})).build();
    public static final DeferredBlock<Block> CRIMSTONE = NatureBlocks.registerWithItem("crimstone", () -> new SpreadingBlock(ISpreadable.Type.CRIMSON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.COLOR_RED)));
    public static final DeferredBlock<Block> COBBLED_CRIMSTONE = NatureBlocks.registerWithItem("cobbled_crimstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).mapColor(MapColor.COLOR_RED)));
    public static final DeferredBlock<Block> HARDENED_CRIMSAND_BLOCK = NatureBlocks.registerWithItem("hardened_crimsand_block", () -> new SpreadingBlock(ISpreadable.Type.CRIMSON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.TERRACOTTA_RED)));
    public static final DeferredBlock<Block> CRIMSANDSTONE = NatureBlocks.registerWithItem("crimsandstone", () -> new SpreadingBlock(ISpreadable.Type.CRIMSON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE).mapColor(MapColor.TERRACOTTA_RED)));
    public static final DeferredBlock<Block> CRIMSAND = NatureBlocks.registerWithItem("crimsand", () -> new SpreadingSandBlock(ISpreadable.Type.CRIMSON, 5444576, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.COLOR_RED)));
    public static final DeferredBlock<Block> MOISTENED_CRIMSAND_BLOCK = NatureBlocks.registerWithItem("moistened_crimsand_block", () -> new SpreadableMoistedSandBlock(ISpreadable.Type.CRIMSON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD).mapColor(MapColor.COLOR_RED), (Supplier<Block>)CRIMSAND));
    public static final DeferredBlock<Block> VICIOUS_MUSHROOM = NatureBlocks.registerWithoutItem("vicious_mushroom", () -> new MushroomBlock(ISpreadable.Type.CRIMSON, (Block)CRIMSON_GRASS_BLOCK.get()));
    public static final DeferredBlock<ThornBlock> CRIMSON_THORN = NatureBlocks.registerWithItem("crimson_thorn", () -> new SpreadingThornBlock(2.0f, (Block)CRIMSON_GRASS_BLOCK.get(), ISpreadable.Type.CRIMSON));
    public static final DeferredBlock<Block> CRIMSON_GRASS = NatureBlocks.registerWithItem("crimson_grass", () -> new BasePlantBlock((Block)CRIMSON_GRASS_BLOCK.get()));
    public static final DeferredBlock<SandLayerBlock> CRIMSAND_LAYER_BLOCK = NatureBlocks.registerWithItem("crimsand_layer_block", SandLayerBlock::new);
    public static final DeferredBlock<Block> CRIMSON_JUNGLE_GRASS_BLOCK = NatureBlocks.registerWithItem("crimson_jungle_grass_block", () -> new JungleGrassBlock(ISpreadable.Type.CRIMSON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> RED_ICE = NatureBlocks.registerWithItem("red_ice", () -> new SpreadingIceBlock(ISpreadable.Type.CRIMSON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ICE).mapColor(MapColor.COLOR_RED)));
    public static final DeferredBlock<Block> RED_PACKED_ICE = NatureBlocks.registerWithItem("red_packed_ice", () -> new SpreadingIceBlock(ISpreadable.Type.CRIMSON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE).mapColor(MapColor.COLOR_RED)));
    public static final DeferredBlock<CrimsonHeartBlock> CRIMSON_HEART = NatureBlocks.registerWithoutItem("crimson_heart", CrimsonHeartBlock::new);
    public static final DeferredBlock<Block> CRIMSON_CACTUS = NatureBlocks.registerWithItem("crimson_cactus", () -> new CactusBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CACTUS).mapColor(MapColor.COLOR_RED)){

        protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate = level.getBlockState(pos.relative(direction));
                if (!blockstate.isSolid() && !level.getFluidState(pos.relative(direction)).is(FluidTags.LAVA)) continue;
                return false;
            }
            BlockState blockstate1 = level.getBlockState(pos.below());
            TriState soilDecision = blockstate1.canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
            if (!soilDecision.isDefault()) {
                return soilDecision.isTrue();
            }
            return (blockstate1.is(ModTags.Blocks.CACTUS) || blockstate1.is(BlockTags.SAND)) && !level.getBlockState(pos.above()).liquid();
        }
    });
    public static final DeferredBlock<MushroomGrassBlock> MUSHROOM_GRASS_BLOCK = NatureBlocks.registerWithItem("mushroom_grass_block", MushroomGrassBlock::new);
    public static final DeferredBlock<Block> GLOWING_MUSHROOM = NatureBlocks.registerWithoutItem("glowing_mushroom", () -> new MushroomBlock(ISpreadable.Type.GLOWING, (Block)MUSHROOM_GRASS_BLOCK.get()));
    public static final DeferredBlock<IndusiumBlock> GLOWING_MUSHROOM_INDUSIUM_BLOCK = NatureBlocks.registerWithItem("glowing_mushroom_indusium_block", IndusiumBlock::new);
    public static final DeferredBlock<RotatedPillarBlock> GLOWING_MUSHROOM_STEM_BLOCK = NatureBlocks.registerWithItem("glowing_mushroom_stem_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM)));
    public static final DeferredBlock<GlowingMushroomPileusBlock> GLOWING_MUSHROOM_PILEUS_BLOCK = NatureBlocks.registerWithItem("glowing_mushroom_pileus_block", () -> new GlowingMushroomPileusBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM)));
    public static final DeferredBlock<IndusiumBlock> LIFE_MUSHROOM_INDUSIUM_BLOCK = NatureBlocks.registerWithItem("life_mushroom_indusium_block", IndusiumBlock::new);
    public static final DeferredBlock<RotatedPillarBlock> LIFE_MUSHROOM_STEM_BLOCK = NatureBlocks.registerWithItem("life_mushroom_stem_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM)));
    public static final DeferredBlock<GlowingMushroomPileusBlock> LIFE_MUSHROOM_PILEUS_BLOCK = NatureBlocks.registerWithItem("life_mushroom_pileus_block", () -> new GlowingMushroomPileusBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM)));
    public static final LogBlockSet GLOWING_MUSHROOM_LOG_BLOCKS = LogBlockSet.builder("glowing_mushroom", true, LogBlockSet.WoodSetType.GLOWING_MUSHROOM).log(null).strippedLog(null).wood(null).strippedWood(null).leaves(null).build();
    public static final LogBlockSet PALM_LOG_BLOCKS = LogBlockSet.builder("palm", true, LogBlockSet.WoodSetType.PALM).leaves(PalmLeaves::new).sapling(properties -> new BaseSaplingBlock(ModFeatures.TreeGrowers.PALM_GROWER, (BlockBehaviour.Properties)properties, null, new Supplier[]{NatureBlocks.getSupplier(Blocks.SAND), NatureBlocks.getSupplier(Blocks.RED_SAND), NatureBlocks.getSupplier(Blocks.GRASS_BLOCK), MOISTENED_SAND_BLOCK, MOISTENED_RED_SAND_BLOCK})).build();
    public static final DeferredBlock<Block> DESERT_TAPERED_BLOCK = NatureBlocks.registerWithItem("desert_tapered_block", TaperedTwoPartBlock::new);
    public static final DeferredBlock<DesertPlantBlock> SMALL_DESERT_PLANT = NatureBlocks.registerWithItem("small_desert_plant", () -> new DesertPlantBlock(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)));
    public static final DeferredBlock<DesertPlantBlock> BIG_DESERT_PLANT = NatureBlocks.registerWithItem("big_desert_plant", () -> new DesertPlantBlock(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)));
    public static final DeferredBlock<SmallCactusBlock> SMALL_CACTUS = NatureBlocks.registerWithItem("small_cactus", SmallCactusBlock::new);
    public static final DeferredBlock<Block> DESERT_GRASS = NatureBlocks.registerWithItem("desert_grass", () -> new BasePlantBlock(Blocks.SAND, Blocks.RED_SAND));
    public static final DeferredBlock<Block> DESERT_TALL_GRASS = NatureBlocks.registerWithItem("desert_tall_grass", () -> new BaseTallPlantBlock(Blocks.SAND, Blocks.RED_SAND));
    public static final DeferredBlock<Block> PACKED_DIRT = NatureBlocks.registerWithItem("packed_dirt", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.0f, 1.0f).sound(SoundType.STONE).mapColor(MapColor.COLOR_BROWN)));
    public static final LogBlockSet BAOBAB_LOG_BLOCKS = LogBlockSet.builder("baobab", true, LogBlockSet.WoodSetType.BAOBAB).sapling(properties -> new BaseSaplingBlock(ModFeatures.TreeGrowers.BAOBAB_GROWER, (BlockBehaviour.Properties)properties, null, NatureBlocks.getSupplier(Blocks.GRASS_BLOCK), NatureBlocks.getSupplier(Blocks.DIRT))).build();
    public static final LogBlockSet YELLOW_WILLOW_LOG_BLOCKS = LogBlockSet.builder("yellow_willow", true, LogBlockSet.WoodSetType.YELLOW_WILLOW).sapling(properties -> new BaseSaplingBlock(ModFeatures.TreeGrowers.YELLOW_WILLOW_GROWER, (BlockBehaviour.Properties)properties, null, NatureBlocks.getSupplier(Blocks.GRASS_BLOCK), NatureBlocks.getSupplier(Blocks.DIRT))).build();
    public static final LogBlockSet SPOOKY_LOG_BLOCKS = LogBlockSet.builder("spooky", true, LogBlockSet.WoodSetType.SPOOKY).build();
    public static final LogBlockSet LIVING_LOG_BLOCKS = LogBlockSet.builder("living", true, LogBlockSet.WoodSetType.LIVING).leaves(properties -> new TransparentLeavesBlock(properties.noOcclusion())).build();
    public static final LogBlockSet LIVING_MAHOGANY_LOG_BLOCKS = LogBlockSet.builder("living_mahogany", true, LogBlockSet.WoodSetType.LIVING_MAHOGANY).leaves(properties -> new TransparentLeavesBlock(properties.noOcclusion())).build();
    public static final DeferredBlock<Block> ASH_BLOCK = NatureBlocks.registerWithItem("ash_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).strength(1.0f, 1.0f).sound(SoundType.SAND).mapColor(MapColor.TERRACOTTA_GRAY)));
    public static final DeferredBlock<Block> ASH_GRASS_BLOCK = NatureBlocks.registerWithItem("ash_grass_block", AshGrassBlock::new);
    public static final LogBlockSet ASH_LOG_BLOCKS = LogBlockSet.builder("ash", false, LogBlockSet.WoodSetType.ASH).leaves(null).sapling(properties -> new BaseSaplingBlock(ModFeatures.TreeGrowers.ASH_GROWER, (BlockBehaviour.Properties)properties, null, new Supplier[]{ASH_BLOCK, ASH_GRASS_BLOCK})).build();
    public static final DeferredBlock<Block> ASH_GRASS = NatureBlocks.registerWithItem("ash_grass", () -> new BasePlantBlock((Block)ASH_GRASS_BLOCK.get()));
    public static final DeferredBlock<Block> JUNGLE_GRASS_BLOCK = NatureBlocks.registerWithItem("jungle_grass_block", () -> new JungleGrassBlock(ISpreadable.Type.JUNGLE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).mapColor(MapColor.COLOR_GREEN)));
    public static final DeferredBlock<ThornBlock> JUNGLE_THORN = NatureBlocks.registerWithItem("jungle_thorn", () -> new ThornBlock(3.4f, Blocks.MOSS_BLOCK));
    public static final DeferredBlock<ThornBlock> PLANTERA_THORN = NatureBlocks.registerWithItem("plantera_thorn", () -> new ThornBlock(20.0f, Blocks.MUD));
    public static final DeferredBlock<JungleSporeBlock> JUNGLE_SPORE = NatureBlocks.registerWithoutItem("jungle_spore", JungleSporeBlock::new);
    public static final DeferredBlock<NaturesGiftBlock> NATURES_GIFT = NatureBlocks.registerWithoutItem("natures_gift", NaturesGiftBlock::new);
    public static final DeferredBlock<JungleHiveBlock> JUNGLE_HIVE_BLOCK = NatureBlocks.registerWithItem("jungle_hive_block", JungleHiveBlock::new);
    public static final DeferredBlock<NaturesGiftBlock> JUNGLE_ROSE = NatureBlocks.registerWithItem("jungle_rose", NaturesGiftBlock::new);
    public static final DeferredBlock<LarvaBlock> LARVA = NatureBlocks.registerWithItem("larva", () -> new LarvaBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noOcclusion().replaceable().instabreak()));
    public static final DeferredBlock<Block> JUNGLE_PATH = NatureBlocks.registerWithItem("mud_path", () -> new MudPathBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD).mapColor(MapColor.COLOR_LIGHT_GRAY)));
    public static final DeferredBlock<Block> MUSHROOM_PATH = NatureBlocks.registerWithItem("mushroom_path", () -> new MudPathBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD).mapColor(MapColor.COLOR_LIGHT_GRAY)));
    public static final DeferredBlock<Block> ASH_PATH = NatureBlocks.registerWithItem("ash_path", () -> new AshPathBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ASH_BLOCK.get())).mapColor(MapColor.COLOR_GRAY)));
    public static final LogBlockSet DYNASTY_LOG_BLOCKS = LogBlockSet.builder("dynasty", true, LogBlockSet.WoodSetType.DYNASTY).leaves(null).build();
    public static final DeferredBlock<CloudBlock> CLOUD_BLOCK = NatureBlocks.registerWithItem("cloud_block", () -> new CloudBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).mapColor(MapColor.SNOW).strength(0.3f).sound(SoundType.SNOW).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor((blockState, blockGetter, blockPos) -> false).isSuffocating((blockState, blockGetter, blockPos) -> false)));
    public static final DeferredBlock<EvaporativeCloudBlock> EVAPORATIVE_CLOUD_BLOCK = NatureBlocks.registerWithItem("evaporative_cloud_block", () -> new EvaporativeCloudBlock(BlockBehaviour.Properties.of().sound(SoundType.SNOW).noOcclusion().randomTicks()));
    public static final Supplier<BlockEntityType<EvaporativeCloudBlock.BEntity>> EVAPORATIVE_CLOUD_BLOCK_ENTITY = ModBlocks.BLOCK_ENTITIES.register("evaporative_cloud_block", () -> BlockEntityType.Builder.of(EvaporativeCloudBlock.BEntity::new, (Block[])new Block[]{(Block)EVAPORATIVE_CLOUD_BLOCK.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<ParticleCloudBlock> RAIN_CLOUD_BLOCK = NatureBlocks.registerWithItem("rain_cloud_block", () -> new ParticleCloudBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).strength(0.3f).sound(SoundType.SNOW).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor((blockState, blockGetter, blockPos) -> false).isSuffocating((blockState, blockGetter, blockPos) -> false), (ParticleOptions)ParticleTypes.FALLING_WATER));
    public static final DeferredBlock<ParticleCloudBlock> SNOW_CLOUD_BLOCK = NatureBlocks.registerWithItem("snow_cloud_block", () -> new ParticleCloudBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).strength(0.3f).sound(SoundType.SNOW).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor((blockState, blockGetter, blockPos) -> false).isSuffocating((blockState, blockGetter, blockPos) -> false), (ParticleOptions)ParticleTypes.SNOWFLAKE));
    public static final DeferredBlock<Block> STELLAR_BLOSSOM = NatureBlocks.registerWithItem("stellar_blossom", () -> new StellarBlossomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).offsetType(BlockBehaviour.OffsetType.NONE)));
    public static final DeferredBlock<Block> CLOUDWEAVER = NatureBlocks.registerWithItem("cloudweaver", () -> new CloudWeaverBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).offsetType(BlockBehaviour.OffsetType.NONE)));
    public static final DeferredBlock<Block> FLOATING_WHEAT = NatureBlocks.registerWithItem("floating_wheat", () -> new FloatingWheatBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).offsetType(BlockBehaviour.OffsetType.NONE)));
    public static final DeferredBlock<Block> AMBER_BRANCHES = NatureBlocks.registerWithItem("amber_branches", () -> new BranchesBlock(ModTags.Blocks.JEWELLERY_BRANCHES_ATTACHABLE, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD));
    public static final DeferredBlock<Block> RUBY_BRANCHES = NatureBlocks.registerWithItem("ruby_branches", () -> new BranchesBlock(ModTags.Blocks.JEWELLERY_BRANCHES_ATTACHABLE, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD));
    public static final DeferredBlock<Block> TOPAZ_BRANCHES = NatureBlocks.registerWithItem("topaz_branches", () -> new BranchesBlock(ModTags.Blocks.JEWELLERY_BRANCHES_ATTACHABLE, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD));
    public static final DeferredBlock<Block> JADE_BRANCHES = NatureBlocks.registerWithItem("jade_branches", () -> new BranchesBlock(ModTags.Blocks.JEWELLERY_BRANCHES_ATTACHABLE, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD));
    public static final DeferredBlock<Block> DIAMOND_BRANCHES = NatureBlocks.registerWithItem("diamond_branches", () -> new BranchesBlock(ModTags.Blocks.JEWELLERY_BRANCHES_ATTACHABLE, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD));
    public static final DeferredBlock<Block> SAPPHIRE_BRANCHES = NatureBlocks.registerWithItem("sapphire_branches", () -> new BranchesBlock(ModTags.Blocks.JEWELLERY_BRANCHES_ATTACHABLE, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD));
    public static final DeferredBlock<Block> AMETHYST_BRANCHES = NatureBlocks.registerWithItem("amethyst_branches", () -> new BranchesBlock(ModTags.Blocks.JEWELLERY_BRANCHES_ATTACHABLE, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD));
    public static final DeferredBlock<Block> ASH_BRANCHES = NatureBlocks.registerWithItem("ash_branches", () -> new BranchesBlock(ModTags.Blocks.ASH_LOG_BRANCHES_ATTACHABLE, ModTags.Blocks.ASH_LOG_BRANCHES_ATTACHABLE));
    public static final DeferredBlock<Block> YELLOW_WILLOW_DROOPING_LEAVES = NatureBlocks.registerWithItem("yellow_willow_drooping_leaves", () -> new BaseDroopingPlantsHeadBlock(14, false, false, (Block)NatureBlocks.YELLOW_WILLOW_LOG_BLOCKS.LEAVES.get()));
    public static final DeferredBlock<Block> GLOWING_MUSHROOM_VINE = NatureBlocks.registerWithItem("glowing_mushroom_vine", () -> new BaseDroopingPlantsHeadBlock(6, true, true));
    public static final DeferredBlock<Block> FOREST_DROOPING_VINE = NatureBlocks.registerWithItem("forest_drooping_vine", () -> new BaseDroopingPlantsHeadBlock(10, true, true));
    public static final DeferredBlock<Block> JUNGLE_DROOPING_VINE = NatureBlocks.registerWithItem("jungle_drooping_vine", () -> new BaseDroopingPlantsHeadBlock(10, true, true));
    public static final DeferredBlock<Block> CORRUPT_DROOPING_VINE = NatureBlocks.registerWithItem("corrupt_drooping_vine", () -> new BaseDroopingPlantsHeadBlock(10, true, true));
    public static final DeferredBlock<Block> CRIMSON_DROOPING_VINE = NatureBlocks.registerWithItem("crimson_drooping_vine", () -> new BaseDroopingPlantsHeadBlock(10, true, true));
    public static final DeferredBlock<Block> HALLOW_DROOPING_VINE = NatureBlocks.registerWithItem("hallow_drooping_vine", () -> new BaseDroopingPlantsHeadBlock(10, true, true));
    public static final DeferredBlock<Block> SHIMMER_DROOPING_VINE = NatureBlocks.registerWithoutItem("shimmer_drooping_vine", () -> new ShimmerDroopingVinesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAVE_VINES)));
    public static final DeferredBlock<Block> SHIMMER_DROOPING_VINE_PLANT = NatureBlocks.registerWithoutItem("shimmer_drooping_vine_plant", () -> new ShimmerDroopingVinesPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAVE_VINES_PLANT)));
    public static final DeferredBlock<Block> BLINKING_ROYAL_SHIMMERLILY = NatureBlocks.registerWithItem("blinking_royal_shimmerlily", () -> new BlinkingRoyalShimmerlilyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD)), BlinkingRoyalShimmerlilyBlock.BItem::new);
    public static final DeferredBlock<BaseMossBlock> GREEN_MOSS = NatureBlocks.registerWithItem("green_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> BROWN_MOSS = NatureBlocks.registerWithItem("brown_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> RED_MOSS = NatureBlocks.registerWithItem("red_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> BLUE_MOSS = NatureBlocks.registerWithItem("blue_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> PURPLE_MOSS = NatureBlocks.registerWithItem("purple_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> LAVA_MOSS = NatureBlocks.registerWithItem("lava_moss", () -> new BaseMossBlock(10, true));
    public static final DeferredBlock<BaseMossBlock> KRYPTON_MOSS = NatureBlocks.registerWithItem("krypton_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> XENON_MOSS = NatureBlocks.registerWithItem("xenon_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> ARGON_MOSS = NatureBlocks.registerWithItem("argon_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> NEON_MOSS = NatureBlocks.registerWithItem("neon_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> HELIUM_MOSS = NatureBlocks.registerWithItem("helium_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<BaseMossBlock> GLOWING_MUSHROOM_MOSS = NatureBlocks.registerWithItem("glowing_mushroom_moss", () -> new BaseMossBlock(5));
    public static final DeferredBlock<CrimsonVenusFlytrapBlock> CRIMSON_VENUS_FLYTRAP_BLOCK = NatureBlocks.registerWithItem("crimson_venus_flytrap_block", CrimsonVenusFlytrapBlock::new);
    public static final DeferredBlock<BloodthirstCrystallizedBlock> BLOODTHIRST_CRYSTALLIZED_BLOCK = NatureBlocks.registerWithItem("bloodthirst_crystallized_block", BloodthirstCrystallizedBlock::new);
    public static final Supplier<BlockEntityType<BloodthirstCrystallizedBlock.BEntity>> BLOODTHIRST_CRYSTALLIZED_ENTITY = ModBlocks.BLOCK_ENTITIES.register("bloodthirst_crystallized_entity", () -> BlockEntityType.Builder.of(BloodthirstCrystallizedBlock.BEntity::new, (Block[])new Block[]{(Block)BLOODTHIRST_CRYSTALLIZED_BLOCK.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<CorrodedWormRootsBlock> CORRODED_WORM_ROOTS_BLOCK = NatureBlocks.registerWithItem("corroded_worm_roots_block", CorrodedWormRootsBlock::new);
    public static final DeferredBlock<CorruptedOvariesBlock> CORRUPTED_OVARIES_BLOCK = NatureBlocks.registerWithItem("corrupted_ovaries_block", CorruptedOvariesBlock::new);
    public static final DeferredBlock<DecomposeTheSourceExtractBlock> DECOMPOSE_THE_SOURCE_EXTRACT_BLOCK = NatureBlocks.registerWithItem("decompose_the_source_extract_block", DecomposeTheSourceExtractBlock::new);
    public static final Supplier<BlockEntityType<DecomposeTheSourceExtractBlock.BEntity>> DECOMPOSE_THE_SOURCE_EXTRACT_ENTITY = ModBlocks.BLOCK_ENTITIES.register("decompose_the_source_extract_entity", () -> BlockEntityType.Builder.of(DecomposeTheSourceExtractBlock.BEntity::new, (Block[])new Block[]{(Block)DECOMPOSE_THE_SOURCE_EXTRACT_BLOCK.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<ShimmerCrystalslBlock> SHIMMER_CRYSTALS_BLOCK = NatureBlocks.registerWithItem("shimmer_crystals_block", ShimmerCrystalslBlock::new);
    public static final DeferredBlock<LostPaperBlock> LOST_PAPER_BLOCK = NatureBlocks.registerWithItem("lost_paper", LostPaperBlock::new);
    public static final Supplier<BlockEntityType<LostPaperBlock.BEntity>> LOST_PAPER_ENTITY = ModBlocks.BLOCK_ENTITIES.register("lost_paper", () -> BlockEntityType.Builder.of(LostPaperBlock.BEntity::new, (Block[])new Block[]{(Block)LOST_PAPER_BLOCK.get()}).build(DSL.remainderType()));

    private static <B extends Block> DeferredBlock<B> registerWithoutItem(String id, Supplier<B> block) {
        return BLOCKS.register(id, block);
    }

    private static <B extends Block> DeferredBlock<B> registerWithItem(String id, Supplier<B> block) {
        DeferredBlock object = BLOCKS.register(id, block);
        ModItems.BLOCK_ITEMS.registerSimpleBlockItem((Holder)object);
        return object;
    }

    private static <B extends Block> DeferredBlock<B> registerWithItem(String id, Supplier<B> block, Function<B, BlockItem> function) {
        DeferredBlock object = BLOCKS.register(id, block);
        ModItems.BLOCK_ITEMS.register(id, () -> (BlockItem)function.apply((Block)object.get()));
        return object;
    }

    private static Supplier<Block> getSupplier(Block block) {
        return () -> block;
    }
}

